<?php
// No direct access to this file
defined('_JEXEC') or die('Restricted access');
 
/**
 * Script file of Siniestro
 */
class pkg_SiniestroInstallerScript
{
        /**
         * method to install the component
         *
         * @return void
         */
        function install($parent) 
        {
                // $parent is the class calling this method
                //$parent->getParent()->setRedirectURL('index.php?option=com_componentname');
				//echo '<p>' . JText::_('PKG_SINIESTRO_INSTALL_TEXT') . '</p>';
				
				// update tinymce
				$db = JFactory::getDBO();
				$db->setQuery("SELECT e.params FROM #__extensions AS e WHERE e.name='plg_editors_tinymce'");
				$data = new JRegistry($db->loadResult());
				$data->set('extended_elements', $data->get('extended_elements').',+button[*],+a[*],+i[*],+em[*],+li[*],+span[*],+div[*]');
				$db->setQuery("UPDATE #__extensions AS e SET e.params='".$data->toString()."' WHERE e.name='plg_editors_tinymce'");
				$db->query();
        }
 
        /**
         * method to uninstall the component
         *
         * @return void
         */
        function uninstall($parent) 
        {
                // $parent is the class calling this method
                //echo '<p>' . JText::_('PKG_SINIESTRO_UNINSTALL_TEXT') . '</p>';
        }
 
        /**
         * method to update the component
         *
         * @return void
         */
        function update($parent) 
        {
                // $parent is the class calling this method
                //echo '<p>' . JText::sprintf('PKG_SINIESTRO_UPDATE_TEXT', $parent->get('manifest')->version) . '</p>';
        }
 
        /**
         * method to run before an install/update/uninstall method
         *
         * @return void
         */
        function preflight($type, $parent) 
        {
                // $parent is the class calling this method
                // $type is the type of change (install, update or discover_install)
                //echo '<p>' . JText::_('PKG_SINIESTRO_PREFLIGHT_' . $type . '_TEXT') . '</p>';
        }
 
        /**
         * method to run after an install/update/uninstall method
         *
         * @return void
         */
        function postflight($type, $parent, $results) 
        {
                // $parent is the class calling this method
                // $type is the type of change (install, update or discover_install)
                
				self::enabledExtension('warpfossil');
				
				//echo '<p>' . JText::_('PKG_SINIESTRO_POSTFLIGHT_' . $type . '_TEXT') . '</p>';
				
				$extensions = array();
				foreach($results as $result) {
					$extensions[] = (object) array('name' => JText::_($result['name']), 'status' => $result['result'], 'message' => $result['result'] ? ($type == 'update' ? 'Updated' : 'Installed').' successfully' : 'NOT Installed');
				}

				// display extension installation results
				self::displayResults($extensions, 'Extensions', 'Extension');
				
        }
		
		protected function displayResults($result, $name, $type) {

?>

		<h3><?php echo JText::_($name); ?></h3>
		<table class="adminlist table table-bordered table-striped" width="100%">
			<thead>
				<tr>
					<th class="title"><?php echo JText::_($type); ?></th>
					<th width="60%"><?php echo JText::_('Status'); ?></th>
				</tr>
			</thead>
			<tfoot>
				<tr>
					<td colspan="2">&nbsp;</td>
				</tr>
			</tfoot>
			<tbody>
				<?php
					foreach ($result as $i => $ext) : ?>
					<tr class="row<?php echo $i++ % 2; ?>">
						<td class="key"><?php echo $ext->name; ?></td>
						<td>
							<?php $style = $ext->status ? 'font-weight: bold; color: green;' : 'font-weight: bold; color: red;'; ?>
							<span style="<?php echo $style; ?>"><?php echo JText::_($ext->message); ?></span>
						</td>
					</tr>
				<?php endforeach; ?>
			</tbody>
		</table>

<?php

		}
		
		function enabledExtension($element)
		{
			$row = JTable::getInstance('extension');
			if ($row->load($row->find(array('element' => $element))) && strlen($row->element)) {
				$row->enabled = 1;
				$row->store();
			}
		}
}
