<?php
defined('_JEXEC') or die;

class SiniestroImage
{
	/*
	@$type
	  0 - exact = The exact height and width dimensions you set. (Default)
	  1 - portrait = Whatever height is passed in will be the height that is set. The width will be calculated and set automatically to a the value that keeps the original aspect ratio. 
	  2 - landscape = The same but based on the width. We try make the image the biggest size we can while stil fitting inside the box size
	  3 - auto = Depending whether the image is landscape or portrait, this will automatically determine whether to resize via dimension 1,2 or 0
	  4 - crop = Will resize and then crop-(tr) the image for best fit. 
	  															tl 	top left
																t 	top (middle).
																tr 	top right.
																l 	left
																m 	middle (image center)
																r 	right
																bl 	bottom left
																b 	bottom (middle)
																br 	bottom right 
																or the exact position. eg. "50x60".
 	@$antialias
		sharpen - set as true if you would like shapening applied to your resized image    
	*/
	
	public static function createThumb($file, $path_output, $width = 150, $height = 150, $type = 3, $force_jpg = true, $check_size = false, $antialias = true)
	{
		require_once(dirname(__FILE__).DIRECTORY_SEPARATOR.'php_image_magician.php');
		jimport( 'joomla.filesystem.file' );
		jimport('joomla.filesystem.folder');
		
		if(!is_writable(JPATH_ROOT.DIRECTORY_SEPARATOR.'cache')) return $file;
		
		if($check_size){
			$size = getimagesize($file);
			$width = (int)$size[0] <= (int)$width ? $size[0] : $width;
			$height = (int)$size[1] <= (int)$height ? $size[1] : $height;
		}
		
		$fileName 	= JFile::getName(JFile::stripExt($file));
		$ext 		= '.'.JFile::getExt($file);
		
		if($force_jpg) $ext = '.jpg';
		
		$output 	= $path_output.DIRECTORY_SEPARATOR.$fileName.'_'.$width.'x'.$height.'-'.$type.$ext;
		
		if(JFile::exists(JPATH_ROOT.DIRECTORY_SEPARATOR.$output)){
			return JURI::root().$output;
		}
		
		if (JFile::exists(JPATH_ROOT.DIRECTORY_SEPARATOR.$file)) 
		{
			if (JFolder::exists(JPATH_ROOT.DIRECTORY_SEPARATOR.$path_output) || JFolder::create(JPATH_ROOT.DIRECTORY_SEPARATOR.$path_output)) 
			{
				$imageLibObj = new imageLib($file);
				$imageLibObj->resizeImage($width, $height, $type, $antialias);
				$imageLibObj->saveImage(JPATH_ROOT.DIRECTORY_SEPARATOR.$output, 100);

				return JURI::root().$output;
			}
		}
		
		return JURI::root().'images'.DIRECTORY_SEPARATOR.'no-image.png';
		
	}
	
}
