/* jce - 2.9.54 | 2023-11-12 | https://www.joomlacontenteditor.net | Copyright (C) 2006 - 2023 Ryan Demmer. All rights reserved | GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html */
function IeCursorFix() {
    return !0;
}

function jInsertEditorText(text, editor) {
    try {
        WfEditor.insert(editor, text);
    } catch (e) {}
}

!function() {
    var each = tinymce.each, extend = tinymce.extend, DOM = tinymce.DOM, Event = tinymce.dom.Event, Dispatcher = tinymce.util.Dispatcher;
    function isHidden(el) {
        return (el = "string" == typeof el ? document.getElementById(el) : el) && "none" === el.style.display;
    }
    var JoomlaEditor = {
        register: function(editor) {
            if ("undefined" != typeof JceDecorator) return !0;
            Joomla.editors && (Joomla.editors.instances[editor.id] = {
                getValue: function() {
                    return WfEditor.getContent(editor.id);
                },
                setValue: function(value) {
                    WfEditor.setContent(editor.id, value);
                },
                getSelection: function() {
                    return WfEditor.getSelection(editor.id, {
                        format: "text"
                    });
                },
                replaceSelection: function(value) {
                    return WfEditor.insert(editor.id, value);
                },
                disable: function(disabled) {
                    return editor.setMode(disabled ? "readonly" : "design");
                },
                id: editor.id,
                instance: editor,
                onSave: function() {}
            });
        },
        unregister: function(editor) {
            var instance, editor = editor.getElement();
            if ("undefined" != typeof JceDecorator) return !((instance = JoomlaEditor.get(editor.id)) && instance instanceof JoomlaEditorDecorator) || JoomlaEditor.unregister(instance);
            Joomla.editors && delete Joomla.editors.instances[editor.id];
        }
    }, WfEditor = {
        bookmark: null,
        options: {},
        getSite: function(base) {
            var u = document.location.href, host = -1 !== base.indexOf("http") ? (host = base.substr(base.indexOf("://") + 3)).substr(host.indexOf("/")) : u.substr(0, u.indexOf(base) + base.length);
            return -1 !== u.indexOf("/administrator/") && (host += "administrator/"), 
            host;
        },
        init: function(settings) {
            var params, base = settings.base_url, site = this.getSite(base), indent = (/https:\/\//.test(document.location.href) && (base = base.replace(/http:/, "https:")), 
            window.tinyMCEPreInit = {}, settings.query = (params = settings.query, 
            Object.keys(params).map(function(k) {
                return encodeURIComponent(k) + "=" + encodeURIComponent(params[k]);
            }).join("&")), extend(tinymce, {
                baseURL: base + "media/com_jce/editor/tinymce",
                suffix: "",
                query: settings.query
            }), "p,h1,h2,h3,h4,h5,h6,blockquote,div,title,style,pre,script,td,ul,li,area,table,thead,tfoot,tbody,tr,section,article,hgroup,aside,figure,object,video,audio");
            if (this.settings = this.settings || extend({
                document_base_url: base,
                site_url: site,
                mode: "textareas",
                schema: "mixed",
                relative_urls: !0,
                entity_encoding: "raw",
                editor_selector: "wf-editor",
                editor_deselector: "wf-no-editor",
                urlconverter_callback: "WFEditor.convertURL",
                popup_css: !1,
                add_form_submit_trigger: !1,
                submit_patch: !1,
                theme: "none",
                skin_directionality: "ltr",
                invalid_elements: "applet,iframe,object,embed,script,style,body,bgsound,base,basefont,frame,frameset,head,html,id,ilayer,layer,link,meta,name,title,xml",
                plugins: "",
                external_plugins: {},
                whitespace_elements: "pre,script,style,textarea,code",
                allow_conditional_comments: !0,
                allow_event_attributes: !1,
                fix_list_elements: !0,
                indent_before: indent,
                indent_after: indent,
                keep_styles: !1,
                update_styles: !0,
                constrain_menus: !1,
                compress: {
                    css: !0,
                    javascript: !0
                },
                language_load: !1
            }, settings), this.settings) try {
                var sl, URI, s = this.settings;
                s.compress.css && extend(this.settings, {
                    content_css: !1,
                    editor_css: !1
                }), this.markLoaded(), s.skip_plugin_languages && (sl = tinymce.ScriptLoader, 
                URI = tinyMCE.baseURI, each(s.skip_plugin_languages.split(","), function(n) {
                    n && (sl.markDone(URI.toAbsolute("plugins/" + n + "/langs/" + s.language + ".js")), 
                    sl.add(URI.toAbsolute("plugins/" + n + "/langs/en.js")));
                })), WFEditor.load();
            } catch (e) {
                console.debug(e);
            }
        },
        markLoaded: function() {
            var s = this.settings, each = tinymce.each, ln = s.language.split(","), suffix = s.suffix || "";
            function load(u) {
                tinymce.ScriptLoader.markDone(tinyMCE.baseURL + "/" + u);
            }
            1 == s.compress.javascript && (each(s.external_plugins, function(url, name) {
                load(url);
            }), each(s.plugins.split(","), function(n) {
                n && (load("plugins/" + n + "/plugin" + suffix + ".js"), each(ln, function(c) {
                    c && load("plugins/" + n + "/langs/" + c + ".js");
                }));
            })), each([ "core", "help", "autolink", "cleanup", "code", "format", "importcss", "colorpicker", "upload", "blobupload", "figure", "ui", "noneditable", "branding" ], function(n) {
                load("plugins/" + n + "/plugin" + suffix + ".js");
            });
        },
        setBookmark: function(ed) {
            Event.add(document.body, "mousedown", function(e) {
                !function(el) {
                    return DOM.getParent(el, "div.mceEditor, div.mceSplitButtonMenu, div.mceListBoxMenu, div.mceDropDown");
                }(e.target) && !function(ed) {
                    return ed.isHidden() || "hidden" == DOM.getStyle(ed.id + "_ifr", "visibility");
                }(ed) && ed.selection && (e = ed.selection.getNode(), DOM.getParent(e, "body#tinymce")) && (ed.lastSelectionBookmark = ed.selection.getBookmark(1));
            });
        },
        load: function() {
            var loaded, self = this;
            function _load() {
                loaded || (loaded = !0, self.preinit());
            }
            tinymce.settings = this.settings, tinyMCE.onAddEditor.add(function(mgr, ed) {
                var el = ed.getElement(), settings = tinymce.settings;
                "advanced" === ed.settings.theme && (window.Joomla && (Joomla.getOptions && (ed.settings = extend(ed.settings, Joomla.getOptions("plg_editor_jce", {}))), 
                JoomlaEditor.register(ed)), settings.compress.css && ed.onPreInit.add(function() {
                    ed.dom.loadCSS(settings.site_url + "index.php?option=com_jce&task=editor.pack&type=css&slot=content");
                }), self.canToggle() && self.createToggle(el), self.createTabs(ed), 
                self.setBookmark(ed), ed.onInit.add(function() {
                    var bookmark;
                    ed.onSubmit.addToTop(function() {
                        ed.initialized && ed.getElement() && (ed.isNotDirty = 1, 
                        self.getContent(ed.id));
                    }), ed.settings.refocus && (bookmark = sessionStorage.getItem(ed.id + "_bookmark")) && ed === tinymce.activeEditor && window.setTimeout(function() {
                        self.setActiveLine(ed, bookmark);
                    }, 10);
                }), ed.onBeforeRenderUI.add(function() {
                    var n = ed.getElement().form;
                    !n || n._mceOldSubmit || n.submit.nodeType || n.submit.length || ((ed.formElement = n)._mceOldSubmit = n.submit, 
                    n.submit = function() {
                        return tinymce.each(tinymce.editors, function(e) {
                            e.initialized && e.getElement() && (e.isNotDirty = 1, 
                            self.getContent(e.id));
                        }), ed.formElement._mceOldSubmit(ed.formElement);
                    });
                }), ed.onPostRender.add(function() {
                    var el = ed.getElement(), el = self.getEditorState(el), toggle = tinymce.is(ed.settings.toggle) ? parseInt(ed.settings.toggle, 10) : 0;
                    !el && toggle && (ed.hide(), ed.plugins.source && ed.plugins.source.hide(), 
                    ed.plugins.preview) && ed.plugins.preview.hide();
                }), ed.onWfEditorChange = new Dispatcher(), ed.onWfEditorChange.add(function(ed, o) {
                    tinymce.is(o.content) && (ed.setContent(o.content, o), ed.onChange.dispatch());
                }), ed.onSaveContent.add(function() {
                    var bookmark = self.getActiveLine(ed);
                    sessionStorage.setItem(ed.id + "_bookmark", bookmark);
                }), ed.onRemove.add(function() {
                    var nodes, container = DOM.getParent(ed.getElement(), "div.wf-editor-container");
                    container && (nodes = tinymce.grep(DOM.select("div", container), function(node) {
                        return node !== ed.getElement() && node !== ed.getContainer();
                    }), DOM.remove(nodes), DOM.remove(container, 1));
                }));
            }), Event.bind(window, "load", function() {
                _load(), self.initSubformEvents();
            }), Event.bind(window, "ready", function() {
                window.setTimeout(function() {
                    _load();
                }, 1e3);
            });
        },
        initSubformEvents: function() {
            var self = this, settings = this.settings;
            function removeEditor(el) {
                el = tinymce.EditorManager.get(el.id);
                el && (el.remove(), el.destroy(!0), JoomlaEditor.unregister(el));
            }
            function createEditor(el) {
                var ed = tinymce.EditorManager.get(el.id);
                ed || (self.createInstance(el), ed = new tinymce.Editor(el.id, settings)), 
                ed.render();
            }
            function rebuildEditor(row) {
                row = DOM.select(".wf-editor-container > textarea[id]", row);
                each(row, function(el) {
                    removeEditor(el), createEditor(el);
                });
            }
            window.jQuery && (jQuery("div.subform-repeatable").on("subform-row-add", function(event, row) {
                row = DOM.select(".wf-editor", row);
                each(row, function(el) {
                    createEditor(el);
                });
            }).on("subform-row-remove", function(event, row) {
                row = DOM.select(".wf-editor", row);
                each(row, function(el) {
                    removeEditor(el);
                });
            }), jQuery(document).on("editor-reinit", function(e, row) {
                rebuildEditor(row);
            }), jQuery(document).on("sortstop", function(e, ui) {
                ui.item[0] && rebuildEditor(ui.item[0]);
            })), Event.add(document, "subform-row-add", function(e, row) {
                (row = e.detail ? e.detail.row : null) && (e = DOM.select(".wf-editor", row), 
                each(e, function(el) {
                    createEditor(el);
                }));
            }), Event.add(document, "subform-row-remove", function(e) {
                var e = e.detail ? e.detail.row : null;
                e && (e = DOM.select(".wf-editor", e), each(e, function(el) {
                    removeEditor(el);
                }));
            }), Event.add(document, "sortstop", function(e) {
                e = e.detail ? e.detail.row : null;
                e && rebuildEditor(e);
            }), Event.add(DOM.select("joomla-field-subform.subform-repeatable"), "dragend", function(e) {
                rebuildEditor(e.target);
            });
        },
        isEditorActive: function(elm) {
            return 0 == DOM.hasClass(elm, "wf-no-editor");
        },
        canToggle: function() {
            var settings = this.settings;
            return tinymce.is(settings.toggle) ? parseInt(settings.toggle, 10) : 0;
        },
        getEditorState: function(el) {
            var state, s = this.settings;
            return null == (state = !1 !== s.use_state_cookies ? tinymce.util.Storage.get("wf_editor_state_" + el.id) : state) && (state = tinymce.is(s.toggle_state) ? s.toggle_state : 1), 
            state = parseInt(state, 10);
        },
        createInstance: function(el) {
            var header, s = this.settings;
            if (el = "string" == typeof el ? DOM.get(el) : el) return header = DOM.getPrev(el, ".wf-editor-header"), 
            s.width && DOM.setStyle(el, "width", s.width), s.height && DOM.setStyle(el, "height", s.height), 
            s = this.getEditorState(el), !(this.canToggle() && (this.createToggle(el), 
            !s) && (DOM.addClass(el, "wf-no-editor"), DOM.hide(DOM.select(".wf-editor-tabs", header)), 
            DOM.addClass(el.parentNode, "wf-editor-toggle-off"), 1));
        },
        create: function(elements) {
            var ed;
            return "string" == typeof elements && ((ed = tinymce.get(elements)) && tinymce.remove(ed), 
            elements = [ elements ]), this.preinit(elements);
        },
        preinit: function(elements) {
            var self = this, settings = this.settings;
            try {
                elements = elements || DOM.select(".wf-editor"), each(elements, function(elm) {
                    var editorId;
                    (elm = DOM.get(elm)) && (editorId = function(elm) {
                        var id = elm.id;
                        return id || (id = (id = elm.name) && !DOM.get(id) ? elm.name : DOM.uniqueId(), 
                        elm.setAttribute("id", id)), id;
                    }(elm), tinymce.get(editorId) || (DOM.show(elm), "advanced" == settings.theme && self.createInstance(elm), 
                    new tinymce.Editor(editorId, settings, tinymce.EditorManager).render()));
                });
            } catch (e) {}
        },
        toggleEditor: function(el) {
            var activeTab, height, ed = tinymce.get(el.id);
            if (ed) if (DOM.hasClass(el, "wf-no-editor")) switch (DOM.removeClass(el, "wf-no-editor"), 
            DOM.setStyle(DOM.select(".wf-editor-tabs", el.parentNode), "display", ""), 
            DOM.removeClass(el.parentNode, "wf-editor-toggle-off"), !1 !== this.settings.use_state_cookies && tinymce.util.Storage.set("wf_editor_state_" + el.id, 1), 
            (activeTab = !1 !== this.settings.use_state_cookies ? sessionStorage.getItem("wf-editor-tabs-" + ed.id) : activeTab) || ed.settings.active_tab, 
            DOM.hide(ed.getElement()), activeTab) {
              default:
              case "wf-editor-wysiwyg":
                ed.show();
                break;

              case "wf-editor-source":
                ed.plugins.source.toggle();
                break;

              case "wf-editor-preview":
                ed.plugins.preview.toggle();
            } else DOM.addClass(el, "wf-no-editor"), DOM.hide(DOM.select(".wf-editor-tabs", el.parentNode)), 
            DOM.addClass(el.parentNode, "wf-editor-toggle-off"), (height = !1 !== this.settings.use_state_cookies ? sessionStorage.getItem("wf-editor-container-height") : height) && !ed.getParam("fullscreen_enabled") && DOM.setStyle(ed.getElement(), "height", height), 
            !1 !== this.settings.use_state_cookies && tinymce.util.Storage.set("wf_editor_state_" + el.id, 0), 
            ed.hide(), this.getContent(ed.id), ed.plugins.source && ed.plugins.source.hide(), 
            ed.plugins.preview && ed.plugins.preview.hide(), DOM.setStyle(ed.getElement(), "display", ""); else DOM.addClass(el.parentNode, "mce-loading"), 
            DOM.removeClass(el, "wf-no-editor"), DOM.removeClass(el.parentNode, "wf-editor-toggle-off"), 
            !1 !== this.settings.use_state_cookies && tinymce.util.Storage.set("wf_editor_state_" + el.id, 1), 
            tinymce.execCommand("mceToggleEditor", !1, el.id), setTimeout(function() {
                DOM.removeClass(el.parentNode, "mce-loading");
            }, 1e3);
        },
        getActiveTab: function(ed) {
            var ed = DOM.select(".wf-editor-tabs > button.active", ed.getElement().parentNode);
            return ed.length && (ed = ed[0].getAttribute("aria-controls")) ? ed.substring(10) : "wysiwyg";
        },
        getEditor: function(el) {
            var ed, win = window;
            return !win.tinymce && window.parent.tinymce && (win = window.parent), 
            !(!(ed = (ed = (el = el && ("string" == typeof el ? document.getElementById(el) : el)) && el.id ? win.tinymce.get(el.id) : ed) || win.tinymce.activeEditor) || !ed.getElement()) && ("wysiwyg" == (el = this.getActiveTab(ed)) ? ed : "source" == el && ed.plugins.source);
        },
        loadContent: function(ed) {
            var code, el = ed.getElement();
            isHidden(ed.id + "_parent") && ed.plugins.source && null !== (code = ed.plugins.source.getContent()) && (/TEXTAREA|INPUT/i.test(el.nodeName) ? el.value = code : el.innerHTML = code, 
            ed.load());
        },
        createToggle: function(el) {
            var self = this, s = this.settings, header = (header = DOM.getPrev(el, ".wf-editor-header")) || this.createHeader(el);
            0 === DOM.select("button.wf-editor-toggle", header).length && (header = DOM.add(header, "button", {
                class: "wf-editor-toggle btn btn-link",
                tabindex: "-1"
            }, '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 448 448"><title></title><g id="wf-toggle-icon" stroke="none" stroke-width="1"></g><path d="M280 64.132v59.482c15.84 6.914 30.406 16.803 42.995 29.391 26.443 26.442 41.005 61.6 41.005 98.995s-14.563 72.552-41.005 98.995c-26.442 26.442-61.599 41.005-98.995 41.005s-72.552-14.563-98.995-41.005c-26.442-26.442-41.005-61.6-41.005-98.995s14.563-72.552 41.005-98.995c12.589-12.589 27.155-22.478 42.995-29.392v-59.481c-80.959 24.097-140 99.082-140 187.868 0 108.248 87.753 196 196 196s196-87.752 196-196c0-88.786-59.041-163.77-140-187.868zM196 0h56v224h-56z"></path></svg>' + (s.toggle_label || "")), 
            Event.add(header, "click", function(e) {
                e.preventDefault(), self.toggleEditor(el);
            }));
        },
        setActiveLine: function(ed, pos) {
            var len, blocks = [];
            pos && !(pos < 1) && (tinymce.each(ed.schema.getBlockElements(), function(value, name) {
                if (/\W/.test(name)) return !0;
                blocks.push(name.toLowerCase());
            }), pos = ed.dom.select(blocks.join(","))[pos - 1] || null) && (ed.focus(), 
            len = pos.childNodes.length, ed.selection.setCursorLocation(pos, len), 
            ed.selection.scrollIntoView(pos));
        },
        getActiveLine: function(ed) {
            var blocks = [], line = 0, node = (tinymce.each(ed.schema.getBlockElements(), function(value, name) {
                if (/\W/.test(name)) return !0;
                blocks.push(name.toLowerCase());
            }), ed.selection.getNode()), nodes = ed.dom.select(blocks.join(","));
            if (node) {
                1 === node.nodeType && "bookmark" !== node.getAttribute("data-mce-type") || (node = node.parentNode);
                for (var i = 0, len = nodes.length; i < len; i++) if (nodes[i] === node) {
                    line = i;
                    break;
                }
            }
            return line;
        },
        toggleTab: function(ed, tab) {
            var h, ca, p, self = this, el = ed.getElement();
            return DOM.addClass(el.parentNode, "mce-loading"), isHidden(ed.id + "_parent") || DOM.hasClass(el.parentNode, "mce-fullscreen") || (ed.settings.container_height = ed.getContainer().offsetHeight, 
            !1 !== this.settings.use_state_cookies && sessionStorage.setItem("wf-editor-container-height", ed.settings.container_height), 
            ed.settings.container_width = ed.getContainer().offsetWidth, !1 !== this.settings.use_state_cookies && sessionStorage.setItem("wf-editor-container-width", ed.settings.container_width), 
            ed.settings.interface_height = (h = 0, ca = ed.getContentAreaContainer(), 
            p = ca.parentNode, tinymce.each(p.childNodes, function(n) {
                n !== ca && (h += n.offsetHeight);
            }), h), !1 !== this.settings.use_state_cookies && sessionStorage.setItem("wf-editor-interface-height", ed.settings.interface_height)), 
            "wf-editor-source" === tab ? (ed.hide(), DOM.hide(el), ed.plugins.preview && ed.plugins.preview.hide(), 
            ed.plugins.source.toggle()) : "wf-editor-preview" === tab ? (self.loadContent(ed), 
            ed.hide(), DOM.hide(el), ed.plugins.source && ed.plugins.source.hide(), 
            ed.onToggleTab.dispatch(ed, tab), ed.plugins.preview.toggle()) : (self.loadContent(ed), 
            ed.plugins.source && ((p = ed.plugins.source.getCursorPos()) && (ed.activeLine = p), 
            ed.plugins.source.hide()), ed.plugins.preview && ed.plugins.preview.hide(), 
            DOM.setStyle(ed.id + "_ifr", "max-width", DOM.getStyle(el.parentNode, "max-width")), 
            ed.show(), ed.activeLine && ed === tinymce.activeEditor && window.setTimeout(function() {
                self.setActiveLine(ed, ed.activeLine);
            }, 100), void DOM.removeClass(el.parentNode, "mce-loading"));
        },
        createHeader: function(element) {
            var container = DOM.create("div", {
                class: "editor wf-editor-container"
            }, '<div class="wf-editor-header"></div>');
            return element.parentNode.insertBefore(container, element), DOM.add(container, element), 
            container.firstChild;
        },
        createTabs: function(ed) {
            var self = this, settings = this.settings, el = ed.getElement(), plugins = settings.plugins.split(",");
            if (tinymce.inArray(plugins, "preview") < 0 && tinymce.inArray(plugins, "source", plugins) < 0) return !1;
            var tablist, activeTab, header = (header = DOM.getPrev(el, ".wf-editor-header")) || this.createHeader(el);
            function makeTabActive(tab) {
                DOM.removeClass(DOM.select("button", tablist), "active"), DOM.setAttrib(DOM.select("button", tablist), "aria-expanded", "false"), 
                DOM.addClass(tab, "active"), DOM.setAttrib(tab, "aria-expanded", "true");
            }
            DOM.select(".wf-editor-tabs", header).length || (ed.onToggleTab = new tinymce.util.Dispatcher(ed), 
            tablist = DOM.add(header, "div", {
                role: "tablist",
                class: "wf-editor-tabs nav nav-tabs"
            }), activeTab = (activeTab = !1 !== settings.use_state_cookies ? sessionStorage.getItem("wf-editor-tabs-" + ed.id) : activeTab) || ed.settings.active_tab || "wf-editor-wysiwyg", 
            ed.settings.active_tab = activeTab, makeTabActive(DOM.add(tablist, "button", {
                type: "button",
                class: "nav-item",
                "aria-controls": "wf-editor-wysiwyg"
            }, ed.getLang("tab.wysiwyg", "Editor"))), -1 !== tinymce.inArray(plugins, "source") && (header = DOM.add(tablist, "button", {
                type: "button",
                class: "nav-item",
                "aria-controls": "wf-editor-source"
            }, ed.getLang("tab.code", "Code")), "wf-editor-source" === activeTab) && makeTabActive(header), 
            -1 !== tinymce.inArray(plugins, "preview") && (header = DOM.add(tablist, "button", {
                type: "button",
                class: "nav-item",
                "aria-controls": "wf-editor-preview"
            }, ed.getLang("tab.preview", "Preview")), "wf-editor-preview" === activeTab) && makeTabActive(header), 
            Event.add(tablist, "click", function(e) {
                e.preventDefault();
                var e = DOM.getParent(e.target, "button");
                e && !DOM.hasClass(e, "active") && (makeTabActive(e), e = DOM.getAttrib(e, "aria-controls"), 
                !1 !== settings.use_state_cookies && sessionStorage.setItem("wf-editor-tabs-" + ed.id, e), 
                self.toggleTab(ed, e));
            }), plugins = this.getEditorState(el), activeTab = tinymce.is(settings.toggle) ? parseInt(settings.toggle, 10) : 0, 
            !plugins && activeTab && DOM.hide(DOM.select(".wf-editor-tabs", el.parentNode)));
        },
        textareaResize: function(el) {
            var container = DOM.getPrev(el, ".wf-editor-header").parentNode;
            Event.add(el, "mousedown", function(e) {
                var mm = Event.add(el, "mousemove", function(e) {
                    container.style.maxWidth = el.offsetWidth + "px";
                }), mu = Event.add(el, "mouseup", function(e) {
                    Event.remove(el, "mousemove", mm), Event.remove(el, "mouseup", mu), 
                    container.style.maxWidth = el.offsetWidth + "px";
                });
            });
        },
        wrapText: function(el, s) {
            s ? el.setAttribute("wrap", "soft") : el.removeAttribute("wrap");
        },
        setContent: function(id, html) {
            var ed = this.getEditor(id);
            ed ? ed.setContent(html) : (ed = document.getElementById(id)) && (ed.value = html);
        },
        getContent: function(id) {
            var state, ed = this.getEditor(id);
            return ed ? (id = document.getElementById(id), state = this.isEditorActive(id), 
            ed && state ? ed.save() : id ? id.value : "") : "";
        },
        getSelection: function(id, args) {
            id = this.getEditor(id);
            return id ? id.getSelection(args || {}) : document.getSelection().toString();
        },
        insert: function(el, v) {
            var ed = this.getEditor(el);
            return ed ? ed.execCommand ? isHidden((ed = ed !== tinymce.activeEditor ? tinymce.activeEditor : ed).getElement()) ? (ed.lastSelectionBookmark && ed.selection.moveToBookmark(ed.lastSelectionBookmark), 
            ed.execCommand("mceInsertContent", !1, v)) : this.insertIntoTextarea(ed.getElement(), v) : ed.insertContent(v) : (el = "string" == typeof el ? document.getElementById(el) : el) && !isHidden(el) && this.insertIntoTextarea(el, v), 
            !0;
        },
        insertIntoTextarea: function(el, v) {
            el.focus(), document.selection ? document.selection.createRange().text = v : el.setRangeText(v, el.selectionStart, el.selectionEnd, "end");
        },
        convertURL: function(url, elm, save, name) {
            var ed = tinymce.EditorManager.activeEditor, s = tinymce.settings, base = s.document_base_url;
            if (url && s.convert_urls && (!elm || "LINK" !== elm.nodeName) && 0 !== url.indexOf("file:") && url !== base && url !== base.substring(0, base.length - 1) && "/" !== url.charAt(0)) {
                if (!s.mixed_urls) {
                    if (s.relative_urls) return 0 === url.indexOf(base) ? ed.documentBaseURI.toRelative(url) : url;
                    url = ed.documentBaseURI.toAbsolute(url, s.remove_script_host);
                }
                s.protocol_relative && (url = url.replace(/(http|https|ftp|ftps):\/\//, "//"));
            }
            return url;
        },
        indent: function(h) {
            return h = h.replace(/\n+/g, "\n"), tinymce.trim(h);
        }
    };
    window.WfEditor = window.WFEditor = WfEditor;
}();