<?php
// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');

// Load the controller framework
jimport('joomla.application.component.controller');

/**
* Class Description
*
* @package VirtueMart
*/
class VirtueMartInstagramController extends JControllerLegacy
{	
	public function __construct() {
		parent::__construct();
		
		// $this->addViewPath(JPATH_PLUGINS.DS . 'vmextended' . DS . 'custom' . DS . 'views');
	}

	/**
	 * Method to display a view.
	 *
	 * @param   boolean  $cachable   If true, the view output will be cached
	 * @param   array    $urlparams  An array of safe URL parameters and their variable types, for valid values see {@link JFilterInput::clean()}.
	 *
	 * @return  ContentController  This object to support chaining.
	 *
	 * @since   1.5
	 */
	public function display($cachable = false, $urlparams = array())
	{
		$view   = $this->input->get('view', 'instagram');
		$layout = $this->input->get('layout', 'default');
		$id     = $this->input->getInt('id');

		$view = $this->getView($view, 'raw');
				
		if ($view)
		{			
			// Push the model into the view (as default).
			// $model = $this->getModel($vName);
			// $view->setModel($model, true);

			// Push document object into the view.
			$view->document = JFactory::getDocument();

			$view->display();
		}

		return $this;
	}

	private function getHeader()
	{
		return array(
			'id',
			'title',
			'description',
			'availability',
			'condition',
			'price',
			'link',
			'image_link',
			'brand',
			// 'additional_image_link',
			// 'age_group',
			// 'color',
			// 'gender',
			// 'item_group_id',
			// 'google_product_category',
			// 'material',
			// 'pattern',
			// 'product_type',
			'sale_price'
			// 'sale_price_effective_date',
			// 'shipping',
			// 'shipping_weight	size',
			// 'custom_label_0',
			// 'custom_label_1',
			// 'custom_label_2',
			// 'custom_label_3',
			// 'custom_label_4'
		);
	}

	private function getItems()
	{
		$db = JFactory::getDbo();

		$query = $db->getQuery(true);

		// $query
		// 	->select(array('a.*', 'b.username', 'b.name'))
		// 	->from($db->quoteName('#__content', 'a'))
		// 	->join('INNER', $db->quoteName('#__users', 'b') . ' ON ' . $db->quoteName('a.created_by') . ' = ' . $db->quoteName('b.id'))
		// 	->where($db->quoteName('b.username') . ' LIKE ' . $db->quote('a%'))
		// 	->order($db->quoteName('a.created') . ' DESC');
		
		$query = "SELECT 
				p.virtuemart_product_id,
				p.product_in_stock,
				pes.product_name,
				pes.product_s_desc,
				p.product_sku,
				pp.product_price,
				pp.product_currency,
				pp.override,
				pp.product_override_price,
				(
					SELECT GROUP_CONCAT(ces.category_name) 
					FROM #__virtuemart_product_categories pc 
					LEFT JOIN #__virtuemart_categories_es_es ces ON ces.virtuemart_category_id = pc.virtuemart_category_id 
					WHERE pc.virtuemart_product_id=p.virtuemart_product_id
				) as categories_name,
				(
					SELECT GROUP_CONCAT(ces.virtuemart_category_id) 
					FROM #__virtuemart_product_categories pc 
					LEFT JOIN #__virtuemart_categories_es_es ces ON ces.virtuemart_category_id = pc.virtuemart_category_id 
					WHERE pc.virtuemart_product_id=p.virtuemart_product_id
				) as categories_id,
				(
					SELECT GROUP_CONCAT(mes.mf_name) 
					FROM #__virtuemart_product_manufacturers pm 
					LEFT JOIN #__virtuemart_manufacturers_es_es mes ON mes.virtuemart_manufacturer_id = pm.virtuemart_manufacturer_id 
					WHERE pm.virtuemart_product_id=p.virtuemart_product_id
				) as brand,
				(
					SELECT GROUP_CONCAT(DISTINCT CONCAT_WS(':', m.file_url) ORDER BY CONCAT_WS(':', pm.ordering, m.file_url) ASC)
					FROM #__virtuemart_product_medias pm 
					LEFT JOIN #__virtuemart_medias m ON m.virtuemart_media_id = pm.virtuemart_media_id 
					WHERE pm.virtuemart_product_id=p.virtuemart_product_id
					ORDER BY pm.ordering ASC
				) as images
			FROM #__virtuemart_products p
			LEFT JOIN #__virtuemart_products_es_es pes ON pes.virtuemart_product_id = p.virtuemart_product_id 
			LEFT JOIN #__virtuemart_product_prices pp ON pp.virtuemart_product_id = p.virtuemart_product_id
			WHERE p.published = 1
		";

		$db->setQuery($query);
		$results = $db->loadObjectList("virtuemart_product_id");

		$productModel = VmModel::getModel('product');
		// $vmresults = $productModel->getProducts(array_keys($results));
				
		$products = array();
		$products_errors = array();

		foreach ($results as $key => $result)
		{
			$product = $productModel->getProducts( array($key) );

			if(!isset($product[0])){
				continue;
			}

			$product = $product[0];
			$domain  = JUri::base();

			$currency = $product->prices['product_currency'] == 174 ? 'UYU' : 'USD';
			// $product->sale_price = $product->prices['product_price'] ? $product->prices['product_price'] * 1.22 : 0;
			$product->sale_price = $product->prices['salesPrice'] ? $product->prices['salesPrice'] : 0;
			$product->sale_price = number_format($product->sale_price, 2, '.', '');

			$product->prices['product_override_price'] = $product->override ? number_format($product->prices['product_override_price'], 2, '.', '') : $product->sale_price;
			
			$images = explode(",", $results[$product->virtuemart_product_id]->images);
			$categories_id = explode(",", $results[$product->virtuemart_product_id]->categories_id);

			$stock = (($product->product_in_stock - $product->product_ordered) < 1) ? 'out of stock' : 'in stock';

			$csv_product = array();
			$csv_product['id'] = $product->virtuemart_product_id;
			$csv_product['title'] = $product->product_name;
			$csv_product['description'] = $product->product_desc ? strip_tags($product->product_desc) : $product->product_s_desc;
			$csv_product['availability'] = $stock;
			$csv_product['condition'] = 'new';
			$csv_product['price'] = "{$product->sale_price} {$currency}";
			$csv_product['link'] = JUri::root() . trim( JRoute::_( $product->link ), '/' );
			$csv_product['image_link'] = $images[0] ? $domain.$images[0] : JURI::base() . "components/com_virtuemart/assets/images/vmgeneral/no-image.jpg";
			$csv_product['brand'] = JFactory::getConfig()->get('sitename');
			$csv_product['sale_price'] = "{$product->prices['product_override_price']} {$currency}";

			if($images[0] && $product->sale_price && $categories_id[0]){
				$products[] = $csv_product;
			}else {
				$products_errors[] = $csv_product;
			}
		}

		return (object) array( 'products' => $products, 'products_errors' => $products_errors);
	}

	function array2csv(array &$array)
	{
		if (count($array) == 0) {
			return null;
		}

		ob_start();
		// $df = fopen("php://output", 'w');
		// $df = fopen('php://temp', 'r+');
		$df = fopen(JPATH_BASE . '/instagram_shopping.csv', 'w');
		
		fputcsv($df, array_keys(reset($array)), $delimiter = ",", $enclosure = '"');
		
		foreach ($array as $row) {
			fputcsv($df, $row, $delimiter = ",", $enclosure = '"');
		}
		
		// rewind($df);
		// $out = fgets($csv);
		fclose($df);
		return trim(ob_get_clean());
	}

	// index.php?option=com_virtuemart&controller=instagram&task=csv&tmpl=raw
	public function csv()
	{
		header('Content-Type: text/html; charset=utf-8');
		// header("Content-Disposition: attachment; filename=instagram_shopping.csv");
		// header("Pragma: no-cache");
		// header("Expires: 0");

		$result = $this->getItems();
		$products = $result->products;

		$out = $this->array2csv($products);

		echo '<strong>Total de productos exportados: </strong>' . count($products) . '<br><br>';
		echo '<a href="'.JURI::base().'instagram_shopping.csv" target="_blank">Descargar CSV</a><br><br>';
		echo '<strong>Cron: </strong> wget --no-check-certificate -O /dev/null "'.JURI::base().'index.php?option=com_virtuemart&controller=instagram&task=csv&tmpl=raw" >/dev/null 2>&1 <br><br>';
		echo '<strong>Detalle de productos NO exportados (No tienen imagen, o no tienen precio, o no tienen categoria): </strong>' . count($result->products_errors) . '<br>';
		echo '<strong>Nota: </strong> No necesariamente son errores ya que pueden ser productos hijos.<br><br>';

		

		foreach ($result->products_errors as $key => $product) {
			echo '<a href="' . $product['link'] . '" target="_blank" >'. $product['title'] . '</a><br>';
		}


		echo $out;

		die();
		// jexit();
	}
}