<?php
/**
 *
  *
 * @author Facundo Perdomo, edited by Gonzalo Pigni
 * @version $Id: pagosweb.php 28-04-2015 
 * @package VirtueMart
 * @subpackage payment
 * @copyright Copyright (C) 2015 - All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 * VirtueMart is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See /administrator/components/com_virtuemart/COPYRIGHT.php for copyright notices and details.
 *
 * http://virtuemart.org
 */
 
defined ('_JEXEC') or die('Restricted access');

if (!class_exists('vmPSPlugin')) {
	require(JPATH_VM_PLUGINS . DS . 'vmpsplugin.php');
}

class plgVmPaymentPagosWeb extends vmPSPlugin {

	// instance of class
	function __construct (& $subject, $config) {

		parent::__construct ($subject, $config);

		$this->_loggable = TRUE;
		$this->tableFields = array_keys ($this->getTableSQLFields ());
		$this->_tablepkey = 'id'; 
		$this->_tableId = 'id'; 
		$varsToPush = array('pagosweb_merchant_email'  => array('', 'char'),// Configuracion de PagosWeb
		                    'pagosweb_verified_only'   => array('', 'int'),
							'llave3D' 				 => array('', 'char'), //PagosWeb 
							'idCliente'				 => array('', 'int'),  //PagosWeb 
							'idTarjeta'				 => array('', 'int'),  //PagosWeb
							'version'				 => array('', 'int'),  //PagosWeb 
							'plazo_entrega'			 => array('', 'char'), //PagosWeb 
							'request_url'			 => array('', 'char'), //PagosWeb 
							'plan'			 		 => array('', 'int'),  //PagosWeb 
		                    'payment_currency'       => array('', 'int'),  //PagosWeb 
							'cantCuotas'             => array('', 'int'),
		                    'email_currency'         => array('', 'int'),
		                    'log_ipn'                => array('', 'int'),
		                    'sandbox'                => array(0, 'int'),
		                    'sandbox_merchant_email' => array('', 'char'),
		                    'payment_logos'          => array('', 'char'),
		                    'debug'                  => array(0, 'int'),
		                    'status_pending'         => array('', 'char'),
		                    'status_success'         => array('', 'char'),
		                    'status_canceled'        => array('', 'char'),
		                    'countries'              => array('', 'char'),
		                    'min_amount'             => array('', 'int'),
		                    'max_amount'             => array('', 'int'),
		                    'secure_post'            => array('', 'int'),
		                    'ipn_test'               => array('', 'int'),
		                    'no_shipping'            => array('', 'int'),
		                    'address_override'       => array('', 'int'),
		                    'cost_per_transaction'   => array('', 'int'),
		                    'cost_percent_total'     => array('', 'int'),
		                    'tax_id'                 => array(0, 'int')
		);
		$this->setConfigParameterable ($this->_configTableFieldName, $varsToPush);
	}

	/**
	 * @return string
	 * Uso la misma tabla que pagosweb (28/04/2015, le cambio nombre)
	 */
	public function getVmPluginCreateTableSQL () {
		return $this->createTableSQL('Payment PagosWeb Table');
	}

	/**
	 * @return array
	 * Tabla de pagosweb
	 */
	function getTableSQLFields () {

		$SQLfields = array(
			'id'                                     => 'int(11) UNSIGNED NOT NULL AUTO_INCREMENT',
			'virtuemart_order_id'                    => 'int(1) UNSIGNED',
			'order_number'                           => 'char(64)',
			'virtuemart_paymentmethod_id'            => 'mediumint(1) UNSIGNED',
			'payment_name'                           => 'varchar(5000)',
			'payment_order_total'                    => 'decimal(15,5) NOT NULL',
			'payment_currency'                       => 'smallint(1)',
			'email_currency'                         => 'smallint(1)',
			'cost_per_transaction'                   => 'decimal(10,2)',
			'cost_percent_total'                     => 'decimal(10,2)',
			'tax_id'                                 => 'smallint(1)',
			'pagosweb_custom'                          => 'varchar(255)',
			'pagosweb_response_mc_gross'               => 'decimal(10,2)',
			'pagosweb_response_mc_currency'            => 'char(10)',
			'pagosweb_response_invoice'                => 'char(32)',
			'pagosweb_response_protection_eligibility' => 'char(128)',
			'pagosweb_response_payer_id'               => 'char(13)',
			'pagosweb_response_tax'                    => 'decimal(10,2)',
			'pagosweb_response_payment_date'           => 'char(28)',
			'pagosweb_response_payment_status'         => 'char(50)',
			'pagosweb_response_pending_reason'         => 'char(50)',
			'pagosweb_response_mc_fee'                 => 'decimal(10,2)',
			'pagosweb_response_payer_email'            => 'char(128)',
			'pagosweb_response_last_name'              => 'char(64)',
			'pagosweb_response_first_name'             => 'char(64)',
			'pagosweb_response_business'               => 'char(128)',
			'pagosweb_response_receiver_email'         => 'char(128)',
			'pagosweb_response_transaction_subject'    => 'char(128)',
			'pagosweb_response_residence_country'      => 'char(2)',
			'pagosweb_response_txn_id'                 => 'char(32)',
			'pagosweb_response_txn_type'               => 'char(32)', //The kind of transaction for which the IPN message was sent
			'pagosweb_response_parent_txn_id'          => 'char(32)',
			'pagosweb_response_case_creation_date'     => 'char(32)',
			'pagosweb_response_case_id'                => 'char(32)',
			'pagosweb_response_case_type'              => 'char(32)',
			'pagosweb_response_reason_code'            => 'char(32)',
			'pagoswebresponse_raw'                     => 'varchar(512)',
		);
		return $SQLfields;
	}

	/**
	 * @param $cart
	 * @param $order
	 * @return bool|null
	 * Confirmación a la hora de comprar
	 */
	function plgVmConfirmedOrder ($cart, $order) {

		if (!($method = $this->getVmPluginMethod ($order['details']['BT']->virtuemart_paymentmethod_id))) {
			return NULL; // Selecciona otro metodo de pago
		}
		if (!$this->selectedThisElement ($method->payment_element)) {
			return FALSE; 
		}
		$this->_debug = $method->debug;
		$session = JFactory::getSession (); 
		$return_context = $session->getId ();
		$this->logInfo ('plgVmConfirmedOrder order number: ' . $order['details']['BT']->order_number, 'message');

		if (!class_exists ('VirtueMartModelOrders')) {
			require(JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'orders.php');
		}
		if (!class_exists ('VirtueMartModelCurrency')) {
			require(JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'currency.php');
		}
	
		$address = ((isset($order['details']['ST'])) ? $order['details']['ST'] : $order['details']['BT']); //Toma los datos de la factura

		if (!class_exists ('TableVendors')) {
			require(JPATH_VM_ADMINISTRATOR . DS . 'table' . DS . 'vendors.php');
		}
		$vendorModel = VmModel::getModel ('Vendor');
		$vendorModel->setId (1);
		$vendor = $vendorModel->getVendor ();
		$vendorModel->addImages ($vendor, 1);
		$this->getPaymentCurrency ($method);
		$email_currency = $this->getEmailCurrency ($method);
		$currency_code_3 = shopFunctions::getCurrencyByID ($method->payment_currency, 'currency_code_3'); //Toma la moneda seleccionada en la configuracion
		

		$paymentCurrency = CurrencyDisplay::getInstance ($method->payment_currency);
		$totalInPaymentCurrency = round ($paymentCurrency->convertCurrencyTo ($method->payment_currency, $order['details']['BT']->order_total, FALSE), 2); //Calculo del total, tomado de pagosweb
		$cd = CurrencyDisplay::getInstance ($cart->pricesCurrency);
		if ($totalInPaymentCurrency <= 0) {
			vmInfo (vmText::_ ('VMPAYMENT_PAGOSWEB_PAYMENT_AMOUNT_INCORRECT'));
			return FALSE;
		}
		$merchant_email = $this->_getMerchantEmail($method);
		if (empty($merchant_email)) {
			vmInfo (vmText::_('VMPAYMENT_PAGOSWEB_MERCHANT_EMAIL_NOT_SET'));
			return FALSE;
		}
		$quantity = 0;
		foreach ($cart->products as $key => $product) {
			$quantity = $quantity + $product->quantity;
		}
		
		//Datos Pagos Web
		$email_contacto = $method->pagosweb_merchant_email;
		$plazo_entrega = $method->plazo_entrega;
		$version = $method->version;
		$idCliente = $method->idCliente;
		$idTarjeta = $method->idTarjeta;
		$request = $method->request_url;
		$llave = $method->llave3D;
		$plan = $method->plan;
		$moneda = $this->_tipoMoneda($currency_code_3);
		$cedula = $order['details']['BT']->cedula;
		$email = $order['details']['BT']->email;
		$primerNombre = $address->first_name;
		$primerApellido = $address->last_name;
		$telefono = $address->phone_1;
		$direccion = $address->address_1;
		$numeroOrden = $order['details']['BT']->order_number;
		$cuotas = $method->cantCuotas;
		$consumidor_final = $order['details']['BT']->consumidor_final;
		$importe_gravado = $totalInPaymentCurrency / 1.22;
		$numero_factura = $order['details']['BT']->virtuemart_order_id; //Se usa esto para que sea un numero y no un alfanumerico

		//esto es porque al registrar un user o uno viejo puede estar en null
		if($consumidor_final != 1)
		{
			$consumidor_final = "0";
		}
		$importe_gravado = round($importe_gravado, 2);

		//Encripto
		$totalAux = $totalInPaymentCurrency;
		$fechaTransaccion = date; 
		$TRANSACTION_AUX = ($idCliente . $idTarjeta . $primerNombre . $primerApellido . $cedula . $email  . $telefono . $direccion . $totalInPaymentCurrency . $cuotas . $moneda . $numeroOrden . $version . $plan . $plazo_entrega);
		$TRANSACTION_AUX_2 = ($consumidor_final . $importe_gravado . $numero_factura);
		$TRANSACTION_AUX =  $this->_encriptar($TRANSACTION_AUX, $TRANSACTION_AUX_2, $fechaTransaccion, $llave );
		
		$fechaTransaccion =  $fechaTransaccion("Y-m-dh:i:s");
		
		//Armo un array con los campos del post
		$post_variables = Array(
			'idCliente'  => $idCliente,
			'idTarjetaCredito' => $idTarjeta,
			'primerNombre'  => $primerNombre,
			'primerApellido' => $primerApellido,
			'segundoNombre' => "",
			'segundoApellido'  =>  "",
			'cedula'  => $cedula,
			'email'  => $email,
			'telefono'  => $telefono,
			'direccionEnvio' => $direccion,
			'valorTransaccion' => $totalAux,
			'cantidadCuotas'  => $cuotas, 
			'moneda' => $moneda,
			'numeroOrden'=>  $numeroOrden,
			'version' => $version,
			'plan' => $plan,  
			'plazoEntrega' => $plazo_entrega,
			'transactionSecurityToken' => $TRANSACTION_AUX,
			"additional"            => JROUTE::_ (JURI::root () . 'index.php?option=com_virtuemart&view=pluginresponse&task=pluginresponsereceived&on=' . $numeroOrden . '&pm=' . $order['details']['BT']->virtuemart_paymentmethod_id . '&Itemid=' . vRequest::getInt ('Itemid')) . ";" . JROUTE::_ (JURI::root () . 'index.php?option=com_virtuemart&view=pluginresponse&task=pluginUserPaymentCancel&on=' . $numeroOrden . '&pm=' . $order['details']['BT']->virtuemart_paymentmethod_id . '&Itemid=' . vRequest::getInt ('Itemid')),
			
			'fecha' => $fechaTransaccion,
			'consumidorFinal' => $consumidor_final,
			'importeGravado' => $importe_gravado,
			'numeroFactura' => $numero_factura);

	

		// Datos para llenar la tabla de las transacciones dentro del Virtue Mart
		$dbValues['order_number'] = $numeroOrden;
		$dbValues['payment_name'] = $this->renderPluginName ($method, $order);
		$dbValues['virtuemart_paymentmethod_id'] = $cart->virtuemart_paymentmethod_id;
		$dbValues['pagosweb_custom'] = $return_context;
		$dbValues['cost_per_transaction'] = $method->cost_per_transaction;
		$dbValues['cost_percent_total'] = $method->cost_percent_total;
		$dbValues['payment_currency'] = $method->payment_currency;
		$dbValues['email_currency'] = $email_currency;
		$dbValues['payment_order_total'] = $totalInPaymentCurrency;
		$dbValues['tax_id'] = $method->tax_id;
		
		$this->storePSPluginInternalData ($dbValues);


		// Armo el Post
		$html = '<html><head><title>Redirection</title></head><body><div style="margin: auto; text-align: center;">';
		$html .= '<form id="formRequestProcesor" action= ' . $request . ' method="post" name="vm_pagosweb_form" >';
		$html .= '<input type="submit"  value="' . vmText::_ ('VMPAYMENT_pagosweb_REDIRECT_MESSAGE') . '" />';
		foreach ($post_variables as $name => $value) {
			$html .= '<input type="hidden" id="' .$name. '" name="' . $name . '" value="' . htmlspecialchars ($value) . '" />';
		}
		 $html .= '</form></div>';
		 $html .= ' <script type="text/javascript">';
		 $html .= ' document.forms["formRequestProcesor"].submit()';
		 $html .= ' </script></body></html>';
		 vRequest::setVar ('html', $html, 'POST');
	}

	function _encriptar($DatosSinFecha, $DatosSinFechaLey, $fechaTransaccion, $llave){
	 //Vector de inicializacion 
    $iv = base64_decode(substr($fechaTransaccion("ymdhis"), 1) . '='); 
	
    //Datos de transaccion 
    $string = $DatosSinFecha . $fechaTransaccion("Y-m-dh:i:s") .$DatosSinFechaLey; 
    //Llave del comercio 
    $key = base64_decode($llave);
		
    
    function encryptNET3DES($key, $vector, $text){ 
        $td = mcrypt_module_open (MCRYPT_3DES, '', MCRYPT_MODE_CBC, ''); 
        $key_add = 24-strlen($key); 
        $key .= substr($key,0,$key_add); 
        $text_add = strlen($text)%8; 
        for($i=$text_add; $i<8; $i++)
		{ 
            $text .= chr(8-$text_add);
        } 
		mcrypt_generic_init ($td, $key, $vector); 
		$encrypt64 = mcrypt_generic ($td, $text); 
		mcrypt_generic_deinit($td); 
		mcrypt_module_close($td);
		
		return  base64_encode($encrypt64);
                         
    }
     $encryptedString =  encryptNET3DES($key, $iv, $string); 
     
	return $encryptedString;
}
	
	//Funcion para pasar la moneda de letras a Numeros
	function _tipoMoneda($monedaCarrito)
	{
		if ($monedaCarrito == 'UYU' || $monedaCarrito == 'UYI'){
			return '858';
		}
		if ($monedaCarrito == 'USD')
		{
			return '840';
		}
	}
	
	/**
	 * @param $virtuemart_paymentmethod_id
	 * @param $paymentCurrencyId
	 * @return bool|null
	 */
	 
	 
	function plgVmgetPaymentCurrency ($virtuemart_paymentmethod_id, &$paymentCurrencyId) {

		if (!($method = $this->getVmPluginMethod ($virtuemart_paymentmethod_id))) {
			return NULL; // Another method was selected, do nothing
		}
		if (!$this->selectedThisElement ($method->payment_element)) {
			return FALSE;
		}
		$this->getPaymentCurrency ($method);
		$paymentCurrencyId = $method->payment_currency;
	}

	/**
	 * @param $virtuemart_paymentmethod_id
	 * @param $paymentCurrencyId
	 * @return bool|null
	 */
	function plgVmgetEmailCurrency ($virtuemart_paymentmethod_id, $virtuemart_order_id, &$emailCurrencyId) {

		if (!($method = $this->getVmPluginMethod ($virtuemart_paymentmethod_id))) {
			return NULL; // Another method was selected, do nothing
		}
		if (!$this->selectedThisElement ($method->payment_element)) {
			return FALSE;
		}
		if (!($payments = $this->_getpagoswebInternalData ($virtuemart_order_id))) {
			// JError::raiseWarning(500, $db->getErrorMsg());
			return '';
		}
		if (empty($payments[0]->email_currency)) {
			$vendorId = 1; //VirtueMartModelVendor::getLoggedVendor();
			$db = JFactory::getDBO ();
			$q = 'SELECT   `vendor_currency` FROM `#__virtuemart_vendors` WHERE `virtuemart_vendor_id`=' . $vendorId;
			$db->setQuery ($q);
			$emailCurrencyId = $db->loadResult ();
		} else {
			$emailCurrencyId = $payments[0]->email_currency;
		}

	}

	/**
	 * @param $html
	 * @return bool|null|string
	 */
	function plgVmOnPaymentResponseReceived (&$html) {
		if (!class_exists('VirtueMartCart')) {
				require(VMPATH_SITE . DS . 'helpers' . DS . 'cart.php');
		}
		if (!class_exists('shopFunctionsF')) {
				require(VMPATH_SITE . DS . 'helpers' . DS . 'shopfunctionsf.php');
		}
		if (!class_exists('VirtueMartModelOrders')) {
				require(VMPATH_ADMIN . DS . 'models' . DS . 'orders.php');
		}
		VmConfig::loadJLang('com_virtuemart_orders', TRUE);
		$virtuemart_paymentmethod_id = vRequest::getInt('pm', 0);
		$order_number = vRequest::getString('on', 0);
		$vendorId = 0;
		if (!($this->_currentMethod = $this->getVmPluginMethod($virtuemart_paymentmethod_id))) {
			return NULL; // Another method was selected, do nothing
		}
		if (!$this->selectedThisElement($this->_currentMethod->payment_element)) {
			return NULL;
		}

		if (!($virtuemart_order_id = VirtueMartModelOrders::getOrderIdByOrderNumber($order_number))) {
			return NULL;
		}
		if (!($payments = $this->getDatasByOrderNumber($order_number))) {
			return '';
		}
		$payment_name = $this->renderPluginName($this->_currentMethod);
		$payment = end($payments);

		VmConfig::loadJLang('com_virtuemart');
 		$modelOrder = VmModel::getModel ('orders');
		$order = $modelOrder->getOrder($virtuemart_order_id);

		//Luego de comprar con PagosWeb
		//$pagosweb_data = vRequest::get ('post');
		$pagosweb_data = $_POST;
		$method = $this->getVmPluginMethod ($payments[0]->virtuemart_paymentmethod_id);
		$this->_debug = $method->debug;

		//TEST
		$this->logInfo ('order number:' . $order_number, 'message');
		$this->logInfo ('order id:' . $virtuemart_order_id, 'message');

		$lang = JFactory::getLanguage ();
		$order['customer_notified'] = 1;

		// 1. Chequeo el estado de la transacción
		if (($pagosweb_data['payment_status']) == 'Venta Aprobada' || ($pagosweb_data['payment_status']) == 'Venta Pendiente' ) {
			$this->logInfo ('Venta Aprobada', 'message');
			// 2. Chequeo que el id de transaccion ya no exista
			if ($this->_check_txn_id_already_processed ($payments, $pagosweb_data['txn_id'], $method)) {
				$this->logInfo ('Id Transaccion existe, retorono.', 'message');
				return;
			}
			// 3. Coloco la transaccion en el estado correspondiente
			$order['order_status'] = $method->status_success;
			$order['comments'] = vmText::sprintf('VMPAYMENT_PAGOSWEB_PAYMENT_STATUS_CONFIRMED', $order_number);
		} elseif (($pagosweb_data['payment_status']) == 'Venta Rechazada' || ($pagosweb_data['payment_status']) == 'Error al confimar') {
			$key = 'VMPAYMENT_PAGOSWEB_PENDING_REASON_FE_' . strtoupper ($pagosweb_data['pending_reason']);
			if (!$lang->hasKey ($key)) {
				$key = 'VMPAYMENT_PAGOSWEB_PENDING_REASON_FE_DEFAULT';
			}
			$html = $this->_getPaymentResponseHtmlRechazado ($paymentTable, $payment_name);
			$order['comments'] = vmText::sprintf('VMPAYMENT_PAGOSWEB_PAYMENT_STATUS_PENDING', $order_number) . vmText::_ ($key);
			$order['order_status'] = $method->status_canceled;
			$this->logInfo ('Venta Rechazada', 'message');
		} elseif (($pagosweb_data['payment_status']) == 'Venta Cancelada') {
			$order['order_status'] = $method->status_canceled;
			$this->logInfo ('Venta Cancelada', 'message');
		} else {
			$order['comments'] = vmText::sprintf('VMPAYMENT_PAGOSWEB_IPN_NOTIFICATION_RECEIVED');
			$order['customer_notified'] = 0;
			$this->logInfo ('No entra en ningnuno', 'message');
		}
		$this->_storepagoswebInternalData ($method, $pagosweb_data, $virtuemart_order_id, $payments[0]->virtuemart_paymentmethod_id);
		$this->logInfo ('plgVmOnPaymentResponseReceived return new_status:' . $order['order_status'], 'message');

		$modelOrder->updateStatusForOneOrder ($virtuemart_order_id, $order, TRUE);
		$html = $this->_getPaymentResponseHtml ($paymentTable, $payment_name);
		//Vacio el Carrito
		$cart = VirtueMartCart::getCart();
		$cart->emptyCart();
		return TRUE;
	}

	/**
	 * @return bool|null
	 */
	 //Cuando la transaccion es cancelada en PagosWeb
	function plgVmOnUserPaymentCancel () {
		$this->logInfo ('plgVmOnUserPaymentCancel test: ', 'message');
		if (!class_exists('VirtueMartModelOrders')) {
			require(VMPATH_ADMIN . DS . 'models' . DS . 'orders.php');
		}

		$order_number = vRequest::getString('on', '');
		$virtuemart_paymentmethod_id = vRequest::getInt('pm', '');
		if (empty($order_number) or empty($virtuemart_paymentmethod_id) or !$this->selectedThisByMethodId($virtuemart_paymentmethod_id)) {
			return NULL;
		}
		if (!($virtuemart_order_id = VirtueMartModelOrders::getOrderIdByOrderNumber($order_number))) {
			return NULL;
		}
		if (!($paymentTable = $this->getDataByOrderNumber($order_number))) {
			return NULL;
		}
		
	
		VmInfo (vmText::_('VMPAYMENT_PAGOSWEB_PAYMENT_CANCELLED'));
		$session = JFactory::getSession ();
		$return_context = $session->getId ();
		if (strcmp ($paymentTable->pagosweb_custom, $return_context) === 0) {
			$this->handlePaymentUserCancel ($virtuemart_order_id);
		}
		return TRUE;
	}

	/**
	 * @param $method
	 * @param $pagosweb_data
	 * @param $virtuemart_order_id
	 */
	function _storepagoswebInternalData ($method, $pagosweb_data, $virtuemart_order_id, $virtuemart_paymentmethod_id) {

		// get all know columns of the table
		$db = JFactory::getDBO ();
		$query = 'SHOW COLUMNS FROM `' . $this->_tablename . '` ';
		$db->setQuery ($query);
		$columns = $db->loadColumn(0);
		$post_msg = '';
		foreach ($pagosweb_data as $key => $value) {
			$post_msg .= $key . "=" . $value . "<br />";
			$table_key = 'pagosweb_response_' . $key;
			if (in_array ($table_key, $columns)) {
				$response_fields[$table_key] = $value;
			}
		}

		//$response_fields[$this->_tablepkey] = $this->_getTablepkeyValue($virtuemart_order_id);
		$response_fields['payment_name'] = $this->renderPluginName ($method);
		$response_fields['pagoswebresponse_raw'] = $post_msg;
		$response_fields['order_number'] = $pagosweb_data['invoice'];
		$response_fields['virtuemart_order_id'] = $virtuemart_order_id;
		$response_fields['virtuemart_paymentmethod_id'] = $virtuemart_paymentmethod_id;
		$response_fields['pagosweb_custom'] = $pagosweb_data['custom'];

		//$preload=true   preload the data here too preserve not updated data
		return $this->storePSPluginInternalData ($response_fields, $this->_tablepkey, 0);
	}

	/**
	 * Display stored payment data for an order
	 *
	 * @see components/com_virtuemart/helpers/vmPSPlugin::plgVmOnShowOrderBEPayment()
	 */
	function plgVmOnShowOrderBEPayment ($virtuemart_order_id, $payment_method_id) {

		if (!$this->selectedThisByMethodId ($payment_method_id)) {
			return NULL; // Another method was selected, do nothing
		}

		if (!($payments = $this->_getpagoswebInternalData ($virtuemart_order_id))) {
			// JError::raiseWarning(500, $db->getErrorMsg());
			return '';
		}

		$html = '<table class="adminlist" width="50%">' . "\n";
		$html .= $this->getHtmlHeaderBE ();
		$code = "pagosweb_response_";
		$first = TRUE;
		foreach ($payments as $payment) {
			$html .= '<tr class="row1"><td>' . vmText::_ ('VMPAYMENT_PAGOSWEB_DATE') . '</td><td align="left">' . $payment->created_on . '</td></tr>';
			// Now only the first entry has this data when creating the order
			if ($first) {
				$html .= $this->getHtmlRowBE ('PAGOSWEB_PAYMENT_NAME', $payment->payment_name);
				// keep that test to have it backwards compatible. Old version was deleting that column  when receiving an IPN notification
				if ($payment->payment_order_total and  $payment->payment_order_total != 0.00) {
					$html .= $this->getHtmlRowBE ('PAGOSWEB_PAYMENT_ORDER_TOTAL', $payment->payment_order_total . " " . shopFunctions::getCurrencyByID ($method->payment_currency, 'currency_code_3'));
				}
				if ($payment->email_currency and  $payment->email_currency != 0) {
					$html .= $this->getHtmlRowBE ('PAGOSWEB_PAYMENT_EMAIL_CURRENCY', shopFunctions::getCurrencyByID ($payment->email_currency, 'currency_code_3'));
				}
				$first = FALSE;
			}
			foreach ($payment as $key => $value) {
				// only displays if there is a value or the value is different from 0.00 and the value
				if ($value) {
					if (substr ($key, 0, strlen ($code)) == $code) {
						$html .= $this->getHtmlRowBE ($key, $value);
					}
				}
			}

		}
		$html .= '</table>' . "\n";
		return $html;
	}

	/**
	 * @param        $virtuemart_order_id
	 * @param string $order_number
	 * @return mixed|string
	 */
	function _getpagoswebInternalData ($virtuemart_order_id, $order_number = '') {
		if (empty($order_number)) {
			$orderModel = VmModel::getModel('orders');
			$order_number = $orderModel->getOrderNumber($virtuemart_order_id);
		}
		$db = JFactory::getDBO ();
		$q = 'SELECT * FROM `' . $this->_tablename . '` WHERE ';
		$q .= " `order_number` = '" . $order_number . "'";

		$db->setQuery ($q);
		if (!($payments = $db->loadObjectList ())) {
			// JError::raiseWarning(500, $db->getErrorMsg());
			return '';
		}
		return $payments;
	}

	/**
	 * Get ipn data, send verification to pagosweb, run corresponding handler
	 *
	 * @param array $data
	 * @return string Empty string if data is valid and an error message otherwise
	 * @access protected
	 */
	
	function _check_txn_id_already_processed ($payments, $txn_id, $method) {

		$virtuemart_order_id = $payments[0] ->virtuemart_order_id;
		$orderModel = VmModel::getModel ('orders');
		$order = $orderModel->getOrder ($virtuemart_order_id);

		if ($order['details']['BT']->order_status == $method->status_success) {
			foreach ($payments as $payment) {
				if ($payment->pagosweb_response_txn_id == $txn_id) {
					return TRUE;
				}
			}
		}
		return FALSE;
	}

	function _check_email_amount_currency ($payments, $email, $pagosweb_data) {

		/*
		 * TODO Not checking yet because config do not have primary email address
		* Primary email address of the payment recipient (that is, the merchant).
		* If the payment is sent to a non-primary email address on your pagosweb account,
		* the receiver_email is still your primary email.
		*/
		/*
		if ($payments[0]->payment_order_total==$email) {
			return true;
		}
		*/
		if ($payments[0]->payment_order_total == $pagosweb_data['mc_gross']) {
			return TRUE;
		}
		$currency_code_3 = shopFunctions::getCurrencyByID ($payments[0]->payment_currency, 'currency_code_3');
		if ($currency_code_3 == $pagosweb_data['mc_currency']) {
			return TRUE;
		}
		$mailsubject = "Transaccion";
		$mailbody = "Hola,
		Test Email
		----------------------------------
		IPN Notification content:
		";
		foreach ($pagosweb_data as $key => $value) {
			$mailbody .= $key . " = " . $value . "\n\n";
		}
		$this->sendEmailToVendorAndAdmins ($mailsubject, $mailbody);

		return FALSE;
	}

	/**
	 * @param $method
	 * @return mixed
	 */
	function _getMerchantEmail ($method) {

		return $method->pagosweb_merchant_email;
	}

	/**
	 * @param $pagoswebTable
	 * @param $payment_name
	 * @return string
	 */
	function _getPaymentResponseHtml ($pagoswebTable, $payment_name) {

		$html = '<table>' . "\n";
		$html .= $this->getHtmlRow ('PAGOSWEB_PAYMENT_NAME', $payment_name);
		if (!empty($pagoswebTable)) {
			$html .= $this->getHtmlRow ('PAGOSWEB_ORDER_NUMBER', $pagoswebTable->order_number);
			//$html .= $this->getHtmlRow('PAGOSWEB_AMOUNT', $pagoswebTable->payment_order_total. " " . $pagoswebTable->payment_currency);
		}
		$html .= '</table>' . "\n";

		return $html;
	}
	
	function _getPaymentResponseHtmlRechazado ($pagoswebTable, $payment_name) {

		$html = '<table>' . "\n";
		$html .= $this->getHtmlRow ('PAGOSWEB_PAYMENT_NAME', $payment_name);
		if (!empty($pagoswebTable)) {
			$html .= $this->getHtmlRow ('PAGOSWEB_ORDER_NUMBER', $pagoswebTable->order_number);
			//$html .= $this->getHtmlRow('PAGOSWEB_AMOUNT', $pagoswebTable->payment_order_total. " " . $pagoswebTable->payment_currency);
			$html .= 'El pago del pedido ha fallado.';
		
		}
		$html .= '</table>' . "\n";

		return $html;
	}

	/**
	 * @param VirtueMartCart $cart
	 * @param                $method
	 * @param                $cart_prices
	 * @return int
	 */
	function getCosts (VirtueMartCart $cart, $method, $cart_prices) {

		if (preg_match ('/%$/', $method->cost_percent_total)) {
			$cost_percent_total = substr ($method->cost_percent_total, 0, -1);
		} else {
			$cost_percent_total = $method->cost_percent_total;
		}
		return ($method->cost_per_transaction + ($cart_prices['salesPrice'] * $cost_percent_total * 0.01));
	}

	/**
	 * Check if the payment conditions are fulfilled for this payment method
	 *
	 *
	 * @param $cart_prices: cart prices
	 * @param $payment
	 * @return true: if the conditions are fulfilled, false otherwise
	 *
	 */
	protected function checkConditions ($cart, $method, $cart_prices) {

		$this->convert ($method);

		$address = (($cart->ST == 0) ? $cart->BT : $cart->ST);

		$amount = $cart_prices['salesPrice'];
		$amount_cond = ($amount >= $method->min_amount AND $amount <= $method->max_amount
			OR
			($method->min_amount <= $amount AND ($method->max_amount == 0)));

		$countries = array();
		if (!empty($method->countries)) {
			if (!is_array ($method->countries)) {
				$countries[0] = $method->countries;
			} else {
				$countries = $method->countries;
			}
		}
		// probably did not gave his BT:ST address
		if (!is_array ($address)) {
			$address = array();
			$address['virtuemart_country_id'] = 0;
		}

		if (!isset($address['virtuemart_country_id'])) {
			$address['virtuemart_country_id'] = 0;
		}
		if (in_array ($address['virtuemart_country_id'], $countries) || count ($countries) == 0) {
			if ($amount_cond) {
				return TRUE;
			}
		}

		return FALSE;
	}

	/**
	 * @param $method
	 */
	function convert ($method) {

		$method->min_amount = (float)$method->min_amount;
		$method->max_amount = (float)$method->max_amount;
	}

	/**
	 * We must reimplement this triggers for joomla 1.7
	 */

	/**
	 * Create the table for this plugin if it does not yet exist.
	 * This functions checks if the called plugin is active one.
	 * When yes it is calling the standard method to create the tables
	 *
	 *
	 */
	function plgVmOnStoreInstallPaymentPluginTable ($jplugin_id) {
		if ($jplugin_id != $this->_jid) {
			return FALSE;
		}
		
		return $this->onStoreInstallPluginTable($jplugin_id);
	}

	/**
	 * This event is fired after the payment method has been selected. It can be used to store
	 * additional payment info in the cart.
	 *
	 *
	 * @param VirtueMartCart $cart: the actual cart
	 * @return null if the payment was not selected, true if the data is valid, error message if the data is not vlaid
	 *
	 */
	public function plgVmOnSelectCheckPayment (VirtueMartCart $cart, &$msg) {

		return $this->OnSelectCheck ($cart);
	}

	/**
	 * plgVmDisplayListFEPayment
	 * This event is fired to display the pluginmethods in the cart (edit shipment/payment) for exampel
	 *
	 * @param object  $cart Cart object
	 * @param integer $selected ID of the method selected
	 * @return boolean True on succes, false on failures, null when this plugin was not selected.
	 * On errors, JError::raiseWarning (or JError::raiseError) must be used to set a message.
	 *
	 */
	public function plgVmDisplayListFEPayment (VirtueMartCart $cart, $selected = 0, &$htmlIn) {

		return $this->displayListFE ($cart, $selected, $htmlIn);
	}

	/*
		 * plgVmonSelectedCalculatePricePayment
		 * Calculate the price (value, tax_id) of the selected method
		 * It is called by the calculator
		 * This function does NOT to be reimplemented. If not reimplemented, then the default values from this function are taken.
		 * @cart: VirtueMartCart the current cart
		 * @cart_prices: array the new cart prices
		 * @return null if the method was not selected, false if the shiiping rate is not valid any more, true otherwise
		 *
		 *
		 */

	/**
	 * @param VirtueMartCart $cart
	 * @param array          $cart_prices
	 * @param                $cart_prices_name
	 * @return bool|null
	 */
	public function plgVmonSelectedCalculatePricePayment (VirtueMartCart $cart, array &$cart_prices, &$cart_prices_name) {

		return $this->onSelectedCalculatePrice ($cart, $cart_prices, $cart_prices_name);
	}

	/**
	 * plgVmOnCheckAutomaticSelectedPayment
	 * Checks how many plugins are available. If only one, the user will not have the choice. Enter edit_xxx page
	 * The plugin must check first if it is the correct type
	 *
	 * @param VirtueMartCart cart: the cart object
	 * @return null if no plugin was found, 0 if more then one plugin was found,  virtuemart_xxx_id if only one plugin is found
	 *
	 */
	function plgVmOnCheckAutomaticSelectedPayment (VirtueMartCart $cart, array $cart_prices = array(), &$paymentCounter) {

		return $this->onCheckAutomaticSelected ($cart, $cart_prices, $paymentCounter);
	}

	/**
	 * This method is fired when showing the order details in the frontend.
	 * It displays the method-specific data.
	 *
	 * @param integer $order_id The order ID
	 * @return mixed Null for methods that aren't active, text (HTML) otherwise
	 */
	public function plgVmOnShowOrderFEPayment ($virtuemart_order_id, $virtuemart_paymentmethod_id, &$payment_name) {

		$this->onShowOrderFE ($virtuemart_order_id, $virtuemart_paymentmethod_id, $payment_name);
	}

	
	/**
	 * This method is fired when showing when priting an Order
	 * It displays the the payment method-specific data.
	 *
	 * @param integer $_virtuemart_order_id The order ID
	 * @param integer $method_id  method used for this order
	 * @return mixed Null when for payment methods that were not selected, text (HTML) otherwise
	 */
	function plgVmonShowOrderPrintPayment ($order_number, $method_id) {

		return $this->onShowOrderPrint ($order_number, $method_id);
	}

	/**
	 * This method is fired when showing the order details in the frontend, for every orderline.
	 * It can be used to display line specific package codes, e.g. with a link to external tracking and
	 * tracing systems
	 *
	 * @param integer $_orderId The order ID
	 * @param integer $_lineId
	 * @return mixed Null for method that aren't active, text (HTML) otherwise
	 * @author Oscar van Eijk
	 */

	public function plgVmOnShowOrderLineFE($_orderId, $_lineId) {
		return null;
	}
	 
	function plgVmDeclarePluginParamsPayment ($name, $id, &$data) {

		return $this->declarePluginParams ('payment', $name, $id, $data);
	}
	
	function plgVmDeclarePluginParamsPaymentVM3( &$data) {
		return $this->declarePluginParams('payment', $data);
	}

	function plgVmSetOnTablePluginParamsPayment($name, $id, &$table) {
		return $this->setOnTablePluginParams($name, $id, $table);
	}

}

