<?php

/**

* @package   yoo_master2

* @author    YOOtheme http://www.yootheme.com

* @copyright Copyright (C) YOOtheme GmbH

* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL

*/



// get theme configuration

include($this['path']->path('layouts:theme.config.php'));



?>

<!DOCTYPE HTML>

<html lang="<?php echo $this['config']->get('language'); ?>" dir="<?php echo $this['config']->get('direction'); ?>"  data-config='<?php echo $this['config']->get('body_config','{}'); ?>'>



<head>

<?php echo $this['template']->render('head'); ?>


</head>



<body class="<?php echo $this['config']->get('body_classes'); ?>">

	

    <?php if ($this['widgets']->count('absolute')) : ?>

    <div id="tm-absolute" class="tm-block-absolute uk-hidden-small">

        <div class="uk-container uk-container-center">

            <div class="tm-absolute uk-clearfix">

                <?php if ($this['widgets']->count('absolute')) : ?>

                	<?php echo $this['widgets']->render('absolute'); ?>

                <?php endif; ?>

            </div>

        </div>

    </div>

    <?php endif; ?>



	<?php if ($this['widgets']->count('toolbar-l + toolbar-r')) : ?>

    <div id="tm-toolbar" class="tm-block-toolbar uk-hidden-small">

        <div class="uk-container uk-container-center">

			<div class="tm-toolbar uk-clearfix">

				<?php if ($this['widgets']->count('toolbar-l')) : ?>

                    <div class="uk-float-left"><?php echo $this['widgets']->render('toolbar-l'); ?></div>

                <?php endif; ?>

    

                <?php if ($this['widgets']->count('toolbar-r')) : ?>

                    <div class="uk-float-right"><?php echo $this['widgets']->render('toolbar-r'); ?></div>

                <?php endif; ?>

            </div>

        </div>

    </div>

    <?php endif; ?>

	

    <?php if($this['config']->get('flip_navigation'))

	{ ?>

		<?php include($this['path']->path('layouts:theme.header-flip.php')); ?>

    <?php

	}else

	{?>

    	<?php include($this['path']->path('layouts:theme.header.php')); ?>

    <?php

	}?>

	    

    <?php if ($this['widgets']->count('fullscreen')) : ?>

	<div id="tm-fullscreen" class="tm-block-fullscreen">

		<?php echo $this['widgets']->render('fullscreen'); ?>

	</div>

	<?php endif; ?>

	

    <div id="tm-page" class="tm-page">

    

		<?php if ($this['widgets']->count('top-a')) : ?>

        <div id="tm-top-a" class="tm-block tm-block-top-a <?php echo $display_classes['top-a']; ?>">

            <div class="uk-container uk-container-center">

                <section class="<?php echo $grid_classes['top-a'];?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin><?php echo $this['widgets']->render('top-a', array('layout'=>$this['config']->get('grid.top-a.layout'))); ?></section>

            </div>

        </div>

        <?php endif; ?>

        

        <?php if ($this['widgets']->count('top-b')) : ?>

        <div id="tm-top-b" class="tm-block tm-block-top-b <?php echo $display_classes['top-b']; ?>">

            <div class="uk-container uk-container-center">

                <section class="<?php echo $grid_classes['top-b']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin><?php echo $this['widgets']->render('top-b', array('layout'=>$this['config']->get('grid.top-b.layout'))); ?></section>

            </div>

        </div>

        <?php endif; ?>



        <?php if ($this['widgets']->count('top-image')) : ?>

            <div id="tm-top-image" class="tm-block-full tm-block-top-image">

                <?php echo $this['widgets']->render('top-image'); ?>

            </div>

        <?php endif; ?>

        

        <?php if ($this['widgets']->count('top-c')) : ?>

        <div id="tm-top-c" class="tm-block tm-block-top-c <?php echo $display_classes['top-c']; ?>">

            <div class="uk-container uk-container-center">

                <section class="<?php echo $grid_classes['top-c']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin><?php echo $this['widgets']->render('top-c', array('layout'=>$this['config']->get('grid.top-c.layout'))); ?></section>

            </div>

        </div>

        <?php endif; ?>

    

        <?php if ($this['widgets']->count('main-top + main-bottom + sidebar-a + sidebar-b') || ($this['config']->get('system_output', true) && !$this['system']->isComponentEmpty()) ) : ?>

        <div id="tm-middle" class="tm-block tm-block-middle">

            <div class="uk-container uk-container-center">

                <div class="tm-middle uk-grid" data-uk-grid-match="{target:'> div > *'}" data-uk-grid-margin>

            

                    <?php if ($this['widgets']->count('main-top + main-bottom') || $this['config']->get('system_output', true)) : ?>

                    <div class="<?php echo $columns['main']['class'] ?>">

                        <div class="<?php echo $columns['main']['name'] ?>">

							

							<?php if ($this['widgets']->count('breadcrumbs')) : ?>

                            	<div class="uk-visible-large"><?php echo $this['widgets']->render('breadcrumbs'); ?></div>

                            <?php endif; ?>

                                                

                            <?php if ($this['widgets']->count('main-top')) : ?>

                            <section id="tm-main-top" class="<?php echo $grid_classes['main-top']; echo $display_classes['main-top']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin><?php echo $this['widgets']->render('main-top', array('layout'=>$this['config']->get('grid.main-top.layout'))); ?></section>

                            <?php endif; ?>

                

                            <?php if ($this['config']->get('system_output', true) && !$this['system']->isComponentEmpty() ) : ?>

                            <main id="tm-content" class="tm-content">

                                <?php echo $this['template']->render('content'); ?>

                            </main>

                            <?php endif; ?>

                

                            <?php if ($this['widgets']->count('main-bottom')) : ?>

                            <section id="tm-main-bottom" class="<?php echo $grid_classes['main-bottom']; echo $display_classes['main-bottom']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin><?php echo $this['widgets']->render('main-bottom', array('layout'=>$this['config']->get('grid.main-bottom.layout'))); ?></section>

                            <?php endif; ?>

                

                        </div>

                    </div>

                    <?php endif; ?>

            

                    <?php foreach($columns as $name => &$column) : ?>

                    <?php if ($name != 'main' && $this['siniestro']->countWidgets($name)) : ?>

                    <div class="<?php echo $column['class'] ?>">

                    	<aside class="<?php echo $column['name'] ?>"><?php echo $this['widgets']->render($name) ?></aside>

                    </div>

                    <?php endif ?>

                    <?php endforeach ?>

            

                </div>

            </div>

        </div>

        <?php endif; ?>

    

        <?php if ($this['widgets']->count('bottom-a')) : ?>

        <div id="tm-bottom-a" class="tm-block tm-block-bottom-a <?php echo $display_classes['bottom-a']; ?>">

            <div class="uk-container uk-container-center">

                <section class="<?php echo $grid_classes['bottom-a']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin><?php echo $this['widgets']->render('bottom-a', array('layout'=>$this['config']->get('grid.bottom-a.layout'))); ?></section>

            </div>

        </div>

        <?php endif; ?>

        

        <?php if ($this['widgets']->count('bottom-image')) : ?>

            <div id="tm-bottom-image" class="tm-block-full tm-block-bottom-image">

                <?php echo $this['widgets']->render('bottom-image'); ?>

            </div>

        <?php endif; ?>

    

        <?php if ($this['widgets']->count('bottom-b')) : ?>

        <div id="tm-bottom-b" class="tm-block tm-block-bottom-b <?php echo $display_classes['bottom-b']; ?>">

            <div class="uk-container uk-container-center">

                <section class="<?php echo $grid_classes['bottom-b']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin><?php echo $this['widgets']->render('bottom-b', array('layout'=>$this['config']->get('grid.bottom-b.layout'))); ?></section>

            </div>

        </div>

        <?php endif; ?>

        

        <?php if ($this['widgets']->count('bottom-c')) : ?>

        <div id="tm-bottom-c" class="tm-block tm-block-bottom-c <?php echo $display_classes['bottom-c']; ?>">

            <div class="uk-container uk-container-center">

                <section class="<?php echo $grid_classes['bottom-c']; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin><?php echo $this['widgets']->render('bottom-c', array('layout'=>$this['config']->get('grid.bottom-c.layout'))); ?></section>

            </div>

        </div>

        <?php endif; ?>

        <?php if ($this['widgets']->count('bottom-d')) : ?>

        <div id="tm-bottom-d" class="tm-block tm-block-bottom-d <?php echo $display_classes['bottom-d']; ?>">

            <div class="uk-container uk-container-center">

                <section class="<?php echo $grid_classes['bottom-d']; ?> uk-flex-middle" data-uk-grid-margin><?php echo $this['widgets']->render('bottom-d', array('layout'=>$this['config']->get('grid.bottom-d.layout'))); ?></section>

            </div>

        </div>

        <?php endif; ?>

    

    </div>

    

    <?php if ($this['widgets']->count('footer-top')) : ?>

    <div id="tm-footer-top" class="tm-block-footer-top <?php echo $display_classes['footer-top']; ?>">

    	<div class="uk-container uk-container-center">

	    	<section class="<?php echo $grid_classes['footer-top']; ?> uk-flex-middle" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin="" ><?php echo $this['widgets']->render('footer-top', array('layout'=>$this['config']->get('grid.footer-top.layout'))); ?></section>

        </div>

    </div>

    <?php endif; ?>



    <?php if ($this['widgets']->count('footer + debug') || $this['config']->get('totop_scroller', true) || $this['config']->get('siniestro_branding', true) ) : ?>

    <div id="tm-footer" class="tm-block-footer">

        <div class="uk-container uk-container-center">

            <footer class="tm-footer uk-clearfix">

        

                <?php if ($this['config']->get('totop_scroller', true)) : ?>

                <a class="tm-totop-scroller" data-uk-smooth-scroll href="#"></a>

                <?php endif; ?>

        

                <?php echo $this['widgets']->render('footer'); ?>

				                

                <?php if ($this['config']->get('siniestro_branding', true)) : ?>

                <div class="uk-panel siniestro">

                  <div>

                    <a class="image" href="http://www.siniestro.net" title="<?php echo $this['config']->get('siniestro_keyword_1'); ?>" target="_blank">

                        <img data-uk-svg class="logo-siniestro-icon svg-icon" alt="<?php echo $this['config']->get('siniestro_keyword_2'); ?>" src="<?php echo $this['path']->url('theme:images/siniestro.svg'); ?>" data-fallback="<?php echo $this['path']->url('theme:images/siniestro.png'); ?>" />

                    </a>

                    <div class="text">

                   		<span>www.siniestro.net</span>

                    	<br />

                    	<a class="link" href="http://www.siniestro.net" title="<?php echo $this['config']->get('siniestro_keyword_1'); ?>" target="_blank"><?php echo $this['config']->get('siniestro_keyword_2'); ?></a>

                    </div>

                  </div>

                </div>

                <?php endif; ?>

                

                <?php echo $this['widgets']->render('debug');?>

        

            </footer>

        </div>

    </div>

    <?php endif; ?>



	<?php echo $this->render('footer'); ?>



	<?php if ($this['widgets']->count('offcanvas')) : ?>

	<div id="offcanvas" class="uk-offcanvas">

		<div class="uk-offcanvas-bar"><?php echo $this['widgets']->render('offcanvas'); ?></div>

	</div>

	<?php endif; ?>

    

    <?php if ($this['widgets']->count('offcanvas-flip')) : ?>

	<div id="offcanvas-flip" class="uk-offcanvas">

		<div class="uk-offcanvas-bar uk-offcanvas-bar-flip"><?php echo $this['widgets']->render('offcanvas-flip'); ?></div>

	</div>

	<?php endif; ?>

    

    <?php if ($this['widgets']->count('float-bar')) : ?>

    <div class="tm-float-bar uk-flex uk-flex-middle uk-visible-large">

        <div><?php echo $this['widgets']->render('float-bar'); ?></div>

    </div>

    <?php endif; ?>



    <?php if ($this['widgets']->count('popup')) : ?>

        <div id="tm-modal-popup" class="uk-modal tm-modal">

            <div class="uk-modal-dialog uk-modal-dialog-lightbox tm-modal-dialog-large">

                <button type="button" class="uk-modal-close uk-close uk-close-alt uk-position-z-index"></button>

                <?php echo $this['widgets']->render('popup'); ?>

            </div>

        </div>

        <script>

        (function (){

            var modal = UIkit.modal("#tm-modal-popup", {center: true});

            modal.show();

        })();

        </script>

    <?php endif; ?>

    <div class="tm-float-wpp">
        <div>
            <div class="mod-whatsapp">
                <ul>
                    <li>
                        <a onclick="gtag('event', 'conversion', {'send_to': 'AW-697841883/PTOrCJHpu7MBENvx4MwC'});" href="https://api.whatsapp.com/send?phone=59894874982" class="tm-icon-whatsapp" target="_blank" rel="noopener noreferrer">
                            <svg viewBox="0 0 28 29" style="background-color:#ffffff00" xmlns="http://www.w3.org/2000/svg" width="28" height="29"><path d="M15.703 17.703a.72.72 0 0 1-.406-.125c-1.125-.562-2.031-1.172-2.688-1.812-.812-.75-1.421-1.563-1.828-2.438a.482.482 0 0 1-.078-.281c0-.11.203-.375.61-.813.406-.437.609-.78.609-1.03 0-.079-.156-.532-.453-1.345-.297-.812-.485-1.328-.578-1.578-.094-.25-.188-.406-.282-.484-.093-.078-.25-.125-.468-.125-.094 0-.204 0-.344-.016-.14-.015-.25-.031-.313-.031-.343 0-.656.14-.937.39-.844.813-1.281 1.75-1.313 2.829v.14c-.015 1.032.407 2.188 1.266 3.47.906 1.343 1.781 2.437 2.64 3.296.844.875 1.86 1.578 3.032 2.11 1.578.75 2.719 1.109 3.406 1.109.547 0 1.156-.157 1.813-.469.656-.313 1.078-.703 1.265-1.172.203-.515.313-.969.313-1.36a.577.577 0 0 0-.047-.265c-.063-.11-.594-.422-1.594-.953-1-.516-1.578-.781-1.734-.781-.157 0-.469.297-.938.875-.468.578-.781.86-.953.86zm-7.906 5.875l-4.313 1.375 1.407-4.172c-1.438-1.953-2.141-4.14-2.141-6.562 0-1.5.297-2.953.89-4.344.594-1.39 1.391-2.594 2.391-3.594S8.22 4.484 9.61 3.891A10.99 10.99 0 0 1 13.97 3c1.5 0 2.953.297 4.344.89 1.375.594 2.578 1.391 3.578 2.391s1.797 2.203 2.39 3.594c.594 1.39.89 2.844.89 4.344a10.86 10.86 0 0 1-.89 4.344c-.593 1.39-1.39 2.578-2.39 3.578-1 1-2.203 1.797-3.578 2.39-1.391.594-2.844.89-4.344.89-2.235 0-4.297-.608-6.172-1.843zM4.437 4.703C3.234 5.906 2.281 7.343 1.563 9A12.994 12.994 0 0 0 .5 14.219c0 2.515.64 4.828 1.922 6.937L0 28.391 7.453 26a13.306 13.306 0 0 0 6.516 1.672c1.812 0 3.562-.36 5.219-1.063 1.656-.718 3.078-1.672 4.28-2.875 1.204-1.203 2.157-2.64 2.876-4.297a12.954 12.954 0 0 0 1.078-5.218c0-1.813-.36-3.563-1.078-5.219-.719-1.656-1.672-3.094-2.875-4.297-1.203-1.203-2.625-2.156-4.282-2.875A13.008 13.008 0 0 0 13.97.75c-1.828 0-3.578.36-5.235 1.078-1.656.719-3.093 1.672-4.296 2.875z" fill="#fff"/></svg>
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </div>

    

    <div class="pswp" tabindex="-1" role="dialog" aria-hidden="true"> 

        

        <div class="pswp__bg"></div>

        

        <div class="pswp__scroll-wrap"> 

        

            <div class="pswp__container"> 

                <div class="pswp__item"></div>

                <div class="pswp__item"></div>

                <div class="pswp__item"></div>

            </div>

            

            <div class="pswp__ui pswp__ui--hidden">

                <div class="pswp__top-bar"> 

                    <div class="pswp__counter"></div>

                    <button class="pswp__button pswp__button--close" title="Close (Esc)"></button>

                    <button class="pswp__button pswp__button--share" title="Share"></button>

                    <button class="pswp__button pswp__button--fs" title="Toggle fullscreen"></button>

                    <button class="pswp__button pswp__button--zoom" title="Zoom in/out"></button>

                    

                    <div class="pswp__preloader">

                        <div class="pswp__preloader__icn">

                            <div class="pswp__preloader__cut">

                                <div class="pswp__preloader__donut"></div>

                            </div>

                        </div>

                    </div>

                </div>

                

                <div class="pswp__share-modal pswp__share-modal--hidden pswp__single-tap">

                    <div class="pswp__share-tooltip"></div>

                </div>

                

                <button class="pswp__button pswp__button--arrow--left" title="Previous (arrow left)"> </button>

                <button class="pswp__button pswp__button--arrow--right" title="Next (arrow right)"> </button>

                

                <div class="pswp__caption">

                    <div class="pswp__caption__center"></div>

                </div>

            </div>

            

        </div>

    </div>



</body>

</html>