(function(addon) {

    var component;

    if (window.UIkit) {
        component = addon(UIkit);
    }

    if (typeof define == "function" && define.amd) {
        define("uikit-banner-sticky", ["uikit"], function(){
            return component || addon(UIkit);
        });
    }

})(function(UI){

    "use strict";

    var $win         = UI.$win,
        $doc         = UI.$doc
		
    UI.component('bannerSticky', {

        defaults: {
            target: '.tm-banner',
			elementBottom: '.tm-block-footer'
        },

        boot: function() {
			
			var $this = this;

            // should be more efficient than using $win.scroll(scroller):
            UI.$doc.on('scrolling.uk.document', function() {
                $this.scroller();
            });
			
            UI.$win.on('resize orientationchange', UI.Utils.debounce(function() {
                $this.scroller();
            }, 100));

            // init code
            UI.ready(function(context) {

                setTimeout(function(){

                    UI.$("[data-uk-banner-sticky]", context).each(function(){

                        var $ele = UI.$(this);

                        if(!$ele.data("bannerSticky")) {
                            UI.bannerSticky($ele, UI.Utils.options($ele.attr('data-uk-banner-sticky')));
                        }
                    });

                   $this.scroller();
                }, 0);
            });
        },

        init: function() {
			
			var $this = this;
			
			this.banner = this.find(this.options.target);
			this.topeTop = this.banner.offset();
			
			if( this.banner.length )
			{
				//$doc.on("uk-scroll", function(){
					//$this.scroller();
				//});
			}
		},
		
		scroller: function () {
			var $this = this;
			
			var topeBottom = UI.$($this.options.elementBottom).offset();
			
			if ( $win.scrollTop() > $this.topeTop.top && $win.scrollTop() < topeBottom.top - $this.banner.height() )
			{ 
				$this.banner.css({'top':( $win.scrollTop() - ($this.topeTop.top) )}); 
			}
			
			if ( $win.scrollTop() <= $this.topeTop.top ){ $this.banner.css({'top' : '0'}); }
		}
    });
    
    return UI.bannerSticky;
});
