(function(addon) {

    var component;

    if (window.UIkit) {
        component = addon(UIkit);
    }

    if (typeof define == "function" && define.amd) {
        define("uikit-grid-divider", ["uikit"], function(){
            return component || addon(UIkit);
        });
    }

})(function(UI) {

    "use strict";

    var grids = [];

    UI.component('gridDivider', {

        defaults: {
            cls: 'uk-grid-border-remove'
        },

        boot: function() {

            // init code
            UI.ready(function(context) {

                UI.$("[data-uk-grid-divider]", context).each(function() {
                    var grid = UI.$(this), obj;

                    if (!grid.data("gridDivider")) {
                        obj = UI.gridDivider(grid, UI.Utils.options(grid.attr("data-uk-grid-divider")));
                    }
                });
            });
        },

        init: function() {

            var $this = this;

            this.columns = this.element.children();
            this.elements = this.columns;
            
			if (!this.columns.length) return;
            
			UI.$win.on("resize orientationchange", function() {
                var fn = function() {
                    $this.process()
                };
                
				UI.$(function() {
                    fn();
                    UI.$win.on("load", fn)
                });
                return UI.Utils.debounce(fn, 50)
            }());
			
            UI.$html.on("uk.dom.changed", function(e) {
                $this.columns = $this.element.children();
                $this.elements = $this.options.target ? $this.find($this.options.target) : $this.columns;
                $this.process()
            });
            
			this.on("uk.check.display", function(e) {
                if (this.element.is(":visible")) this.process()
            }.bind(this));
            
			grids.push(this)
        },

        process: function() {
			
            this.revert();
            
			var firstvisible = this.columns.filter(":visible:first");
            
			if (!firstvisible.length) return;
            
			var stacked = Math.ceil(100 * parseFloat(firstvisible.css("width")) / parseFloat(firstvisible.parent().css("width"))) >= 100 ? true : false,
                $this = this;
            
			if (stacked) return;
            
			this.element.width();
			
			setTimeout(function() 
			{
				var lastoffset = false,
					group = [];
				
				$this.elements.each(function(i) 
				{
					var ele = UI.$(this),
						offset = ele.offset().top;
						
					if (offset != lastoffset && group.length) 
					{
						//UI.$('.item-'+ (i-1)).after( '<div class="uk-width-1-1 tm-grid-divider"><hr /></div>' );
						$this.processDivider(group);
						group = [];
						offset = ele.offset().top
					}
					
					//ele.addClass('item-'+i);
					group.push(ele);
					lastoffset = offset
				});
				
				if (group.length) { // last group
					$this.processDivider(group)
				}
				
			}, 0)
			
            return this
        
		},
		
        revert: function() {
			
			//UI.$('.tm-grid-divider').remove();
			this.elements.removeClass(this.options.cls);
            return this
        },
		
        processDivider: function(elements) {
			
			var $this = this;
			//elements.shift();
			elements = UI.$(elements[0]);
			
            if (elements.length < 1) return;
                        
			elements.each(function() 
			{
				UI.$(this).addClass($this.options.cls);
            })
        }
    });
	
	return UI.gridDivider;

});
