(function(addon) {



    var component;



    if (window.UIkit) {

        component = addon(UIkit);

    }



    if (typeof define == "function" && define.amd) {

        define("uikit-infinite-pagination", ["uikit"], function(){

            return component || addon(UIkit);

        });

    }



})(function(UI){



    "use strict";

	

    UI.component('infinitePagination', {



        defaults: {

			isVirtuemart: true,

            lblLoading: 'loading',

			lblLoad: 'load more',

			finishedMsg: 'No more pages to load.',

			firstSelector: '.vm-pagination-bottom a.first',

			nextSelector: '.vm-pagination-bottom a.next',

	        navSelector: '.vm-pagination-bottom',

			itemSelector: '.vm-content-list > div > div',

			btn: '.btn-infinite-pagination',

			enabledScroll: true,

			extraScrollPx: 150,

			bufferPx: 40,

			pixelsFromNavToBottom: undefined

        },



        boot: function() {



            // init code

            UI.ready(function(context) {



                UI.$("[data-uk-infinite-pagination]", context).each(function(){

                    var ele = UI.$(this);



                    if (!ele.data("infinitePagination")) {

                        var obj = UI.infinitePagination(ele, UI.Utils.options(ele.attr("data-uk-infinite-pagination")));

                    }

                });

            });

        },



        init: function() {



            var $this = this;

            

            $this.path = UI.$(this.options.nextSelector).attr('href');

			

			if (!$this.path) {

                //console.log('Navigation selector not found');

                return false;

            }

			

			$this.state = 'done';

						                                    

			UI.$( '<button class="btn-infinite-pagination uk-button uk-width-1-1 uk-margin">'+this.options.lblLoad+'</button>' ).insertAfter( this.element );

						

			UI.$(this.options.btn).on("click", function(){

				$this.loadContent();

			});

			

			if(!this.options.enabledScroll) return;

																								

			UI.$doc.on('scrolling.uk.document', function() {

				$this.scroller();

			});

        },

		

		loadContent: function (){

			var $this = this;

			

			if($this.state == 'loading' || $this.state == 'finished'){

				//console.log('Is Loading');

                return false;

			}

									

			$this.state = 'loading';

			UI.$($this.options.btn).text($this.options.lblLoading);

			

			UI.$.ajax({

				url: $this.path,

				context: document.body,

				dataType: 'html'

			}).done(function(data) {

				$this.state = 'done';

				UI.$($this.options.btn).text($this.options.lblLoad);

				

				data = UI.$(data.trim());

				$this.path = data.find($this.options.nextSelector).attr('href');

				var items = data.find($this.options.itemSelector);



				var children = items.children();

				UI.$($this.options.itemSelector).append(children.addClass('uk-animation-scale-up'));

				

				if($this.options.isVirtuemart){



					children.each(function(xkey, xitem)

					{

						Virtuemart.product(UI.$(xitem).find('form.product'));

					});



					$this.resetVMPagination(data.find($this.options.firstSelector).attr('href')+'?tmpl=component');

				}

				setTimeout(function() {
					UI.$(window).trigger("resize");
				}, 200);

				//UI.$('.vm-product-list').trigger('display.uk.check');

				

				if (!$this.path) {

                	//console.log('Navigation selector not found');

					UI.$($this.options.btn).text($this.options.finishedMsg).attr('disabled', 'disabled').delay(1000).queue(function(){

						UI.$(this).dequeue();

			    	});

					$this.state = 'finished';

					

                	return false;

            	}

				

			});

		},

		

		resetVMPagination: function(url){

			UI.$.ajax({

				url: url,

				context: document.body,

				dataType: 'html'

			}).done(function(data) {});

		},

		

		scroller: function () {

			var $this = this;



			$this.options.pixelsFromNavToBottom = UI.$doc.height() - UI.$($this.options.btn).offset().top;

						

			var pixelsFromWindowBottomToBottom = 0 + UI.$doc.height() - (UI.$win.scrollTop()) - UI.$win.height();

			var nearbottom = pixelsFromWindowBottomToBottom - $this.options.bufferPx < $this.options.pixelsFromNavToBottom;

												        				

			if (nearbottom) {

				$this.loadContent()

			}

		}

    });



    return UI.infinitePagination

});

