(function(UI){

    "use strict";

    var toggles = [],
    	current = 0;
    
    UI.component('readmore', {

        defaults: {
            cls : 'uk-hidden',
            animation : 'uk-animation-scale-up uk-animation-top-center',
            duration : 500
        },

        boot: function()
        {
            // init code
            UI.ready(function(context)
            {
                UI.$("[data-tm-readmore], .js-readmore", context).each(function()
                {
                    var ele = UI.$(this);

                    if (!ele.data("readmore"))
                    {
                        var obj = UI.readmore(ele, UI.Utils.options(ele.attr("data-tm-readmore")));
                    }
                });

                setTimeout(function()
                {                	
                	toggles[current].element.removeClass('uk-hidden');

                    toggles.forEach(function(toggle)
                    {
                    	toggle.getContent();
                    });
                }, 0);
            });
        },

        init: function()
        {
            var $this = this;

            $this.element.addClass('uk-button js-readmore-button uk-width-1-1 uk-hidden');

            this.getContent();

            this.toreadmore.addClass(this.options.cls + ' uk-margin');
                                    
            this.on("click", function(e)
            {            	
                e.preventDefault();
                
                current++;

                if(current == toggles.length)
                {
                	$this.readmore();
                	toggles[toggles.length-1].element.addClass('js-readless-button uk-margin');
                }
                else if(current > toggles.length)
                {
                	$this.readAllless();
                	current = 0;
                	toggles[toggles.length-1].element.addClass('uk-hidden').removeClass('js-readless-button');
                	toggles[current].element.removeClass('uk-hidden');
                }
                else
                {
                	$this.readmore();
                	UI.$(this).addClass('uk-hidden');
                	toggles[current].element.removeClass('uk-hidden');
                }
                				
            });
            
            toggles.push(this);
        },

        readAllless: function()
        {        	
        	var $top = toggles[0].element.offset().top;
        	
        	UI.$('html, body').stop().animate(
        	{
        		'scrollTop': $top
        	}, 1000);
        	

        	toggles.forEach(function(toggle)
        	{
        		toggle.readmore();
        	});
        },

        readmore: function()
        {        	
            if(!this.toreadmore.length) return;

            if (this.options.animation && UI.support.animation) {

                var $this = this, animations = this.options.animation.split(',');

                if (animations.length == 1) {
                    animations[1] = animations[0];
                }

                animations[0] = animations[0].trim();
                animations[1] = animations[1].trim();

                $this.toreadmore.css('animation-duration', this.options.duration+'ms');
                
                if ($this.toreadmore.hasClass($this.options.cls))
                {                	                    
                    $this.toreadmore.toggleClass($this.options.cls);
                    UI.$win.trigger("resize");
                    $this.toreadmore.addClass(animations[0]);
					
                    /*
                    UI.Utils.animate($this.toreadmore, animations[0]).then(function(){
                        $this.toreadmore.css('animation-duration', '');
                        //UI.$win.trigger("resize");
                        UI.Utils.checkDisplay($this.toreadmore);
                        
                    });
                    */

                } else
                {
                	$this.toreadmore.toggleClass($this.options.cls).css('animation-duration', '');
                	
                    /*
                    UI.Utils.animate($this.toreadmore, animations[1]+' uk-animation-reverse').then(function(){
                        $this.toreadmore.toggleClass($this.options.cls).css('animation-duration', '');
                        //UI.$win.trigger("resize");
                        UI.Utils.checkDisplay($this.toreadmore);
                    });
                    */
                }

            }
            else
            {
                this.toreadmore.toggleClass(this.options.cls);
                UI.Utils.checkDisplay(this.toreadmore);
            }

        },

        getContent: function()
        {
            this.toreadmore = this.element.prev();
        },
    });

})(UIkit);
