(function( $ ) {
    $.fn.photoswipe = function(options){
        var galleries = [],
            _options = options;
        
        var init = function($this){
            galleries = [];
									
			$this.each(function(i, photo)
			{
				var $photo_options = str2json($(photo).attr('data-tm-photoswipe')),
					size = $photo_options.size.split('x');
					
					if (size.length != 2){
                        throw SyntaxError("Missing data-size attribute.");
                    }
					
					if (!galleries[$photo_options.group]) galleries[$photo_options.group] = { items: [] };
					
					$(photo).data('gallery-id', $photo_options.group);
                    $(photo).data('photo-id', galleries[$photo_options.group].items.length);
					
					var item = {
                        src: $(photo).attr('href'),
                        msrc: $photo_options.msrc ? $photo_options.msrc : $(photo).find('img').attr('src'),
                        w: parseInt(size[0],10),
                        h: parseInt(size[1],10),
                        title: $(photo).attr('data-title') ? $(photo).attr('data-title') : $(photo).attr('title'),
						el: $(photo)
                    }
					
					galleries[$photo_options.group].items.push(item);
			});
			
			$('html').on('click', '[data-tm-photoswipe]', function(e){
				e.preventDefault();
				
				var gid = $(this).data('gallery-id'),
					pid = $(this).data('photo-id');
				
				openGallery(gid, pid);
			});
			
        }
                		
		var str2json = function(str, notevil) {
			try {
				if (notevil) {
					return JSON.parse(str
						// wrap keys without quote with valid double quote
						.replace(/([\$\w]+)\s*:/g, function(_, $1){return '"'+$1+'":';})
						// replacing single quote wrapped ones to double quote
						.replace(/'([^']+)'/g, function(_, $1){return '"'+$1+'"';})
					);
				} else {
					return (new Function("", "var json = " + str + "; return JSON.parse(JSON.stringify(json));"))();
				}
			} catch(e) { return false; }
		};
        
        var openGallery = function(gid, pid){
            var pswpElement = document.querySelectorAll('.pswp')[0],
                items = galleries[gid].items,
                options = {
                    index: pid,
                    galleryUID: gid,
					showHideOpacity: false,
					showAnimationDuration: 333,
					hideAnimationDuration: 333,
					bgOpacity: 1,
					spacing: 0.12,
					allowPanToNext: true,
					maxSpreadZoom: 2,
					loop: false,
					pinchToClose: true,
					closeOnScroll: false,
					closeOnVerticalDrag: true,
					mouseUsed: false,
					escKey: true,
					arrowKeys: true,
					history: false,
					galleryPIDs: false,
					shareEl: false,
					getThumbBoundsFn: function(index) {
						var thumbnail = items[index].el[0],
                            pageYScroll = window.pageYOffset || document.documentElement.scrollTop,
                            rect = thumbnail.getBoundingClientRect(); 

                        return {x:rect.left, y:rect.top + pageYScroll, w:rect.width};
                    }
                };
				
			//console.log(items);
            $.extend(options, _options);
            var gallery = new PhotoSwipe( pswpElement, PhotoSwipeUI_Default, items, options);
            gallery.init();
        }
        
        // initialize
        init(this);
                
        return this;
    };
}( jQuery ));