<article class="uk-article tm-article-full" <?php if ($permalink) echo 'data-permalink="'.$permalink.'"'; ?>>
	
    <?php 
	$img_class = 'tm-article-img';
	$og_tags = array(); 
	
	if($image)
	{
		jimport('siniestro.image_lib.image');
		
		// add og image metatag
		$og_tags['image'] = SiniestroImage::createThumb( $image, 'cache/images', 600, 315, 'crop-m');// 1200 x 630
	}
	
	if($item->metadesc){
		// add og description metatag
		$og_tags['description'] = JHtml::_('string.truncate', $item->metadesc, 350, true, false);
	}
	
	if ($title) 
	{
		// add og title metatag
		$og_tags['title'] = $title;
	}
	
	$this['siniestro']->addOGTags($og_tags);
	?>
    	
	<?php if ($title) 
	{
		?>
		<h1 class="uk-article-title">
			<span><?php echo $title; ?></span>
            <?php if ($edit) 
			{ ?>
            	<span class="uk-text-small"><?php echo $edit; ?></span>
			<?php 
			} ?>
        </h1>
	<?php 
	} ?>

	<?php echo $hook_aftertitle; ?>

	<?php if ($author || $date || $category) : ?>
	<p class="uk-article-meta">

		<?php

			$author   = ($author && $author_url) ? '<a href="'.$author_url.'">'.$author.'</a>' : $author;
			$date     = ($date) ? ($datetime ? '<time datetime="'.$datetime.'">'.JHtml::_('date', $date, JText::_('DATE_FORMAT_LC3')).'</time>' : JHtml::_('date', $date, JText::_('DATE_FORMAT_LC3'))) : '';
			$category = ($category && $category_url) ? '<a href="'.$category_url.'">'.$category.'</a>' : $category;

			if ($author && $date) {
				printf(JText::_('TPL_WARP_META_AUTHOR_DATE'), $author, $date);
			} elseif ($author) {
				printf(JText::_('TPL_WARP_META_AUTHOR'), $author);
			} elseif ($date) {
				printf(JText::_('TPL_WARP_META_DATE'), $date);
			}

			if ($category) {
				echo ' ';
				printf(JText::_('TPL_WARP_META_CATEGORY'), $category);
			}

		?>

	</p>
	<?php endif; ?>
    
    <?php if($social_code) 
	{ ?>
    	<div class="tm-addthis uk-text-right"><?php echo $social_code; ?></div>
        <hr />
    <?php
	}?>
    
    <?php if ($image && $image_alignment == 'none') 
	{ ?>
		<div class="<?php echo $img_class; ?>"><img src="<?php echo $image; ?>" alt="<?php echo $image_alt; ?>"></div>
	<?php 
	} ?>

	<?php if ($image && $image_alignment != 'none') 
	{ ?>
		<div class="uk-align-small-<?php echo $image_alignment; ?> <?php echo $img_class; ?>">
        	<img src="<?php echo $image; ?>" alt="<?php echo $image_alt; ?>">
        </div>
	<?php 
	} ?>

	<?php echo $hook_beforearticle; ?>
	
	<?php if ($article) : ?>
        <div class="tm-article-content uk-clearfix">
            <?php echo $article; ?>
        </div>
	<?php endif; ?>

	<?php if ($tags) : ?>
		<p class="tm-article-tags"><?php echo JText::_('TPL_WARP_TAGS').': '.$tags; ?></p>
	<?php endif; ?>
    
    <?php if ($this['config']->get('article_meta', false) && ($date_published || $date_modified || $hits)) : ?>
	<?php
        $date_published = ($date_published) ? JHtml::_('date', $date_published, JText::_('DATE_FORMAT_LC3')) : '';
        $date_modified = ($date_modified) ? JHtml::_('date', $date_modified, JText::_('DATE_FORMAT_LC3')) : '';
    ?>
    <ul class="uk-list">
        <?php if ($date_published) : ?>
            <li><?php printf(JText::_('COM_CONTENT_PUBLISHED_DATE_ON'), $date_published); ?></li>
        <?php endif; ?>

        <?php if ($date_modified) : ?>
            <li><?php printf(JText::_('COM_CONTENT_LAST_UPDATED'), $date_modified); ?></li>
        <?php endif; ?>

        <?php if ($hits) : ?>
            <li><?php printf(JText::_('COM_CONTENT_ARTICLE_HITS'), $hits); ?></li>
        <?php endif; ?>
    </ul>
    <?php endif; ?>
        		
	<?php if ($previous || $next) : ?>
        <ul class="uk-pagination">
            <?php if ($previous) : ?>
            <li class="uk-pagination-previous">
                <a href="<?php echo $previous; ?>"><i class="uk-icon-angle-double-left"></i> <?php echo JText::_('JPREV');?></a>
            </li>
            <?php endif; ?>
    
            <?php if ($next) : ?>
            <li class="uk-pagination-next">
                <a href="<?php echo $next; ?>"><?php echo JText::_('JNEXT');?> <i class="uk-icon-angle-double-right"></i></a>
            </li>
            <?php endif; ?>
        </ul>
	<?php endif; ?>

	<?php echo $hook_afterarticle; ?>

</article>