<?php

/**

* @package   Warp Theme Framework

* @author    YOOtheme http://www.yootheme.com

* @copyright Copyright (C) YOOtheme GmbH

* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL

*/



// no direct access

defined('_JEXEC') or die;



JHtml::addIncludePath(JPATH_COMPONENT.'/helpers');





?>



<?php

$app = JFactory::getApplication();

$app->input->set('layout', 'blog');

?>

<div class="tm-category-blog">

	<?php if ($this->params->get('show_page_heading') || $this->params->get('page_subheading') || $this->params->get('show_description', 1) || $this->params->def('show_description_image', 1) || $this->params->get('show_category_title', 1)) : ?>

        

        <div class="tm-panel-category">

    

            <?php if ($this->params->get('show_page_heading')) : ?>

                <h1 class="uk-article-title"><span><?php echo $this->escape($this->params->get('page_heading')); ?></span></h1>

            <?php endif; ?>

    

            <?php if ($this->params->get('page_subheading')) : ?>

                <h1 class="uk-article-title"><span><?php echo $this->escape($this->params->get('page_subheading')); ?></span></h1>

            <?php endif; ?>

    

            <?php if ($this->params->get('show_category_title', 1)) : ?>

                <h1 class="uk-article-title"><span><?php echo $this->category->title;?></span></h1>

            <?php endif; ?>

    

            <?php if ($this->params->get('show_description', 1) || $this->params->def('show_description_image', 1)) :?>

                <div class="tm-category-content uk-clearfix">

        

                    <?php if ($this->params->get('show_description_image') && $this->category->getParams()->get('image')) : ?>

                        <img src="<?php echo $this->category->getParams()->get('image'); ?>" alt="<?php echo $this->category->getParams()->get('image'); ?>" class="uk-align-right" />

                    <?php endif; ?>

        

                    <?php if ($this->params->get('show_description') && $this->category->description) echo JHtml::_('content.prepare', $this->category->description, '', 'com_content.category'); ?>

        

                    <?php if ($this->params->get('show_tags', 1) && !empty($this->category->tags->itemTags)) 

                    {

                        JLoader::register('TagsHelperRoute', JPATH_BASE . '/components/com_tags/helpers/route.php');

                        ?>

                        

                        <p class="tm-article-tags">

                            <?php echo JText::_('TPL_WARP_TAGS').': '; ?>

                        

                            <?php foreach ($this->category->tags->itemTags as $i => $tag) 

                            { ?>

                                <?php if (in_array($tag->access, JAccess::getAuthorisedViewLevels(JFactory::getUser()->get('id')))) 

                                { ?>

                                    <?php if($i > 0) echo ', '; ?>

                                    <a href="<?php echo JRoute::_(TagsHelperRoute::getTagRoute($tag->tag_id . ':' . $tag->alias));?>"><?php echo $this->escape($tag->title); ?></a>

                                <?php

                                }?>

                            <?php

                            } ?>

                        </p>

                    <?php

                    } ?>

               

                </div>

            <?php endif; ?>

    

        </div>

    <?php endif; ?>

    

    <?php if (empty($this->lead_items) && empty($this->intro_items) && empty($this->link_items)) : ?>

        <?php if ($this->params->get('show_no_articles', 1)) : ?>

            <div class="uk-alert"><?php echo JText::_('COM_CONTENT_NO_ARTICLES'); ?></div>

        <?php endif; ?>

    <?php endif; ?>

    

    <?php // leading articles

    if (!empty($this->lead_items)) 

    { ?>

        <div class="uk-grid tm-leading-article" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin>

            <?php foreach ($this->lead_items as $item) 

            {

                $this->item = $item;

                ?>

                <div class="uk-width-1-1">

                    <div class="uk-panel uk-panel-leading">

                        <?php echo $this->loadTemplate('item'); ?>

                    </div>

                </div>

            <?php

            } ?>

        </div>

    <?php

    }?>

    

    <?php // intro articles

    if (!empty($this->intro_items)) 

    { ?>

        <div class="uk-grid uk-grid-medium tm-items-article tm-items-<?php echo $this->params->get('num_columns', 2);?>-columns" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin>

            <?php foreach ($this->intro_items as $item) 

            {

                $this->item = $item;
                $column_class = $this->params->get('num_columns', 2) == 3 ? 'uk-width-small-1-2 uk-width-large-1-3' : "uk-width-medium-1-{$this->params->get('num_columns', 2)}";
                ?>

                <div class="<?php echo  $column_class;?>">

                    <div class="uk-panel uk-panel-teaser"><?php echo $this->loadTemplate('item'); ?></div>

                </div>

            <?php

            }?>

        </div>

    <?php

    }?>

    

    <?php if (!empty($this->link_items)) : ?>

        <div class="uk-grid tm-links-article">

            <div class="uk-width-1-1">

                <div class="uk-panel uk-panel-header tm-panel-links-article">

                    <h3 class="uk-panel-title"><?php echo JText::_('COM_CONTENT_MORE_ARTICLES'); ?></h3>

                    <ul class="uk-list">

                        <?php foreach ($this->link_items as &$item) : ?>

                        <li><a href="<?php echo JRoute::_(ContentHelperRoute::getArticleRoute($item->slug, $item->catid)); ?>"><?php echo $item->title; ?></a></li>

                        <?php endforeach; ?>

                    </ul>

                </div>

            </div>

        </div>

    <?php endif; ?>

    

    <?php if (($this->params->def('show_pagination', 1) == 1  || ($this->params->get('show_pagination') == 2)) && ($this->pagination->get('pages.total') > 1)) : ?>

    <?php echo $this->pagination->getPagesLinks(); ?>

    <?php endif; ?>

</div>