<?php
/**
* @package   Warp Theme Framework
* @author    YOOtheme http://www.yootheme.com
* @copyright Copyright (C) YOOtheme GmbH
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

// no direct access
defined('_JEXEC') or die;

JHtml::addIncludePath(JPATH_COMPONENT.'/helpers');

if (empty($this->lead_items) && empty($this->intro_items) && empty($this->link_items)) return;

?>
<div class="tm-category-blog">
	<?php if ($this->params->get('show_page_heading', 1)) : ?>
        <div class="tm-panel-category">
            <h1 class="uk-article-title"><span><?php echo $this->escape($this->params->get('page_heading')); ?></span></h1>
        </div>
    <?php endif; ?>
    
    <?php // leading articles
    if (!empty($this->lead_items)) 
    { ?>
        <div class="uk-grid tm-leading-article">
            <?php foreach ($this->lead_items as $item) 
            {
                $this->item = $item;
                ?>
                <div class="uk-width-1-1">
                    <div class="uk-panel uk-panel-leading">
                        <?php echo $this->loadTemplate('item'); ?>
                    </div>
                </div>
            <?php
            } ?>
        </div>
    <?php
    }?>
    
    <?php // intro articles
    if (!empty($this->intro_items)) 
    { ?>
        <div class="uk-grid tm-items-article" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin>
            <?php foreach ($this->intro_items as $item) 
            {
                $this->item = $item;
                ?>
                <div class="uk-width-medium-1-<?php echo $this->params->get('num_columns', 2);?>">
                    <div class="uk-panel uk-panel-teaser"><?php echo $this->loadTemplate('item'); ?></div>
                </div>
            <?php
            }?>
        </div>
    <?php
    }?>
    
    <?php if (!empty($this->link_items)) : ?>
        <div class="uk-grid tm-links-article">
            <div class="uk-width-1-1">
                <div class="uk-panel uk-panel-header tm-panel-links-article">
                    <h3 class="uk-panel-title"><?php echo JText::_('COM_CONTENT_MORE_ARTICLES'); ?></h3>
                    <ul class="uk-list">
                        <?php foreach ($this->link_items as &$item) : ?>
                        <li><a href="<?php echo JRoute::_(ContentHelperRoute::getArticleRoute($item->slug, $item->catslug)); ?>"><?php echo $item->title; ?></a></li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>
        </div>
    <?php endif; ?>
    
    <?php if (($this->params->def('show_pagination', 1) == 1  || ($this->params->get('show_pagination') == 2)) && ($this->pagination->get('pages.total') > 1)) : ?>
    <?php echo $this->pagination->getPagesLinks(); ?>
    <?php endif; ?>
</div>