<?php
/**
* @package   Warp Theme Framework
* @author    YOOtheme http://www.yootheme.com
* @copyright Copyright (C) YOOtheme GmbH
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

// no direct access
defined('_JEXEC') or die;

JLoader::register('JHtmlUsers', JPATH_COMPONENT . '/helpers/html/users.php');
JHtml::register('users.spacer', array('JHtmlUsers', 'spacer'));

$fieldsets = $this->form->getFieldsets();
if (isset($fieldsets['core']))   unset($fieldsets['core']);
if (isset($fieldsets['params'])) unset($fieldsets['params']);

foreach ($fieldsets as $group => $fieldset): // Iterate through the form fieldsets
	$fields = $this->form->getFieldset($group);
	if (count($fields)):
	?>
        <div id="users-profile-custom" class="uk-panel uk-panel-header uk-margin users-profile-custom-<?php echo $group; ?>">
            
			<?php if (isset($fieldset->label)): // If the fieldset has a label set, display it as the legend. ?>
            	<h3 class="uk-panel-title"><?php echo JText::_($fieldset->label); ?></h3>
            <?php endif; ?>
            
            <dl class="uk-description-list uk-description-list-horizontal">
				<?php foreach ($fields as $field) :
                    if (!$field->hidden && $field->type != 'Spacer') : ?>
                    <dt><strong><?php echo $field->title; ?></strong></dt>
                    <dd>
                        <?php if (JHtml::isRegistered('users.' . $field->id)) : ?>
                            <?php echo JHtml::_('users.' . $field->id, $field->value); ?>
                        <?php elseif (JHtml::isRegistered('users.' . $field->fieldname)) : ?>
                            <?php echo JHtml::_('users.' . $field->fieldname, $field->value); ?>
                        <?php elseif (JHtml::isRegistered('users.' . $field->type)) : ?>
                            <?php echo JHtml::_('users.' . $field->type, $field->value); ?>
                        <?php else : ?>
                            <?php echo JHtml::_('users.value', $field->value); ?>
                        <?php endif; ?>
                    </dd>
                    <?php endif; ?>
                <?php endforeach; ?>
            </dl>
            
        </div>
	<?php endif; ?>
<?php endforeach; ?>