<?php
/**
 *
 * Layout for the shopping cart
 *
 * @package    VirtueMart
 * @subpackage Cart
 * @author Max Milbers
 *
 * @link http://www.virtuemart.net
 * @copyright Copyright (c) 2004 - 2010 VirtueMart Team. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 * VirtueMart is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * @version $Id: cart.php 2551 2010-09-30 18:52:40Z milbo $
 */

// Check to ensure this file is included in Joomla!
defined ('_JEXEC') or die('Restricted access');

vmJsApi::vmValidator();
?>

<div id="cart-view" class="cart-view">
	
    <div class="vm-cart-header-container">
		<h1 class="uk-article-text"><?php echo vmText::_ ('COM_VIRTUEMART_CART_TITLE'); ?></h1>
		<div class="payments-signin-button" ></div>

		<?php if (VmConfig::get ('oncheckout_show_steps', 1) )
		{ ?>

			<?php if($this->checkout_task == 'checkout')
			{ ?>
				<div class="checkoutStep" id="checkoutStep1"><?php echo vmText::_ ('COM_VIRTUEMART_USER_FORM_CART_STEP1');?></div>
			<?php
			}
			else
			{ ?>
				<div class="checkoutStep" id="checkoutStep4"><?php echo vmText::_ ('COM_VIRTUEMART_USER_FORM_CART_STEP4');?></div>
			<?php
			} ?>
			
		<?php
        } ?>
		
        <?php if (!empty($this->continue_link_html)) 
		{ ?>
        	<div class="uk-text-right vm-continue-shopping">
				<?php echo $this->continue_link_html; ?>
            </div>
		<?php
        } ?>
	</div>

	<?php
	$uri = vmUri::getCurrentUrlBy('get');
	$uri = str_replace(array('?tmpl=component','&tmpl=component'),'',$uri);
	echo shopFunctionsF::getLoginForm ($this->cart, FALSE, $uri);
	?>

	<?php // This displays the form to change the current shopper
	if ($this->allowChangeShopper and !$this->isPdf){
	{ ?>
		<?php echo $this->loadTemplate ('shopperform'); ?>
	<?php
    } ?>

	<hr />
	<div>
		<?php $taskRoute = ''; ?>
        
        <form class="uk-form" method="post" id="checkoutForm" name="checkoutForm" action="<?php echo JRoute::_ ('index.php?option=com_virtuemart&view=cart' . $taskRoute, $this->useXHTML, $this->useSSL); ?>">
            <?php if(!$this->isPdf and VmConfig::get('multixcart')=='byselection'){
            { ?>
                <?php if (!class_exists('ShopFunctions')) require(VMPATH_ADMIN . DS . 'helpers' . DS . 'shopfunctions.php'); ?>
                <?php echo shopFunctions::renderVendorFullVendorList($this->cart->vendorId); ?>
                <button type="submit" name="updatecart" title="<?php echo vmText::_('COM_VIRTUEMART_SAVE'); ?>" class="uk-button"><?php echo vmText::_('COM_VIRTUEMART_SAVE'); ?></button>
            <?php 
            } ?>
            
            <?php echo $this->loadTemplate ('address'); ?>
            
            <?php // This displays the pricelist MUST be done with tables, because it is also used for the emails
            echo $this->loadTemplate ('pricelist'); ?>
    
            <?php if (!empty($this->checkoutAdvertise)) 
            { ?>
                <div id="checkout-advertise-box">
                    <?php foreach ($this->checkoutAdvertise as $checkoutAdvertise) 
                    { ?>
                        <div class="checkout-advertise"><?php echo $checkoutAdvertise; ?></div>
                    <?php
                    } ?>
                </div>
            <?php
            } ?>
    
            <?php echo $this->loadTemplate ('cartfields'); ?>
    
            <div class="checkout-button-top uk-text-right"><?php echo $this->checkout_link_html; ?></div>
    
            <?php // Continue and Checkout Button END ?>
            <input type='hidden' name='order_language' value='<?php echo $this->order_language; ?>'/>
            <input type='hidden' name='task' value='updatecart'/>
            <input type='hidden' name='option' value='com_virtuemart'/>
            <input type='hidden' name='view' value='cart'/>
        </form>
    </div>
    
    <?php

	if(VmConfig::get('oncheckout_ajax', false))
	{
		vmJsApi::addJScript('updDynamicListeners', "
			if (typeof Virtuemart.containerSelector === 'undefined') Virtuemart.containerSelector = '#cart-view';
			if (typeof Virtuemart.container === 'undefined') Virtuemart.container = jQuery(Virtuemart.containerSelector);
			
			jQuery(document).ready(function() {
				if (Virtuemart.container)
					Virtuemart.updDynFormListeners();
			});
		");
	}
	
	
	vmJsApi::addJScript('vm.checkoutFormSubmit', "
		Virtuemart.bCheckoutButton = function(e) {
			e.preventDefault();
			jQuery(this).vm2front('startVmLoading');
			jQuery(this).attr('disabled', 'true');
			jQuery(this).removeClass( 'vm-button-correct' );
			jQuery(this).addClass( 'vm-button' );
			jQuery(this).fadeIn( 400 );
			var name = jQuery(this).attr('name');
			var div = '<input name=\"'+name+'\" value=\"1\" type=\"hidden\">';
		
			jQuery('#checkoutForm').append(div);
			//Virtuemart.updForm();
			jQuery('#checkoutForm').submit();
		}
		jQuery(document).ready(function($) {
			jQuery(this).vm2front('stopVmLoading');
			var el = jQuery('#checkoutFormSubmit');
			el.unbind('click dblclick');
			el.on('click dblclick',Virtuemart.bCheckoutButton);
		});
	");
	
	if( !VmConfig::get('oncheckout_ajax', false))
	{
		vmJsApi::addJScript('vm.STisBT', "
			jQuery(document).ready(function($) {
				if ( $('#STsameAsBTjs').is(':checked') ) {
					$('#output-shipto-display').hide();
				} else {
					$('#output-shipto-display').show();
				}
				$('#STsameAsBTjs').click(function(event) {
					if($(this).is(':checked')){
						$('#STsameAsBT').val('1') ;
						$('#output-shipto-display').hide();
					} else {
						$('#STsameAsBT').val('0') ;
						$('#output-shipto-display').show();
					}
					var form = jQuery('#checkoutFormSubmit');
					form.submit();
				});
			});
		");
	}
	
	$this->addCheckRequiredJs();
	?>

	<div style="display:none;" id="cart-js">
		<?php echo vmJsApi::writeJS(); ?>
	</div>

</div>

