<?php
/**
*
* Layout for the add to cart popup
*
* @package	VirtueMart
* @subpackage Cart
* @author Max Milbers
*
* @link http://www.virtuemart.net
* @copyright Copyright (c) 2013 VirtueMart Team. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
* VirtueMart is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* @version $Id: cart.php 2551 2010-09-30 18:52:40Z milbo $
*/

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');
$this->cart_link = JRoute::_(str_replace(JURI::base(), '', $this->cart_link));
?>
<div class="uk-modal-header">
    <h2><?php echo vmText::_('COM_VIRTUEMART_CART_TITLE');?></h2>
</div>
<div class="uk-modal-body">
	<?php if($this->products)
    { ?>
        <?php foreach($this->products as $product)
        { ?>
            <?php if($product->quantity > 0)
            { ?>
                <p class="uk-alert"><?php echo vmText::sprintf('COM_VIRTUEMART_CART_PRODUCT_ADDED', $product->product_name, $product->quantity); ?></p>
            <?php
            } else 
            { ?>
                <?php if(!empty($product->errorMsg))
                { ?>
                    <p class="uk-alert uk-alert-danger"><?php echo $product->errorMsg; ?></p>
                <?php
                }?>
            <?php
            }?>
        <?php
        }?>
    <?php
    } ?>
    
    <?php if(VmConfig::get('popup_rel', 1))
	{
        //VmConfig::$echoDebug = true;
        if ($this->products and is_array($this->products) and count($this->products)> 0 ) 
		{
			$product = reset($this->products);
    
            $customFieldsModel = VmModel::getModel('customfields');
            $product->customfields = $customFieldsModel->getCustomEmbeddedProductCustomFields($product->allIds,'R');
            $customFieldsModel->displayProductCustomfieldFE($product,$product->customfields);
			
			$products = array();
			if(!empty($product->customfields))
			{
				$product_model 	= VmModel::getModel('product');
				foreach ($product->customfields as $field) $products[] = $product_model->getProduct($field->customfield_value); 
				$product_model->addImages($products);
						
				$params_related_products = array();
				$params_related_products['currency'] 				= $this->currency;
				$params_related_products['products'] 				= $products;
				$params_related_products['columns'] 				= 0;
				$params_related_products['columns_small'] 			= 2;
				$params_related_products['columns_medium'] 			= 3;
				$params_related_products['columns_large'] 			= VmConfig::get ( 'products_per_row', 3 );
				$params_related_products['columns_xlarge'] 			= 0;
				$params_related_products['show_rating'] 			= false;
				$params_related_products['show_stock'] 				= false;
				$params_related_products['show_short_description']	= false;
				$params_related_products['show_sku']				= false;
				$params_related_products['show_prices'] 			= false;
				$params_related_products['show_addtocart'] 			= false;
				$params_related_products['show_readmore'] 			= false;
				$params_related_products['gutter'] 					= 'small';
			}
			//echo count($product->customfields).'hola';
			?>
            <?php if(count($products))
			{ ?>
                <div>
                    <div class="uk-panel uk-panel-header">
                        <h3 class="uk-panel-title"><?php echo JText::_('COM_VIRTUEMART_RELATED_PRODUCTS'); ?></h3>
                        <?php echo shopFunctionsF::renderVmSubLayout('products', $params_related_products); ?>
                    </div>
                </div>
            <?php
			}?>
            
        <?php
        }
    }
    ?>
</div>

<div class="uk-modal-footer uk-text-right">
    <a class="uk-button uk-hidden" href="<?php echo $this->continue_link;?>" ><?php echo vmText::_('COM_VIRTUEMART_CONTINUE_SHOPPING');?></a>
    <a class="uk-button uk-button-primary" href="<?php echo $this->cart_link;?>"><?php echo vmText::_('COM_VIRTUEMART_CART_SHOW');?></a>
</div>

