<?php
/**
*
* Error Layout for the add to cart popup
*
* @package	VirtueMart
* @subpackage Cart
* @author Max Milbers
*
* @link http://www.virtuemart.net
* @copyright Copyright (c) 2013 VirtueMart Team. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
* @version $Id: cart.php 2551 2010-09-30 18:52:40Z milbo $
*/

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');
?>
<div class="uk-modal-header">
    <h2><?php echo vmText::_('COM_VIRTUEMART_CART_TITLE');?></h2>
</div>

<div class="uk-modal-body">
    <?php if(!empty($this->product_name)) 
	{ ?>
		<p><?php echo $this->product_name; ?></p>
	<?php
    } ?>
    
	<?php if(!empty($this->errorMsg))
	{ ?>
		<div class="uk-alert uk-alert-danger"><?php echo $this->errorMsg; ?></div>
	<?php
    } ?>
    
    <?php 
	$messageQueue = JFactory::getApplication()->getMessageQueue();
	foreach ($messageQueue as $message) 
	{ ?>
		<div class="uk-alert uk-alert-danger"><?php echo $message['message']; ?></div>
	<?php
    } ?>
</div>

<div class="uk-modal-footer uk-text-right">
    <a class="uk-button uk-hidden" href="<?php echo $this->continue_link;?>" ><?php echo vmText::_('COM_VIRTUEMART_CONTINUE_SHOPPING');?></a>
    <a class="uk-button uk-button-primary" href="<?php echo $this->cart_link;?>"><?php echo vmText::_('COM_VIRTUEMART_CART_SHOW');?></a>
</div>

