<?php

/**

 *

 * Show the products in a category

 *

 * @package    VirtueMart

 * @subpackage

 * @author RolandD

 * @author Max Milbers

 * @todo add pagination

 * @link http://www.virtuemart.net

 * @copyright Copyright (c) 2004 - 2010 VirtueMart Team. All rights reserved.

 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php

 * VirtueMart is free software. This version may have been modified pursuant

 * to the GNU General Public License, and as distributed it includes or

 * is derivative of works licensed under the GNU General Public License or

 * other free or open source software licenses.

 * @version $Id: default.php 8663 2015-01-23 14:23:14Z Milbo $

 */



defined ('_JEXEC') or die('Restricted access');



vmJsApi::removeJScript('jquery-ui.min');

vmJsApi::removeJScript('jquery.ui.autocomplete.html');

vmJsApi::removeJScript('jquery.noconflict');

vmJsApi::removeJScript('fancybox/jquery.fancybox-1.3.4.pack');



$infinite_pagination = 'data-uk-infinite-pagination="{lblLoading:\'cargando\', lblLoad:\'cargar más\', finishedMsg: \'No hay más páginas para cargar\', enabledScroll: true}" data-uk-observe=""';

?>

<div class="vm-browse-view">

	<?php if ($this->keyword !== false) 

    { ?>

        <h1 class="uk-article-title"><span>Resultados de: <?php echo $this->keyword; ?></span></h1>

    <?php

    }else if(empty($this->keyword) and !empty($this->category)){ ?>

        <h1 class="uk-article-title"><span><?php echo vmText::_($this->category->category_name); ?></span></h1>

    <?php 

    } ?>

    

    

    <?php if ($this->show_store_desc and !empty($this->vendor->vendor_store_desc))

    { ?>

        <div class="vendor-store-desc"><?php echo $this->vendor->vendor_store_desc; ?></div>

        <hr />

    <?php

    } ?>



    <?php if (!empty($this->showcategory_desc) and empty($this->keyword) and !empty($this->category->category_description))

    { ?>

        <div class="category_description"><?php echo $this->category->category_description; ?></div>

        <hr />

    <?php

    } ?>

    

    <?php if ($this->showsearch or $this->keyword !== false && false)

    {

		//id taken in the view.html.php could be modified

		$category_id  = vRequest::getInt ('virtuemart_category_id', 0);

		?>

            

        <form class="uk-form uk-margin" action="<?php echo JRoute::_ ('index.php?option=com_virtuemart&view=category&limitstart=0', FALSE); ?>" method="get">

            <div class="virtuemart_search">

                <?php echo $this->searchCustomList ?>

                <?php echo $this->searchCustomValues ?>

                <input name="keyword" class="inputbox" type="text" size="20" value="<?php echo $this->keyword ?>"/>

                <button type="submit" class="uk-button" onclick="this.form.keyword.focus();"><?php echo vmText::_ ('COM_VIRTUEMART_SEARCH') ?></button>

            </div>

            <input type="hidden" name="search" value="true"/>

            <input type="hidden" name="view" value="category"/>

            <input type="hidden" name="option" value="com_virtuemart"/>

            <input type="hidden" name="virtuemart_category_id" value="<?php echo $category_id; ?>"/>

        </form>

        

    <?php

    } ?>

    

    <?php // Show child categories

    if ($this->showcategory and empty($this->keyword))

    { ?>

        <?php if (!empty($this->category->haschildren) && count($this->category->children) > 0) 

        {

            $params_categories = array();

            $params_categories['categories'] 		= $this->category->children;

            $params_categories['columns'] 			= 0;

            $params_categories['columns_small'] 	= 2;

            $params_categories['columns_medium'] 	= 3;

            $params_categories['columns_large'] 	= VmConfig::get ( 'categories_per_row', 3 );

            $params_categories['columns_xlarge'] 	= 0;

            ?>

            

            <div class="uk-margin">

                <div class="vm-category-list">

                    <div class="uk-panel uk-panel-header">

                        <!--<h3 class="uk-panel-title"><span>Categorias</span></h3>-->

                        <?php echo ShopFunctionsF::renderVmSubLayout('categories', $params_categories); ?>

                    </div>

                </div>

            </div>

        

        <?php

        } ?>

    <?php

    }?>

    

    <?php if($this->showproducts)

    { ?>

        <?php if (!empty($this->products)) 

        {

            $params_products = array();

            $params_products['currency'] 				= $this->currency;

            $params_products['products'] 				= $this->products;

            $params_products['columns'] 				= 0;

            $params_products['columns_small'] 			= 2;

            $params_products['columns_medium'] 			= 2;

            $params_products['columns_large'] 			= $this->perRow;

            $params_products['columns_xlarge'] 			= 0;

            $params_products['show_rating'] 			= false; //$this->showRating;

            $params_products['show_stock'] 				= false;

            $params_products['show_short_description']	= false;

			$params_products['show_sku']				= false;

            $params_products['show_prices'] 			= true;

			$params_products['show_offer'] 				= false;

            $params_products['show_addtocart'] 			= true;

            $params_products['show_readmore'] 			= false;

			$params_products['show_badge_sold'] 		= false;

			$params_products['show_badge_new'] 			= false;

			$params_products['show_badge_promo'] 		= false;

			$params_products['show_badge_sale'] 		= false;

            ?>

            

            <?php if(!empty($this->orderByList))

            { ?>

                <?php //echo $this->loadTemplate('orderby_displaynumber'); ?>

            <?php

            } ?>

			                                                

            <?php if($this->vmPagination->get('pages.total') > 1)

            { ?>

                <div class="vm-pagination vm-pagination-top uk-margin uk-hidden">

                    <?php echo $this->vmPagination->getPagesLinks (); ?>

                    <?php //echo $this->vmPagination->getPagesCounter (); ?>

                </div>

            <?php

            }?>

            

            <div class="uk-margin">

                <div class="vm-content-list" <?php echo $infinite_pagination;?>>

                    <div class="uk-panel uk-panel-header">

                        <!--<h3 class="uk-panel-title"><span>Productos</span></h3>-->

                        <?php echo shopFunctionsF::renderVmSubLayout($this->productsLayout, $params_products); ?>

                    </div>

                </div>

            </div>

            

            

            <?php if($this->vmPagination->get('pages.total') > 1)

            { ?>

                <div class="vm-pagination vm-pagination-bottom uk-margin uk-hidden">

                    <?php echo $this->vmPagination->getPagesLinks (); ?>

                    <?php //echo $this->vmPagination->getPagesCounter (); ?>

                </div>

            <?php

            }?>

                

        <?php

        } elseif ($this->keyword !== false) 

        { ?>

            <?php echo vmText::_('COM_VIRTUEMART_NO_RESULT') . ($this->keyword ? ' : (' . $this->keyword . ')' : ''); ?>

        <?php

        } ?>

    

    <?php

    } ?>



</div>



<?php if(VmConfig::get ('ajax_category', false))

{

	$j = "Virtuemart.container = jQuery('.category-view');

	Virtuemart.containerSelector = '.category-view';";



	vmJsApi::addJScript('ajax_category',$j);

	vmJsApi::jDynUpdate();

} ?>