<?php
/**
 *
 * Layout for the shopper mail, when he confirmed an ordner
 *
 * The addresses are reachable with $this->BTaddress, take a look for an exampel at shopper_adresses.php
 *
 * With $this->orderDetails['shipmentName'] or paymentName, you get the name of the used paymentmethod/shippmentmethod
 *
 * In the array order you have details and items ($this->orderDetails['details']), the items gather the products, but that is done directly from the cart data
 *
 * $this->orderDetails['details'] contains the raw address data (use the formatted ones, like BTaddress). Interesting informatin here is,
 * order_number ($this->orderDetails['details']['BT']->order_number), order_pass, coupon_code, order_status, order_status_name,
 * user_currency_rate, created_on, customer_note, ip_address
 *
 * @package	VirtueMart
 * @subpackage Cart
 * @author Max Milbers, Valerie Isaksen
 *
 * @link http://www.virtuemart.net
 * @copyright Copyright (c) 2004 - 2010 VirtueMart Team. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 * VirtueMart is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 *
 */
// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');

$style_table_border = 'border-right:1px solid #ccc; border-bottom: 1px solid #ccc;';
$style_td_border = 'border-left:1px solid #ccc; border-top: 1px solid #ccc;';
$border_color 	= '#ddd';
$img_width 		= 'width:150px; height:auto;';
$h1 			= 'font-weight:normal; font-size:26px; color:#424f59!important;';
$button 		= 'background-color:#0095dd; text-decoration:none; font-size:20px; display:block; color:#ffffff; padding:15px!important';
$hr 			= '<hr style="border-color:#ddd;" />';
?>

<html>
<head>
</head>
<body>
    <div style="background-color:#f2f2f2; width:100% !important; min-height:100% !important; padding:50px; margin:0" marginheight="0" marginwidth="0">
        <center>
            <table width="700" border="0" cellpadding="0" cellspacing="0" style="background-color:#fff;">
                <tbody>
                    <tr>
                        <td style="padding:30px 20px; border:1px solid #ddd">
                        	<?php // Shop desc for shopper and vendor
							if ($this->recipient == 'shopper') 
							{ ?>
								<?php echo $this->loadTemplate('header'); ?>
							<?php
							}?>
						
							<?php // Message for shopper or vendor
							echo $this->loadTemplate($this->recipient); ?>
                            
							<?php // render shipto billto adresses
							echo $this->loadTemplate('shopperaddresses'); ?>
						
							<?php if( in_array($this->orderDetails['details']['BT']->order_status, array('A')) && $this->recipient == 'shopper' )
							{?>
								<?php // render quotation price list
                                echo $this->loadTemplate('quotation_pricelist'); ?>
                            <?php
							}else
							{ ?>
                            	<?php // render price list
                                echo $this->loadTemplate('pricelist'); ?>
							<?php
                            }?>
							
							<?php // more infos
							echo $this->loadTemplate($this->recipient . '_more'); ?>
							
							<?php // end of mail
							echo $this->loadTemplate('footer');	?>
                        </td>
                   </tr>
                </tbody>
            </table>
        </center>
    </div>
</body>
</html>