<?php
/**
*
* Order items view
*
* @package	VirtueMart
* @subpackage Orders
* @author Max Milbers, Valerie Isaksen
* @link http://www.virtuemart.net
* @copyright Copyright (c) 2004 - 2010 VirtueMart Team. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
* VirtueMart is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* @version $Id: details_items.php 5432 2012-02-14 02:20:35Z Milbo $
*/

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');

$colspan = 9;

if ($this->doctype != 'invoice') {
    $colspan -= 4;
} elseif ( ! VmConfig::get('show_tax')) {
    $colspan -= 1;
}

$handled = array();
$discountsBill = false;
$taxBill = false;
$vats = 0;
foreach($this->orderDetails['calc_rules'] as $rule){
	if(isset($sumRules[$rule->virtuemart_calc_id])){	// or $rule->calc_kind=='payment' or $rule->calc_kind=='shipment'){
		continue;
	}
	$handled[$rule->virtuemart_calc_id] = true;
	$r = new stdClass();
	$r->calc_result = $rule->calc_result;
	$r->calc_amount = $rule->calc_amount;
	$r->calc_rule_name = $rule->calc_rule_name;
	$r->calc_kind = $rule->calc_kind;
	$r->calc_value = $rule->calc_value;

	if($rule->calc_kind == 'DBTaxRulesBill' or $rule->calc_kind == 'DATaxRulesBill'){
		$discountsBill[$rule->virtuemart_calc_id] = $r;
	}
	if($rule->calc_kind == 'taxRulesBill' or $rule->calc_kind == 'VatTax' or $rule->calc_kind=='payment' or $rule->calc_kind=='shipment'){
		//vmdebug('method rule',$rule);
		$r->label = shopFunctionsF::getTaxNameWithValue($rule->calc_rule_name,$rule->calc_value);
		if(isset($taxBill[$rule->virtuemart_calc_id])){
			$taxBill[$rule->virtuemart_calc_id]->calc_amount += $r->calc_amount;
		} else {
			$taxBill[$rule->virtuemart_calc_id] = $r;
		}

	}

}

$style_table_border = 'border-right:1px solid #ccc; border-bottom: 1px solid #ccc;';
$style_td_border = 'border-left:1px solid #ccc; border-top: 1px solid #ccc;';

?>
<table style="<?php echo $style_table_border; ?>" width="100%" cellspacing="0" cellpadding="10" border="0">
	<tr align="left" class="sectiontableheader">
		<td style="<?php echo $style_td_border; ?>" align="left" width="5%"><strong><?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_SKU') ?></strong></td>
		<td style="<?php echo $style_td_border; ?>" align="left" colspan="2" width="38%" ><strong><?php echo vmText::_('COM_VIRTUEMART_PRODUCT_NAME_TITLE') ?></strong></td>
		<td style="<?php echo $style_td_border; ?>" align="center" width="10%"><strong><?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_PRODUCT_STATUS') ?></strong></td>
		<?php if ($this->doctype == 'invoice') { ?>
		<td style="<?php echo $style_td_border; ?>" align="right" width="10%" ><strong><?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_PRICE') ?></strong></td>
		<?php } ?>
		<td style="<?php echo $style_td_border; ?>" align="right" width="6%"><strong><?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_QTY') ?></strong></td>
		
		<?php if ($this->doctype == 'invoice')
		{ ?>
			<?php if ( VmConfig::get('show_tax'))
			{ ?>
				<td style="<?php echo $style_td_border; ?>" align="right" width="10%" >
        			<strong>
					<?php
					if(count($taxBill) == 1)
					{
						reset($taxBill);
						$t = current($taxBill);
						echo shopFunctionsF::getTaxNameWithValue($t->calc_rule_name, $t->calc_value);
					}
					else
					{
						echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_PRODUCT_TAX');
					}?>
         			</strong>
                </td>
		 	<?php
         	} ?>
			
            <td style="<?php echo $style_td_border; ?>" align="right" width="11%"><strong><?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_SUBTOTAL_DISCOUNT_AMOUNT') ?></strong></td>
			<td style="<?php echo $style_td_border; ?>" align="right" width="11%"><strong><?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_TOTAL') ?></strong></td>
		<?php
        } ?>
	</tr>

<?php
	$menuItemID = shopFunctionsF::getMenuItemId($this->orderDetails['details']['BT']->order_language);
	if(!class_exists('VirtueMartModelCustomfields'))require(VMPATH_ADMIN.DS.'models'.DS.'customfields.php');
	VirtueMartModelCustomfields::$useAbsUrls = ($this->isMail or $this->isPdf);

	foreach($this->orderDetails['items'] as $item) {
		$qtt = $item->product_quantity ;
		$product_link = JURI::root().'index.php?option=com_virtuemart&view=productdetails&virtuemart_category_id=' . $item->virtuemart_category_id .
			'&virtuemart_product_id=' . $item->virtuemart_product_id . '&Itemid=' . $menuItemID;

		?>
		<tr valign="top">
			<td style="<?php echo $style_td_border; ?>" align="left">
				<?php echo $item->order_item_sku; ?>
			</td>
			<td style="<?php echo $style_td_border; ?>" align="left" colspan="2" >
				<div float="right" ><a href="<?php echo $product_link; ?>"><?php echo $item->order_item_name; ?></a></div>
                <?php $product_attribute = VirtueMartModelCustomfields::CustomsFieldOrderDisplay($item,'FE'); ?>
				<?php if($product_attribute)
				{ ?>
                	<div><small><?php echo $product_attribute;?></small></div>
				<?php
				}?>
			</td>
			<td style="<?php echo $style_td_border; ?>" align="center">
				<?php echo $this->orderstatuses[$item->order_status]; ?>
			</td>
		<?php if ($this->doctype == 'invoice') { ?>
			<td style="<?php echo $style_td_border; ?>" align="right"   class="priceCol" >
				<?php
				$item->product_discountedPriceWithoutTax = (float) $item->product_discountedPriceWithoutTax;
				if (!empty($item->product_priceWithoutTax) && $item->product_discountedPriceWithoutTax != $item->product_priceWithoutTax) {
					echo '<span style="text-decoration:line-through; color:#999;" class="line-through">'.$this->currency->priceDisplay($item->product_item_price, $this->currency) .'</span><br />';
					echo '<span >'.$this->currency->priceDisplay($item->product_discountedPriceWithoutTax, $this->currency) .'</span><br />';
				} else {
					echo '<span >'.$this->currency->priceDisplay($item->product_item_price, $this->currency) .'</span><br />'; 
				}
				?>
			</td>
		<?php } ?>
			<td style="<?php echo $style_td_border; ?>" align="right" >
				<?php echo $qtt; ?>
			</td>
		<?php if ($this->doctype == 'invoice') { ?>
			<?php if ( VmConfig::get('show_tax')) { ?>
				<td style="<?php echo $style_td_border; ?>" align="right" class="priceCol"><?php echo "<span  class='priceColor2'>".$this->currency->priceDisplay($item->product_tax ,$this->currency, $qtt)."</span>" ?></td>
                                <?php } ?>
			<td style="<?php echo $style_td_border; ?>" align="right" class="priceCol" >
				<?php echo  $this->currency->priceDisplay( $item->product_subtotal_discount, $this->currency );  //No quantity is already stored with it ?>
			</td>
			<td style="<?php echo $style_td_border; ?>" align="right"  class="priceCol">
				<?php
				$item->product_basePriceWithTax = (float) $item->product_basePriceWithTax;
				$class = '';
				if(!empty($item->product_basePriceWithTax) && $item->product_basePriceWithTax != $item->product_final_price ) {
					echo '<span style="text-decoration:line-through; color:#999;" class="line-through" >'.$this->currency->priceDisplay($item->product_basePriceWithTax,$this->currency,$qtt) .'</span><br />' ;
				}
				elseif (empty($item->product_basePriceWithTax) && $item->product_item_price != $item->product_final_price) {
					echo '<span style="text-decoration:line-through; color:#999;" class="line-through">' . $this->currency->priceDisplay($item->product_item_price,$this->currency,$qtt) . '</span><br />';
				}

				echo $this->currency->priceDisplay(  $item->product_subtotal_with_tax ,$this->currency); //No quantity or you must use product_final_price ?>
			</td>
		<?php } ?>
		</tr>

<?php
	}
?>
<?php if ($this->doctype == 'invoice') { ?>
<tr><td style="<?php echo $style_td_border; ?>" colspan="<?php echo $colspan ?>"></td></tr>
 <tr class="sectiontableentry1">
			<td style="<?php echo $style_td_border; ?>" colspan="6" align="right"><?php echo vmText::_('COM_VIRTUEMART_ORDER_PRINT_PRODUCT_PRICES_TOTAL'); ?></td>

                        <?php if ( VmConfig::get('show_tax')) { ?>
			<td style="<?php echo $style_td_border; ?>" align="right"><?php echo "<span  class='priceColor2'>".$this->currency->priceDisplay($this->orderDetails['details']['BT']->order_tax, $this->currency)."</span>" ?></td>
                        <?php } ?>
			<td style="<?php echo $style_td_border; ?>" align="right"><?php echo "<span  class='priceColor2'>".$this->currency->priceDisplay($this->orderDetails['details']['BT']->order_discountAmount, $this->currency)."</span>" ?></td>
			<td style="<?php echo $style_td_border; ?>" align="right"><?php echo $this->currency->priceDisplay($this->orderDetails['details']['BT']->order_salesPrice, $this->currency) ?></td>
		  </tr>
<?php
if ($this->orderDetails['details']['BT']->coupon_discount <> 0.00) {
    $coupon_code=$this->orderDetails['details']['BT']->coupon_code?' ('.$this->orderDetails['details']['BT']->coupon_code.')':'';
	?>
	<tr>
		<td style="<?php echo $style_td_border; ?>" align="right" class="pricePad" colspan="6"><?php echo vmText::_('COM_VIRTUEMART_COUPON_DISCOUNT').$coupon_code ?></td>
		<?php if ( VmConfig::get('show_tax')) { ?>
			<td style="<?php echo $style_td_border; ?>" align="right"> </td>
		<?php } ?>
		<td style="<?php echo $style_td_border; ?>" align="right"></td>
		<td style="<?php echo $style_td_border; ?>" align="right"><?php echo $this->currency->priceDisplay($this->orderDetails['details']['BT']->coupon_discount, $this->currency); ?></td>
	</tr>
<?php  } ?>

	<?php
	if($discountsBill)
	{
		foreach($discountsBill as $rule)
		{ ?>
			<tr>
				<td colspan="6" align="right" class="pricePad"><?php echo $rule->calc_rule_name ?> </td>
				<?php if ( VmConfig::get('show_tax'))
				{ ?>
					<td align="right"> </td>
				<?php
                } ?>
				<td align="right"><?php echo $this->currency->priceDisplay($rule->calc_amount, $this->currency); ?></td>
				<td align="right"><?php echo $this->currency->priceDisplay($rule->calc_amount, $this->currency); ?></td>
			</tr>
			<?php
		}
	}
	?>

	<tr>
		<td style="<?php echo $style_td_border; ?>" align="right" class="pricePad" colspan="6"><?php echo $this->orderDetails['shipmentName'] ?></td>

		<?php if ( VmConfig::get('show_tax')) { ?>
		<td style="<?php echo $style_td_border; ?>" align="right"><span class='priceColor2'><?php echo $this->currency->priceDisplay($this->orderDetails['details']['BT']->order_shipment_tax, $this->currency) ?></span> </td>
		<?php } ?>
		<td style="<?php echo $style_td_border; ?>" align="right"></td>
		<td style="<?php echo $style_td_border; ?>" align="right"><?php echo $this->currency->priceDisplay($this->orderDetails['details']['BT']->order_shipment + $this->orderDetails['details']['BT']->order_shipment_tax, $this->currency); ?></td>
	</tr>

	<tr>
		<td style="<?php echo $style_td_border; ?>" align="right" class="pricePad" colspan="6"><?php echo $this->orderDetails['paymentName'] ?></td>

		<?php if ( VmConfig::get('show_tax')) { ?>
		<td style="<?php echo $style_td_border; ?>" align="right"><span class='priceColor2'><?php echo $this->currency->priceDisplay($this->orderDetails['details']['BT']->order_payment_tax, $this->currency) ?></span> </td>
		<?php } ?>
		<td style="<?php echo $style_td_border; ?>" align="right"></td>
		<td style="<?php echo $style_td_border; ?>" align="right"><?php echo $this->currency->priceDisplay($this->orderDetails['details']['BT']->order_payment + $this->orderDetails['details']['BT']->order_payment_tax, $this->currency); ?></td>
	</tr>

	<tr>
		<td style="<?php echo $style_td_border; ?>" align="right" class="pricePad" colspan="6"><strong><?php echo JText::_('COM_VIRTUEMART_ORDER_PRINT_TOTAL') ?></strong></td>

		<?php if ( VmConfig::get('show_tax')) { ?>
		<td style="<?php echo $style_td_border; ?>" align="right"><span class='priceColor2'><?php echo $this->currency->priceDisplay($this->orderDetails['details']['BT']->order_billTaxAmount, $this->currency); ?></span></td>
		<?php } ?>
		<td style="<?php echo $style_td_border; ?>" align="right"><span class='priceColor2'><?php echo $this->currency->priceDisplay($this->orderDetails['details']['BT']->order_billDiscountAmount, $this->currency); ?></span></td>
		<td style="<?php echo $style_td_border; ?>" align="right"><strong><?php echo $this->currency->priceDisplay($this->orderDetails['details']['BT']->order_total, $this->currency); ?></strong></td>
	</tr>
        
	<?php if($taxBill)
	{ ?>
    	<tr>
			<td colspan="7"  align="right" style="<?php echo $style_td_border; ?>"><?php echo vmText::_('COM_VIRTUEMART_TOTAL_INCL_TAX') ?> </td>
			<td style="<?php echo $style_td_border; ?>"></td>
			<td style="<?php echo $style_td_border; ?>"></td>
		</tr>
	<?php
	} ?>
    
    <?php foreach($taxBill as $rule)
	{
		if ($rule->calc_kind == 'taxRulesBill' or $rule->calc_kind == 'VatTax' )
		{ ?>
			<tr>
				<td colspan="6" align="right" style="<?php echo $style_td_border; ?>"><?php echo $rule->label ?> </td>
				<?php if ( VmConfig::get('show_tax'))
				{  ?>
					<td align="right" style="<?php echo $style_td_border; ?>"><?php echo $this->currency->priceDisplay($rule->calc_result, $this->currency); ?></td>
				<?php
                } ?>
				<td align="right" style="<?php echo $style_td_border; ?>"></td>
				<td align="right" style="<?php echo $style_td_border; ?>"></td>
			</tr>
		<?php
		} ?>
	<?php
	} ?>

<?php 
} ?>
</table>
