<?php
/**
*
* Layout for the shopper mail, when he confirmed an ordner
*
* The addresses are reachable with $this->BTaddress['fields'], take a look for an exampel at shopper_adresses.php
*
* With $this->cartData->paymentName or shipmentName, you get the name of the used paymentmethod/shippmentmethod
*
* In the array order you have details and items ($this->orderDetails['details']), the items gather the products, but that is done directly from the cart data
*
* $this->orderDetails['details'] contains the raw address data (use the formatted ones, like BTaddress['fields']). Interesting informatin here is,
* order_number ($this->orderDetails['details']['BT']->order_number), order_pass, coupon_code, order_status, order_status_name,
* user_currency_rate, created_on, customer_note, ip_address
*
* @package	VirtueMart
* @subpackage Cart
* @author Max Milbers, Valerie Isaksen
*
* @link http://www.virtuemart.net
* @copyright Copyright (c) 2004 - 2010 VirtueMart Team. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
* VirtueMart is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
*
*/

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');

$link_order = JURI::root().'index.php?option=com_virtuemart&view=orders&layout=details&order_number='.$this->orderDetails['details']['BT']->order_number.'&order_pass='.$this->orderDetails['details']['BT']->order_pass;
$style_table_border = 'border-right:1px solid #ccc; border-bottom: 1px solid #ccc;';
$style_td_border = 'border-left:1px solid #ccc; border-top: 1px solid #ccc;';
?>
<table style="<?php echo $style_table_border; ?> margin-bottom:15px;" width="100%" border="0" cellpadding="10" cellspacing="0">
	<tr>
    	<td style="<?php echo $style_td_border; ?>" width="30%">
			<?php echo vmText::_('COM_VIRTUEMART_MAIL_SHOPPER_YOUR_ORDER'); ?>
            <strong><?php echo $this->orderDetails['details']['BT']->order_number ?></strong>
		</td>
    	<td style="<?php echo $style_td_border; ?>" width="30%">
			<?php echo vmText::_('COM_VIRTUEMART_MAIL_SHOPPER_YOUR_PASSWORD'); ?>
            <strong><?php echo $this->orderDetails['details']['BT']->order_pass ?></strong>
		</td>
    	<td style="<?php echo $style_td_border; ?>" width="40%">
    		<a class="default" title="<?php echo $this->vendor->vendor_store_name ?>" href="<?php echo $link_order; ?>"><?php echo vmText::_('COM_VIRTUEMART_MAIL_SHOPPER_YOUR_ORDER_LINK'); ?></a>
		</td>
	</tr>
  	
    <?php if( !in_array($this->orderDetails['details']['BT']->order_status, array('A')) )
	{?>
    
    <tr>
    	<td style="<?php echo $style_td_border; ?>" colspan="3">
			<?php echo vmText::sprintf('COM_VIRTUEMART_MAIL_SHOPPER_TOTAL_ORDER', $this->currency->priceDisplay($this->orderDetails['details']['BT']->order_total, $this->currency) ); ?>
        </td>
  	</tr>
    
    <?php
	}?>
	
    <tr>
		<td style="<?php echo $style_td_border; ?>" colspan="3">
			<?php echo vmText::sprintf('COM_VIRTUEMART_MAIL_ORDER_STATUS', vmText::_($this->orderDetails['details']['BT']->order_status_name)) ; ?>
        </td>
	</tr>
  
	<?php $nb = count($this->orderDetails['history']); ?>
  	<?php if($this->orderDetails['history'][$nb-1]->customer_notified && !(empty($this->orderDetails['history'][$nb-1]->comments))) 
	{ ?>
  		<tr>
    		<td style="<?php echo $style_td_border; ?>" colspan="3">
				<?php echo  nl2br($this->orderDetails['history'][$nb-1]->comments); ?>
			</td>
  		</tr>
	<?php 
  	} ?>
	
	<?php if(!empty($this->orderDetails['details']['BT']->customer_note))
	{ ?>
		<tr>
    		<td style="<?php echo $style_td_border; ?>" colspan="3">
				<?php echo vmText::sprintf('COM_VIRTUEMART_MAIL_SHOPPER_QUESTION', nl2br($this->orderDetails['details']['BT']->customer_note)) ?>
			</td>
		</tr>
	<?php 
	} ?>
    
</table>