<?php

/**

 *

 * Show the product details page

 *

 * @package	VirtueMart

 * @subpackage

 * @author Max Milbers, Eugen Stranz, Max Galt

 * @link http://www.virtuemart.net

 * @copyright Copyright (c) 2004 - 2014 VirtueMart Team. All rights reserved.

 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php

 * VirtueMart is free software. This version may have been modified pursuant

 * to the GNU General Public License, and as distributed it includes or

 * is derivative of works licensed under the GNU General Public License or

 * other free or open source software licenses.

 * @version $Id: default.php 8610 2014-12-02 18:53:19Z Milbo $

 */

// Check to ensure this file is included in Joomla!

defined('_JEXEC') or die('Restricted access');



vmJsApi::removeJScript('jquery-ui.min');

vmJsApi::removeJScript('jquery.ui.autocomplete.html');

vmJsApi::removeJScript('jquery.noconflict');

vmJsApi::removeJScript('fancybox/jquery.fancybox-1.3.4.pack');

$og_tags = array();

?>



<?php /* Let's see if we found the product */

if (empty($this->product)) 

{ ?>

	<?php echo vmText::_('COM_VIRTUEMART_PRODUCT_NOT_FOUND'); ?>

	<br /><br />

	<?php echo $this->continue_link_html; ?>

	<?php return; ?>

<?php

} ?>



<?php

//echo shopFunctionsF::renderVmSubLayout('askrecomjs', array('product' => $this->product));



if(vRequest::getInt('print', false))

{ ?>

	<body onLoad="javascript:print();">

<?php 

} ?>



<div class="productdetails-view productdetails" data-uk-observe>



    <?php // Product Navigation

    if (VmConfig::get('product_navigation', 1)) 

	{ ?>

        <div class="uk-margin vm-product-navigation">

	    	<?php if (!empty($this->product->neighbours ['previous'][0])) 

			{

				$prev_link = JRoute::_('index.php?option=com_virtuemart&view=productdetails&virtuemart_product_id=' . $this->product->neighbours ['previous'][0] ['virtuemart_product_id'] . '&virtuemart_category_id=' . $this->product->virtuemart_category_id, FALSE);

				$prev_name = '<i class="uk-icon-arrow-left"></i> '.$this->product->neighbours ['previous'][0]['product_name'];

				?>

                <?php echo JHTML::_('link', $prev_link, $prev_name, array('rel' => 'prev', 'class' => 'previous-page', 'tm-dynamic-update' => '1')); ?>

	    	<?php

            }?>

	    

        	<?php if (!empty($this->product->neighbours ['next'][0])) 

			{

				$next_link = JRoute::_('index.php?option=com_virtuemart&view=productdetails&virtuemart_product_id=' . $this->product->neighbours ['next'][0] ['virtuemart_product_id'] . '&virtuemart_category_id=' . $this->product->virtuemart_category_id, FALSE);

				$next_name = $this->product->neighbours ['next'][0] ['product_name']. ' <i class="uk-icon-arrow-right"></i>';

				?>

                <?php echo JHTML::_('link', $next_link, $next_name, array('rel' => 'next', 'class' => 'next-page uk-float-right', 'tm-dynamic-update' => '1')); ?>

	    	<?php

            } ?>

    		<div class="uk-clearfix"></div>

        </div>

    <?php

    } // Product Navigation END ?>



	<div class="uk-grid uk-grid-match uk-grid-divider" data-uk-grid-margin="">

    	

        <div class="uk-width-medium-1-2">

        	<div class="uk-panel">

            	<?php echo shopFunctionsF::renderVmSubLayout('badges', array('product' => $this->product, 'show_badge_sold' => false, 'show_badge_new' => false, 'show_badge_promo' => false, 'show_badge_sale' => false)); ?>

				<?php echo $this->loadTemplate('images');?>

                <?php if (!empty($this->product->images)) 

				{

					jimport('siniestro.image_lib.image');

					

					$image = $this->product->images[0];

					// add og image metatag

					if($image->file_extension) $og_tags['image'] = SiniestroImage::createThumb( $image->file_url, 'cache/images', 600, 315, 'crop-m');// 1200 x 630

                }?>



				<?php // Product Description

				if (!empty($this->product->product_desc)) 

				{ ?>

	                <div class="uk-panel vm-description-full">



	                    <h3 class="uk-panel-title mod-panel-title uk-hidden-small"><span><?php echo vmText::_('COM_VIRTUEMART_PRODUCT_DESC_TITLE') ?></span></h3>

	                    <button class="uk-button uk-visible-small uk-width-1-1" data-uk-toggle="{cls: 'uk-hidden-small', target:'#vm-description-full', animation:'uk-animation-fade'}"><?php echo vmText::_('COM_VIRTUEMART_PRODUCT_DESC_TITLE') ?> <i class="uk-icon-caret-down"></i></button>



	                    <div id="vm-description-full" class="uk-hidden-small">
							<?php echo $this->product->product_desc; ?>
						</div>

						<?php if (!empty($this->product->customfieldsSorted['normal'])) 

						{ ?>

							<div>

								<div class="uk-panel">

									<?php echo shopFunctionsF::renderVmSubLayout('customfields', array('product' => $this->product, 'position' => 'normal', 'class' => 'uk-margin-small', 'inline' => 1)); ?>

								</div>

							</div>

						<?php

						} ?>


	                </div>



				<?php 

				} // Product Description END ?>



            </div>

        </div>

        

        <div class="uk-width-medium-1-2">

        	<div class="uk-panel">

                <div class="spacer-buy-area" data-tm-sticky="{boundary:true}">

                

					<h1 class="uk-article-title" itemprop="name"><span><?php echo $this->edit_link; ?><?php echo $this->product->product_name ?></span></h1>

					<?php 

					// add og title metatag

					$og_tags['title'] = $this->product->product_name;

					

					// afterDisplayTitle Event

    				echo $this->product->event->afterDisplayTitle ?>

					                                

					<div class="uk-margin">

						<?php echo shopFunctionsF::renderVmSubLayout('rating', array('show_rating' => false, 'product' => $this->product)); ?>

                        <?php echo shopFunctionsF::renderVmSubLayout('stock', array('show_stock' => false, 'product' => $this->product)); ?>

                        <?php echo shopFunctionsF::renderVmSubLayout('stockhandle', array('product' => $this->product)); ?>

                    </div>

                                        

                    <?php // Product Short Description

					if (!empty($this->product->product_s_desc)) 

					{

						// add og description metatag

						$og_tags['description'] = JHtml::_('string.truncate', $this->product->product_s_desc, 350, true, false);

						?>

						<p class="vm-description-short"><?php echo nl2br($this->product->product_s_desc);?></p>

                        <hr />

					<?php 

					} // Product Short Description END ?>

                    

                    <?php // Product Sku

					if ($this->product->product_sku) 

					{ ?>

						<div class="uk-margin-small vm-product-sku">

                            <div class="product-fields-title-wrapper uk-display-inline-block">

                                <span class="product-fields-title uk-text-bold"><?php echo vmText::_('COM_VIRTUEMART_PRODUCT_SKU') ?>: </span>

                            </div>

                            <div class="product-field-display uk-display-inline-block"><?php echo $this->product->product_sku;?></div>

						</div>

					<?php 

					} // Product Sku END ?>

                    

                    <?php // Manufacturer of the Product

                    if (VmConfig::get('show_manufacturers', 1) && !empty($this->product->virtuemart_manufacturer_id)) 

                    { ?>

                        <?php echo $this->loadTemplate('manufacturer'); ?>

                    <?php

                    } ?>

                    

                    <?php // Product LWH UOM

					if ($this->product->product_length > 0 && $this->product->product_width > 0 && $this->product->product_height > 0) 

					{

						$lwh = implode(' x ', array(number_format($this->product->product_length, 3, ',', '.'), number_format($this->product->product_width, 3, ',', '.'), number_format($this->product->product_height, 3, ',', '.') ));

						?>

						<div class="uk-margin-small">

							<div class="product-fields-title-wrapper uk-display-inline-block">

                                <span class="product-fields-title uk-text-bold"><?php echo vmText::_('COM_VIRTUEMART_PRODUCT_LWH_UOM'); ?>: </span>

                            </div>

                            <div class="product-field-display uk-display-inline-block"><?php echo $lwh . ' ' . $this->product->product_lwh_uom;?></div>

						</div>

					<?php 

					} // Product LWH UOM END ?>

                    

                    <?php // Product Packaging

					if ($this->product->product_box)

					{ ?>

                    	<div class="uk-margin-small">

                            <div class="product-fields-title-wrapper uk-display-inline-block">

                                <span class="product-fields-title uk-text-bold"><?php echo vmText::_('COM_VIRTUEMART_PRODUCT_UNITS_IN_BOX'); ?></span>

                            </div>

                            <div class="product-field-display uk-display-inline-block"><?php echo $this->product->product_box;?></div>

                        </div>

					<?php

					} // Product Packaging END ?>



					<?php echo shopFunctionsF::renderVmSubLayout('customfields',array('product' => $this->product, 'position' => 'ontop', 'class' => 'uk-margin-small', 'inline' => 1)); ?>

            

                    

					<?php

					$productDisplayTypes = array('productDisplayShipments', 'productDisplayPayments');



					foreach ($productDisplayTypes as $productDisplayType)

					{

						if(empty($this->$productDisplayType))

						{

							continue;

						}

						else if (!is_array($this->$productDisplayType))

						{

							$this->$productDisplayType = array($this->$productDisplayType);

						}



						foreach ($this->$productDisplayType as $productDisplay)

						{

							if(empty($productDisplay))

							{

								continue;

							}							

							else if (!is_array($productDisplay))

							{

								$productDisplay = array($productDisplay);

							}



							foreach ($productDisplay as $virtuemart_method_id =>$productDisplayHtml)

							{ ?>

								<div class="<?php echo substr($productDisplayType, 0, -1) ?> <?php echo substr($productDisplayType, 0, -1).'-'.$virtuemart_method_id ?>">

									<?php echo $productDisplayHtml; ?>

								</div>

							<?php

							} ?>

					

						<?php

						} ?>

					

					<?php

					} ?>



                    <div class="uk-margin"><?php echo shopFunctionsF::renderVmSubLayout('prices', array('product' => $this->product, 'currency' => $this->currency, 'show_offer' => true)); ?></div>

                    <div class="uk-margin"><?php echo shopFunctionsF::renderVmSubLayout('addtocart', array('product' => $this->product)); ?></div>

                    <div class="uk-margin"><?php //require( $warp['path']->path('layouts:com_wishlist/addtofavorites.php') ); ?></div>

                                        

                    

            

                    <?php // Ask a question about this product

                    if (VmConfig::get('ask_question', 0) == 1) 

                    {

                        $askquestion_url = JRoute::_('index.php?option=com_virtuemart&view=productdetails&task=askquestion&virtuemart_product_id=' . $this->product->virtuemart_product_id . '&virtuemart_category_id=' . $this->product->virtuemart_category_id . '&tmpl=component', FALSE);

                        ?>

                        <div>

                            <a class="vm-button-askquestion" href="<?php echo $askquestion_url ?>" data-uk-lightbox data-lightbox-type="iframe" rel="nofollow"><i class="uk-icon-question-circle"></i> <?php echo vmText::_('COM_VIRTUEMART_PRODUCT_ENQUIRY_LBL') ?></a>

                        </div>



                        <hr>

                    <?php

                    } ?>



                    <?php if( $warp['widgets']->count('vm-productdetails') && $vm_productdetails_content = $warp['widgets']->render('vm-productdetails')  ) 

					{ ?>

				        <div class="vm-productdetails-position">

				            <?php echo  $vm_productdetails_content; ?>

				        </div>



				        <hr />



				    <?php



					}?>

                    

                    <?php // Back To Category Button

					if ($this->product->virtuemart_category_id) 

					{

						$catURL =  JRoute::_('index.php?option=com_virtuemart&view=category&virtuemart_category_id='.$this->product->virtuemart_category_id, FALSE);

						$categoryName = vmText::_($this->product->category_name);

					} else {

						$catURL =  JRoute::_('index.php?option=com_virtuemart');

						$categoryName = vmText::_('COM_VIRTUEMART_SHOP_HOME') ;

					}

					?>

					

                    <div class="uk-margin uk-clearfix">

						<?php if($social_code = $warp['config']->get('social_code'))

						{ ?>

                        	<div class="tm-addthis uk-text-right uk-float-right"><?php echo $social_code; ?></div>

                        <?php

						}?>



						<a class="vm-button-category-backto uk-float-left" href="<?php echo $catURL ?>" title="<?php echo $categoryName ?>"><i class="uk-icon-caret-left"></i> <?php echo vmText::sprintf('COM_VIRTUEMART_CATEGORY_BACK_TO', $categoryName) ?></a>

					</div>

                    

                    <?php // PDF - Print - Email Icon

					if (VmConfig::get('show_emailfriend') || VmConfig::get('show_printicon') || VmConfig::get('pdf_icon') ) 

					{

						$link = 'index.php?tmpl=component&option=com_virtuemart&view=productdetails&virtuemart_product_id=' . $this->product->virtuemart_product_id;

						$MailLink = 'index.php?option=com_virtuemart&view=productdetails&task=recommend&virtuemart_product_id=' . $this->product->virtuemart_product_id . '&virtuemart_category_id=' . $this->product->virtuemart_category_id . '&tmpl=component';

						?>

                        

                        <hr />

                                                						

                        <?php if(VmConfig::get('pdf_icon') || VmConfig::get('show_printicon') || VmConfig::get('show_emailfriend') )

						{?>

                            <hr />

                            <div class="uk-margin uk-text-right">

                                <?php if(VmConfig::get('pdf_icon'))

                                {?>

                                    <a href="<?php echo $link . '&format=pdf'; ?>" data-uk-tooltip="" data-uk-lightbox data-lightbox-type="iframe" title="<?php echo JText::_('COM_VIRTUEMART_PDF');?>" ><i class="uk-icon-file-pdf-o"></i></a>

                                <?php 

                                }?>

                                

                                <?php if(VmConfig::get('show_printicon'))

                                {?>

                                    <a href="<?php echo $link . '&print=1'; ?>" data-uk-tooltip="" data-uk-lightbox data-lightbox-type="iframe" title="<?php echo JText::_('COM_VIRTUEMART_PRINT');?>" ><i class="uk-icon-print"></i></a>

                                <?php 

                                }?>

                                

                                <?php if(VmConfig::get('show_emailfriend'))

                                {?>

                                    <a href="<?php echo $MailLink; ?>" data-uk-tooltip="" data-uk-lightbox data-lightbox-type="iframe" title="<?php echo JText::_('COM_VIRTUEMART_EMAIL');?>" ><i class="uk-icon-envelope-o"></i></a>

                                <?php 

                                }?>

                            </div>

                        <?php 

						}?>

					<?php

                    } // PDF - Print - Email Icon END	?>

        

                </div>

            </div>

        </div>

    

    </div>

    

    <div class="uk-grid uk-grid-width-1-1" data-uk-grid-margin="">

	    <?php // event onContentBeforeDisplay

		echo $this->product->event->beforeDisplayContent; ?>

                        
       

        <?php if (!empty($this->product->customfieldsSorted['onbot'])) 

        { ?>

			<div>

				<div class="uk-panel">

					<?php echo shopFunctionsF::renderVmSubLayout('customfields', array('product' => $this->product, 'position' => 'onbot')); ?>

            	</div>

            </div>

        <?php

        } ?>

        

		<?php // onContentAfterDisplay event

		echo $this->product->event->afterDisplayContent; ?>

	

    	<?php echo $this->loadTemplate('relatedproducts'); ?>

        <?php //echo $this->loadTemplate('relatedcategories'); ?>

		<?php //echo $this->loadTemplate('reviews'); ?>

		<?php //echo $this->loadTemplate('showcategory'); ?>

    

    </div>



	<?php

	

	if(JFactory::getApplication()->input->get('format') == 'html') $warp['siniestro']->addOGTags($og_tags); 

    /* remove

	$j = 'jQuery(document).ready(function($) {

		Virtuemart.product(jQuery("form.product"));

	

		$("form.js-recalculate").each(function(){

			if ($(this).find(".product-fields").length && !$(this).find(".no-vm-bind").length) {

				var id= $(this).find(\'input[name="virtuemart_product_id[]"]\').val();

				Virtuemart.setproducttype($(this),id);

	

			}

		});

	});';

	

	vmJsApi::addJScript('recalcReady',$j);

	*/

	

	/** GALT

	 * Notice for Template Developers!

	 * Templates must set a Virtuemart.container variable as it takes part in

	 * dynamic content update.

	 * This variable points to a topmost element that holds other content.

	 */

	

	$j = "Virtuemart.container = jQuery('.productdetails-view');

	Virtuemart.containerSelector = '.productdetails-view';";

	

	vmJsApi::addJScript('ajaxContent', $j);

	

	if(VmConfig::get ('jdynupdate', TRUE))

	{

		$j = "jQuery(document).ready(function($)

		{

			Virtuemart.stopVmLoading();

			var msg = '';

			jQuery('a[data-dynamic-update=\"1\"]').off('click', Virtuemart.startVmLoading).on('click', {msg:msg}, Virtuemart.startVmLoading);

			jQuery('[data-dynamic-update=\"1\"]').off('change', Virtuemart.startVmLoading).on('change', {msg:msg}, Virtuemart.startVmLoading);

		});";

	

		vmJsApi::addJScript('vmPreloader', $j);

	}

	

	echo vmJsApi::writeJS();

	

	if ($this->product->prices['salesPrice'] > 0)

	{

  		echo shopFunctionsF::renderVmSubLayout('snippets', array('product' => $this->product, 'currency' => $this->currency, 'showRating' => $this->showRating));

	}

	?>

</div>

