<?php
/**
 *
 * Show the product details page
 *
 * @package	VirtueMart
 * @subpackage
 * @author Max Milbers, Valerie Isaksen

 * @link http://www.virtuemart.net
 * @copyright Copyright (c) 2004 - 2010 VirtueMart Team. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 * VirtueMart is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * @version $Id: default_images.php 8508 2014-10-22 18:57:14Z Milbo $
 */
// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');

?>

<?php if (!empty($this->product->images)) 
{
	$image = $this->product->images[0];
	$image_main_cloudzoom = array();
	$image_main_cloudzoom[] = "zoomImage: '".JURI::root().$image->file_url."'";
	//$image_main_cloudzoom[] = "tintColor: '#000'";
	//$image_main_cloudzoom[] = "tintOpacity: '0.25'";
	$image_main_cloudzoom[] = "zoomPosition: '.spacer-buy-area'"; // 3
	$image_main_cloudzoom[] = "zoomOffsetX: 15";
	$image_main_cloudzoom[] = "zoomOffsetY: 0";
	$image_main_cloudzoom[] = "zoomFlyOut: true";
	$image_main_cloudzoom[] = "zoomSizeMode: 'image'"; // lens, zoom, full, image
	$image_main_cloudzoom[] = "variableMagnification: true";
	$image_main_cloudzoom[] = "startMagnification: 3"; // auto
	$image_main_cloudzoom[] = "minMagnification: 1.5"; // auto
	$image_main_cloudzoom[] = "maxMagnification: 5"; // auto
	$image_main_cloudzoom[] = "disableZoom: 'auto'"; // false
	//$image_main_cloudzoom[] = "zoomWidth: 250";
	//$image_main_cloudzoom[] = "zoomHeight: 250";
	//$image_main_cloudzoom[] = "lensWidth: 250";
	//$image_main_cloudzoom[] = "lensWidth: 250";
	$image_main_cloudzoom[] = "touchStartDelay: 100";
	$image_main_cloudzoom[] = "autoInside: 640";
	$image_main_cloudzoom[] = "lazyLoadZoom: true";

	$width = VmConfig::get('img_width_full', 0);
	$height = VmConfig::get('img_height_full', 0);
	?>
    <div>
        <div class="uk-thumbnail uk-thumbnail-expand vm-thumbnail-main uk-text-center">
            <span class="uk-width-1-1 uk-height-1-1 uk-display-block uk-vertical-align">

				<?php if(!empty($width) or !empty($height))
				{ ?>
	                <?php echo $image->displayMediaThumb ('class="cloudzoom uk-responsive-height" data-cloudzoom="'.implode(', ', $image_main_cloudzoom).'"', true, true, false, $width, $height); ?>
				<?php
				}else
				{ ?>
					<?php echo $image->displayMediaThumb ('class="cloudzoom uk-responsive-height" data-cloudzoom="'.implode(', ', $image_main_cloudzoom).'"', FALSE); ?>
				<?php
				}?>
            </span>
        </div>
        <?php if( $image->file_extension )
        {
			// add cloudzoom
			$warp['asset']->addFile('css', 'js:cloud-zoom/cloudzoom.css');
			$warp['asset']->addFile('js', 'js:cloud-zoom/cloudzoom.js');
			vmJsApi::addJScript('vm.cloudzoom', "CloudZoom.quickStart();");
		} ?>
    </div>
    
    <?php
	$count_images = count ($this->product->images);
	if ($count_images > 1) 
	{
		$start_image = VmConfig::get('add_img_main', 1) ? 0 : 0;
		?>
		<div class="uk-grid uk-grid-small uk-grid-width-large-1-5 uk-grid-width-medium-1-4 uk-grid-width-small-1-4 uk-grid-width-1-4 uk-margin" data-uk-grid-margin>
			<?php for ($i = $start_image; $i < $count_images; $i++) 
			{
				$image = $this->product->images[$i];
				$image_thumb_cloudzoom = array();
				$image_thumb_cloudzoom[] = "useZoom: '.cloudzoom'";
				$image_thumb_cloudzoom[] = "image: '".JURI::root().$image->file_url."'";
				$image_thumb_cloudzoom[] = "zoomImage: '".JURI::root().$image->file_url."'";

				if(VmConfig::get('add_thumb_use_descr', false)) {
					$image->file_meta = $image->file_description;
				}
				?>
                <div>
                    <div class="uk-thumbnail uk-thumbnail-expand vm-thumbnail-mini uk-text-center cloudzoom-gallery" data-cloudzoom="<?php echo implode(", ", $image_thumb_cloudzoom); ?>">
                        <span class="uk-width-1-1 uk-height-1-1 uk-display-block uk-vertical-align">
                            <?php echo $image->displayMediaThumb ('class="uk-responsive-height"', FALSE); ?>
                        </span>
                    </div>
                </div>
			<?php
			} ?>
		</div>
        
	<?php
	} ?>

<?php
} ?>