<?php
/**
 *
 * Show the product details page
 *
 * @package    VirtueMart
 * @subpackage
 * @author Max Milbers, Valerie Isaksen
 * @link http://www.virtuemart.net
 * @copyright Copyright (c) 2004 - 2010 VirtueMart Team. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 * VirtueMart is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * @version $Id: default_reviews.php 8508 2014-10-22 18:57:14Z Milbo $
 */

// Check to ensure this file is included in Joomla!
defined ('_JEXEC') or die ('Restricted access');

// Customer Reviews
$review_editable = true;
$user_review_published = true;
?>

<?php if ($this->allowRating || $this->allowReview || $this->showRating || $this->showReview)
{
	$maxrating = VmConfig::get( 'vm_maximum_rating_scale', 5 );
	$ratingsShow = VmConfig::get( 'vm_num_ratings_show', 3 ); // TODO add  vm_num_ratings_show in vmConfig
	//$stars = array();
	$showall = vRequest::getBool( 'showall', TRUE );
	$ratingWidth = $maxrating * 24;
	$rating_width = ($maxrating * 100) / $maxrating;

	/*
	for( $num = 0; $num <= $maxrating; $num++ )
	{
		$stars[] = '
		<span title="'.(vmText::_( "COM_VIRTUEMART_RATING_TITLE" ).$num.'/'.$maxrating).'" class="vmicon ratingbox" style="display:inline-block;width:'. 24*$maxrating.'px;">
			<span class="stars-orange" style="width:'.(24*$num).'px"></span>
		</span>';
	}
	*/
	?>

	<div class="customer-reviews uk-margin-large-top">
	
	<?php if ($this->rating_reviews)
	{
		foreach( $this->rating_reviews as $review_key => $review )
		{
			/* Check if user already commented */
			if ($review->created_by == $this->user->id && !$review->review_editable)
			{
				$review_editable = false;
			}

			if ($review->created_by == $this->user->id && !$review->published)
			{
				$user_review_published = false;
			}

			if(!$review->published)
			{
				unset($this->rating_reviews[$review_key]);
			}
		}
	}
} ?>

<?php if ($this->allowRating or $this->allowReview)
{
	if ($review_editable)
	{
		$form_action = JRoute::_( 'index.php?option=com_virtuemart&view=productdetails&virtuemart_product_id='.$this->product->virtuemart_product_id.'&virtuemart_category_id='.$this->product->virtuemart_category_id, FALSE );
		?>

		<form class="uk-form" method="post" action="<?php echo $form_action; ?>" name="reviewForm" id="reviewform">

			<?php if($this->allowRating and $review_editable)
			{ ?>
				<h3><?php echo vmText::_( 'COM_VIRTUEMART_WRITE_REVIEW' ); ?></h3>
				
				<?php if(count( $this->rating_reviews ) == 0)
				{ ?>
					<h4><?php echo vmText::_( 'COM_VIRTUEMART_WRITE_FIRST_REVIEW' ) ?></h4>
				<?php
				} ?>

				<p class="step"><?php echo vmText::_( 'COM_VIRTUEMART_RATING_FIRST_RATE' ) ?></p>
				
				<div class="rating uk-margin">
					<label for="vote">
						<?php //echo $stars[$maxrating]; ?>
						<div class="uk-text-left vm-rating vm-rating-category">
				            <span class="uk-position-relative ratingbox uk-display-inline-block">
				            	<span class="uk-text-muted">
				            		<?php for($i = 0; $i < $maxrating; $i++)
				            		{ ?>
				            			<i class="uk-icon-star-o tm-cursor-pointer"></i>
				            		<?php 
				            		} ?>
				            	</span>
				            	<span style="width: <?php echo $rating_width;?>%; overflow:hidden;" class="uk-text-nowrap uk-position-absolute uk-position-top-left uk-text-warning vm-rating-selected">
					            	<?php for($i = 0; $i < $maxrating; $i++)
					            	{ ?>
					            		<i class="uk-icon-star tm-cursor-pointer"></i>
					            	<?php 
					            	} ?>
					            </span>
				            </span>
				            <span class="uk-text-muted uk-hidden"><?php echo $review->review_rating;?></span>
				        </div>
					</label>
					<input type="hidden" id="vote" value="<?php echo $maxrating ?>" name="vote">
				</div>

				<?php
				$reviewJavascript = "
					jQuery(function($)
					{
						var steps = ".$maxrating.";
						var parentPos= $('.rating .ratingbox').position();
						var boxWidth = $('.rating .ratingbox').width();// nbr of total pixels
						var starSize = (boxWidth / steps);
						var ratingboxPos = $('.rating .ratingbox').offset();

						jQuery('.rating .ratingbox').click( function(e)
						{
							var span = jQuery(this).find('.vm-rating-selected');
							var dif = e.pageX - ratingboxPos.left; // nbr of pixels
							difRatio = Math.floor(dif / boxWidth * steps ) +1; //step
							
							span.width(difRatio * starSize);
							$('#vote').val(difRatio);

							//console.log('note = ',parentPos, boxWidth, ratingboxPos);
						});
					});";
				vmJsApi::addJScript( 'rating_stars', $reviewJavascript );
				?>
			<?php
			} ?>

			<?php // Writing A Review
			if ($this->allowReview and $review_editable)
			{ ?>
				<div class="write-reviews">

				<?php // Show Review Length While Your Are Writing
				$reviewJavascript = "
					function check_reviewform() {
						var form = document.getElementById('reviewform');
						var ausgewaehlt = false;

						if (form.comment.value.length < ".VmConfig::get( 'reviews_minimum_comment_length', 100 ).")
						{
							alert('".addslashes( vmText::sprintf( 'COM_VIRTUEMART_REVIEW_ERR_COMMENT1_JS', VmConfig::get( 'reviews_minimum_comment_length', 100 ) ) )."');
							return false;
						}
						else if (form.comment.value.length > ".VmConfig::get( 'reviews_maximum_comment_length', 2000 ).")
						{
							alert('".addslashes( vmText::sprintf( 'COM_VIRTUEMART_REVIEW_ERR_COMMENT2_JS', VmConfig::get( 'reviews_maximum_comment_length', 2000 ) ) )."');
							return false;
						}
						else
						{
							return true;
						}
					}

					function refresh_counter()
					{
						var form = document.getElementById('reviewform');
						form.counter.value= form.comment.value.length;
					}";

				vmJsApi::addJScript( 'check_reviewform', $reviewJavascript );
				?>
				
				<span class="step">
					<?php echo vmText::sprintf( 'COM_VIRTUEMART_REVIEW_COMMENT', VmConfig::get( 'reviews_minimum_comment_length', 100 ), VmConfig::get( 'reviews_maximum_comment_length', 2000 ) ); ?>
				</span>

				<br/>
				
				<textarea title="<?php echo vmText::_( 'COM_VIRTUEMART_WRITE_REVIEW' ) ?>" 
				class="inputbox virtuemart uk-width-1-1" id="comment" onblur="refresh_counter();" onfocus="refresh_counter();" onkeyup="refresh_counter();" 
				name="comment" rows="10" cols="60"><?php if(!empty($this->review->comment)){echo $this->review->comment;} ?></textarea>
				<div class="uk-margin-small uk-text-right">
					<span>
						<?php echo vmText::_( 'COM_VIRTUEMART_REVIEW_COUNT' ) ?>
						<input type="text" class="uk-text-center" value="0" size="4" name="counter" maxlength="4" readonly="readonly"/>
					</span>
				</div>
			<?php
			} ?>

			<div class="uk-margin uk-text-right">
						
				<?php if($review_editable and $this->allowReview)
				{ ?>
					<button class="highlight-button uk-button uk-button-primary" type="submit" onclick="return( check_reviewform());" name="submit_review" title="<?php echo vmText::_( 'COM_VIRTUEMART_REVIEW_SUBMIT' ) ?>">
						<?php echo vmText::_( 'COM_VIRTUEMART_REVIEW_SUBMIT' ) ?>
					</button>
				<?php
				}
				else if($review_editable and $this->allowRating)
				{ ?>
					<button class="highlight-button uk-button uk-button-primary" type="submit" name="submit_review" title="<?php echo vmText::_( 'COM_VIRTUEMART_REVIEW_SUBMIT' ) ?>" >
						<?php echo vmText::_( 'COM_VIRTUEMART_REVIEW_SUBMIT' ) ?>
					</button>
				<?php
				} ?>
			
			</div>
			
			<input type="hidden" name="virtuemart_product_id" value="<?php echo $this->product->virtuemart_product_id; ?>"/>
			<input type="hidden" name="option" value="com_virtuemart"/>
			<input type="hidden" name="virtuemart_category_id" value="<?php echo vRequest::getInt( 'virtuemart_category_id' ); ?>"/>
			<input type="hidden" name="virtuemart_rating_review_id" value="0"/>
			<input type="hidden" name="task" value="review"/>
		</form>
	<?php
	}
	else if(!$review_editable)
	{ ?>
		<?php if($user_review_published)
		{ ?>
			<p><strong class=""><?php echo $this->user->name; //echo vmText::_( 'COM_VIRTUEMART_DEAR' ).$this->user->name;?>, </strong><?php echo vmText::_( 'COM_VIRTUEMART_REVIEW_ALREADYDONE' ); ?></p>
		<?php
		} else 
		{ ?>
			<p><strong class=""><?php echo $this->user->name; ?>,</strong> Tu comentario está en espera de aprobación.</p>
		<?php
		} ?>


	<?php
	} ?>
<?php
} ?>

<?php if ($this->showReview)
{ ?>
	<h3><?php echo vmText::_ ('COM_VIRTUEMART_REVIEWS') ?></h3>
	
	<ul class="vm-list-reviews uk-comment-list">
		<?php
		$i = 0;
		$reviews_published = 0;

		if (!empty($this->rating_reviews))
		{
			foreach ($this->rating_reviews as $review)
			{
				$color = ($i % 2 == 0) ? 'normal' : 'highlight';
				?>

				<?php // Loop through all reviews
				if ($review->published)
				{
					$reviews_published++;
					$rating_width = ($review->review_rating * 100) / $maxrating;
					?>
					<li>
						<article class="uk-comment">
							<header class="uk-comment-header">
								<h4 class="uk-comment-title uk-text-bold"><?php echo $review->customer ?></h4>
								<div class="uk-comment-meta"><?php echo JHtml::date ($review->created_on, vmText::_ ('DATE_FORMAT_LC')); ?></div>
								<div class="vote">
									<?php //echo $stars[(int)$review->review_rating] ?>
									<div class="uk-text-left vm-rating vm-rating-category">
							            <span class="uk-position-relative uk-display-inline-block">
							            	<span class="uk-text-muted">
							            		<?php for($i = 0; $i < $maxrating; $i++)
							            		{ ?>
							            			<i class="uk-icon-star-o"></i>
							            		<?php 
							            		} ?>
							            	</span>
							            	<span style="width: <?php echo $rating_width;?>%; overflow:hidden;" class="uk-text-nowrap uk-position-absolute uk-position-top-left uk-text-warning">
								            	<?php for($i = 0; $i < $maxrating; $i++)
								            	{ ?>
								            		<i class="uk-icon-star"></i>
								            	<?php 
								            	} ?>
								            </span>
							            </span>
							            <span class="uk-text-muted uk-hidden"><?php echo $review->review_rating;?></span>
							        </div>
								</div>
							</header>
							<div class="uk-comment-body">
								<blockquote><?php echo $review->comment; ?></blockquote>
							</div>
						</article>
					</li>
				<?php
				} ?>

				<?php $i++;
				if ($i == $ratingsShow && !$showall)
				{
					/* Show all reviews ? */
					if ($reviews_published >= $ratingsShow)
					{
						$attribute = array('class'=> 'details', 'title'=> vmText::_ ('COM_VIRTUEMART_MORE_REVIEWS'));
						?>
						<?php echo JHtml::link ($this->more_reviews, vmText::_ ('COM_VIRTUEMART_MORE_REVIEWS'), $attribute); ?>
					<?php
					} break; ?>
				<?php
				} ?>
			<?php
			} ?>

		<?php
		}
		else
		{
			// "There are no reviews for this product"
			?>
			<span class="step"><?php echo vmText::_ ('COM_VIRTUEMART_NO_REVIEWS') ?></span>
		<?php
		} ?>
	</ul>
<?php
} ?>

<?php if ($this->allowRating || $this->allowReview || $this->showRating || $this->showReview)
{ ?>
	</div>
<?php
} ?>
