<?php
/**
 *TODO Improve the CSS , ADD CATCHA ?
 * Show the form Ask a Question
 *
 * @package	VirtueMart
 * @subpackage
 * @author Kohl Patrick, Maik K�nnemann
 * @link http://www.virtuemart.net
 * @copyright Copyright (c) 2004 - 2014 VirtueMart Team. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 * VirtueMart is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
* @version $Id: default.php 2810 2011-03-02 19:08:24Z Milbo $
 */

// Check to ensure this file is included in Joomla!
defined ( '_JEXEC' ) or die ( 'Restricted access' );

$min = VmConfig::get('asks_minimum_comment_length', 50);
$max = VmConfig::get('asks_maximum_comment_length', 2000);

//vmJsApi::JvalideForm();
vmJsApi::addJScript('askform','
	jQuery(function($){
		//$("#askform").validationEngine("attach");
		$("#comment").keyup( function () {
			var result = $(this).val();
			$("#counter").val( result.length );
		});
	});
'); 

$vendorModel = VmModel::getModel ('vendor');
$this->vendor = $vendorModel->getVendor ($this->product->virtuemart_vendor_id);
$ask_comment = "";
?>

<?php /* Let's see if we found the product */
if (empty ( $this->product )) 
{ ?>
	<?php echo vmText::_ ( 'COM_VIRTUEMART_PRODUCT_NOT_FOUND' ); ?>
    <br /><br />
	<?php echo $this->continue_link_html; ?>
<?php
} else 
{
	$session = JFactory::getSession();
	$sessData = $session->get('mailrecommend', 0, 'vm');
	?>
	
	<?php if(!empty($this->login))
	{ ?>
		<?php echo $this->login; ?>
	<?php 
	} ?>
	
    <?php if(empty($this->login) or VmConfig::get('recommend_unauth', false))
	{
		$action = JRoute::_('index.php?option=com_virtuemart&view=productdetails&virtuemart_product_id='.$this->product->virtuemart_product_id.'&virtuemart_category_id='.$this->product->virtuemart_category_id.'&tmpl=component', FALSE);
		$name_value = $this->user->name ? $this->user->name : $askQuestionData['name'];
		$email_value = $this->user->email ? $this->user->email : $sessData['email'];
		?>

		<div class="ask-a-question-view">
            <h1 class="uk-article-title uk-hidden"><span><?php echo JText::_('COM_VIRTUEMART_PRODUCT_RECOMMEND')  ?></span></h1>
            
            <article class="uk-article uk-hidden">
                <div class="uk-align-right uk-width-small-1-4 uk-text-center" style="height:150px;">
					<?php // Product Image
    	            echo $this->product->images[0]->displayMediaThumb('class="uk-responsive-height"', false); ?>
                </div>
                <div class="uk-clearfix">
					<h3 class="uk-h4"><?php echo $this->product->product_name ?></h3>
                    <?php // Product Short Description
	                if (!empty($this->product->product_s_desc)) 
    	            { ?>
                    	<div class="uk-article-content uk-clearfix">
        	           		<div><?php echo $this->product->product_s_desc ?></div>
                        </div>
            	    <?php 
                	} // Product Short Description END ?>
                </div>
            </article>
            
            <form method="post" class="form-validate uk-form" action="<?php echo $action; ?>" name="askform" id="askform">
				<div class="uk-form-row">
                	<label class="uk-form-label" for="name"><?php echo vmText::_('COM_VIRTUEMART_RECOMMEND_NAME'); ?></label>
          			<div class="uk-form-controls">
                    	<input type="text" required class="validate[required,minSize[3],maxSize[64]] uk-width-small-1-2" value="<?php echo $name_value; ?>" name="name" id="name" size="30"  validation="required name"/>
                    </div>
                </div>
                <div class="uk-form-row">
					<label class="uk-form-label" for="email"><?php echo vmText::_('COM_VIRTUEMART_RECOMMEND_EMAIL'); ?></label>
          			<div class="uk-form-controls">
                    	<input type="email" required class="validate[required,custom[email]] uk-width-small-1-2" value="<?php echo $email_value; ?>" name="email" id="email" size="30"  validation="required email"/>
                    </div>
                </div>
        		<div class="uk-form-row">
                    <label class="uk-form-label" for="comment"><?php echo vmText::sprintf('COM_VIRTUEMART_COMMENT', $min, $max); ?></label>
                    <div class="uk-form-controls">
                        <textarea title="<?php echo $ask_comment; ?>" required class="validate[required,minSize[<?php echo $min ?>],maxSize[<?php echo $max ?>]] field uk-width-1-1" id="comment" name="comment" rows="8"><?php echo $askQuestionData['comment'] ?></textarea>
                    </div>
                </div>
				<div class="uk-form-row" data-uk-margin>
					<?php echo vmText::_('COM_VIRTUEMART_ASK_COUNT')  ?>
                    <input type="text" value="0" size="4" class="counter uk-form-width-mini" id="counter" name="counter" maxlength="4" readonly="readonly" />
                    
                    <?php // captcha addition
                    echo $this->captcha;
                    // end of captcha addition ?>
                    
                    <button class="uk-button uk-button-primary" type="submit" name="submit_ask" title="<?php echo vmText::_('COM_VIRTUEMART_RECOMMEND_SUBMIT')  ?>">
                    	<?php echo vmText::_('COM_VIRTUEMART_RECOMMEND_SUBMIT')  ?>
                    </button>
                    
                </div>
				
                <input type="hidden" name="virtuemart_product_id" value="<?php echo vRequest::getInt('virtuemart_product_id',0); ?>" />
				<input type="hidden" name="tmpl" value="component" />
				<input type="hidden" name="view" value="productdetails" />
				<input type="hidden" name="option" value="com_virtuemart" />
				<input type="hidden" name="virtuemart_category_id" value="<?php echo vRequest::getInt('virtuemart_category_id'); ?>" />
				<input type="hidden" name="task" value="mailRecommend" />
				<?php echo JHTML::_( 'form.token' ); ?>
			</form>
			
		</div>
	<?php
	} ?>
<?php
} ?>
