<?php

/**

 *

 * Show the product details page

 *

 * @package    VirtueMart

 * @subpackage

 * @author Max Milbers

 * @todo handle child products

 * @link http://www.virtuemart.net

 * @copyright Copyright (c) 2015 VirtueMart Team. All rights reserved.

 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php

 * VirtueMart is free software. This version may have been modified pursuant

 * to the GNU General Public License, and as distributed it includes or

 * is derivative of works licensed under the GNU General Public License or

 * other free or open source software licenses.

 * @version $Id: default_addtocart.php 7833 2014-04-09 15:04:59Z Milbo $

 */

// Check to ensure this file is included in Joomla!

defined('_JEXEC') or die('Restricted access');



$product = $viewData['product'];

$class 	 = isset($viewData['class']) ? $viewData['class'] : 'addtocart-bar-small';



$init = 1;

if(isset($viewData['init']))

{

	$init = $viewData['init'];

}



if(!empty($product->min_order_level) and $init<$product->min_order_level)

{

	$init = $product->min_order_level;

}



$step = 1;

if (!empty($product->step_order_level))

{

	$step = $product->step_order_level;

	

	if(!empty($init))

	{

		if($init < $step)

		{

			$init = $step;

		}

		else

		{

			$init = ceil($init / $step) * $step;

		}

	}

	

	if(empty($product->min_order_level) and !isset($viewData['init']))

	{

		$init = $step;

	}

}



$maxOrder= '';

if (!empty($product->max_order_level))

{

	$maxOrder = ' max="'.$product->max_order_level.'" ';

}

?>

<div class="addtocart-bar <?php echo $class;?>">

	<?php

    // Display the quantity box

    $stockhandle = VmConfig::get('stockhandle_products', false) && $product->product_stockhandle ? $product->product_stockhandle : VmConfig::get('stockhandle','none');

    

    if (($stockhandle == 'disableit' or $stockhandle == 'disableadd') and ($product->product_in_stock - $product->product_ordered) < 1) 

    {

        $notify_url = JRoute::_ ('index.php?option=com_virtuemart&view=productdetails&layout=notify&virtuemart_product_id=' . $product->virtuemart_product_id)

        ?>

        <!-- <a class="uk-button" href="<?php echo $notify_url;?>"><?php echo vmText::_ ('COM_VIRTUEMART_CART_NOTIFY') ?></a> -->

    <?php

    } else 

    {

        $tmpPrice = (float) $product->prices['costPrice'];

        

        if (!( VmConfig::get('askprice', true) and empty($tmpPrice) ) ) 

        { ?>

            <?php if ($product->orderable) 

            { ?>

                

                <!-- <label for="quantity<?php echo $product->virtuemart_product_id; ?>" class="quantity_box"><?php echo vmText::_ ('COM_VIRTUEMART_CART_QUANTITY'); ?>: </label> -->

                <span class="quantity-box">

                    <i class="uk-icon-caret-down quantity-controls quantity-minus"></i>

                    <input type="text" class="quantity-input js-recalculate uk-form-width-mini uk-text-center" name="quantity[]"

                        data-errStr="<?php echo vmText::_ ('COM_VIRTUEMART_WRONG_AMOUNT_ADDED')?>"

						value="<?php echo $init; ?>" init="<?php echo $init; ?>" step="<?php echo $step; ?>" <?php echo $maxOrder; ?>

                    />

                    <i class="uk-icon-caret-up quantity-controls quantity-plus"></i>

                    <!--

                    <span class="quantity-controls js-recalculate tm-quantity-controls">

                        <i class="uk-icon-caret-up quantity-controls quantity-plus"></i>

                        <i class="uk-icon-caret-down quantity-controls quantity-minus"></i>

                    </span>

                    -->

                </span>

            <?php

            }?>



            <span class="addtocart-button">

                <?php if($product->addToCartButton)

                { ?>

                    <?php echo $product->addToCartButton;?>

                <?php

                } else 

                { ?>

                    <?php if($product->orderable) 

                    { ?>

                        <button type="submit" name="addtocart" class="addtocart-button uk-button uk-button-primary" title="<?php echo vmText::_( 'COM_VIRTUEMART_CART_ADD_TO' );?>">

                            <?php echo vmText::_( 'COM_VIRTUEMART_CART_ADD_TO' );?>

                        </button>

                    <?php

                    } else 

                    {?>

                        <button name="addtocart" disabled="disabled" class="addtocart-button-disabled uk-button" title="<?php echo vmText::_( 'COM_VIRTUEMART_ADDTOCART_CHOOSE_VARIANT' );?>">

                            <?php echo vmText::_( 'COM_VIRTUEMART_ADDTOCART_CHOOSE_VARIANT' );?>

                        </button>

                    <?php

                    } ?>

                <?php

                }?>

            </span>

            

            <input type="hidden" name="virtuemart_product_id[]" value="<?php echo $product->virtuemart_product_id ?>"/>

            <noscript><input type="hidden" name="task" value="add"/></noscript>

    

        <?php

        } ?>

    

    <?php

    } ?>



</div>