<?php
defined('_JEXEC') or die('Restricted access');

$product = $viewData['product'];

$days         		= (int) VmConfig::get ('latest_products_days', 7);
$date         		= JFactory::getDate('now - ' . $days . ' days');
$aDate        		= JFactory::getDate($product->product_available_date); // VmConfig::get ('latest_products_orderBy','created_on') - created_on, modified_on, product_available_date
$stockHandler 		= VmConfig::get('stockhandle', 'none');
$show_badge_sold 	= isset($viewData['show_badge_sold']) 	? $viewData['show_badge_sold'] : false;
$show_badge_new 	= isset($viewData['show_badge_new']) 	? $viewData['show_badge_new'] : false;
$show_badge_promo 	= isset($viewData['show_badge_promo']) 	? $viewData['show_badge_promo'] : false;
$show_badge_sale	= isset($viewData['show_badge_sale']) 	? $viewData['show_badge_sale'] : false;
$custom_badge		= false;
?>

<?php if (!empty($product->customfieldsSorted['badge'])) 
{ ?>
	<?php foreach ($product->customfieldsSorted['badge'] as $field) 
	{
		$badge_position = in_array($field->customfield_value, array('new', 'sale', 'promo', 'sold')) ? 'uk-panel-badge-flip' : '';
		$badge_file = 'images/badges/'.$field->customfield_value.'.png';
		$custom_badge = true;
		?>
		<div class="uk-panel-badge <?php echo $badge_position;?> vm-badge-custom vm-badge-custom-<?php echo $field->customfield_value;?>">
			<img src="<?php echo $badge_file;?>">
		</div>
	<?php
	}?>
<?php
} ?>

<?php if(!$custom_badge)
{ ?>
	<?php if($show_badge_sold && ($stockHandler == 'disableit' || $stockHandler == 'disableadd') && ($product->product_in_stock - $product->product_ordered) < 1)
    { ?>
        <div class="uk-panel-badge uk-panel-badge-flip uk-badge vm-badge-sold"><?php echo JText::_('TPL_WARP_VM_BADGE_SOLD');?></div>
    <?php
    } elseif($show_badge_new && ($aDate->toUnix() > 0) && ($aDate >= $date))
    { ?>
        <div class="uk-panel-badge uk-panel-badge-flip uk-badge vm-badge-new"><?php echo JText::_('TPL_WARP_VM_BADGE_NEW');?></div>
    <?php
    } ?>
    
    <?php if($show_badge_promo && $product->product_special)
    { ?>
        <div class="uk-panel-badge uk-badge vm-badge-promo"><?php echo JText::_('TPL_WARP_VM_BADGE_PROMO');?></div>
    <?php 
    } elseif($show_badge_sale && isset($product->prices) && $product->prices['discountAmount'] < 0)
    { ?>
        <div class="uk-panel-badge uk-badge vm-badge-sale"><?php echo JText::_('TPL_WARP_VM_BADGE_SALE');?></div>
    <?php
    } ?>
<?php
}?>


