<?php
/**
*
* Shows the products/categories of a category
*
* @package	VirtueMart
* @subpackage
* @author Max Milbers
* @link http://www.virtuemart.net
* @copyright Copyright (c) 2004 - 2014 VirtueMart Team. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
* VirtueMart is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
 * @version $Id: default.php 6104 2012-06-13 14:15:29Z alatak $
*/

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');

$categories				= $viewData['categories'];
$viewData['columns'] 	= isset($viewData['columns']) ? $viewData['columns'] : VmConfig::get ( 'categories_per_row', 3 );

// Grid
$grid = 'uk-grid';
$grid .= isset($viewData['gutter']) ? ' uk-grid-'.$viewData['gutter'] : '' ;
$grid .= ' uk-grid-width-1-'.$viewData['columns'];
$grid .= isset($viewData['columns_small']) 	? ' uk-grid-width-small-1-'.$viewData['columns_small'] : '';
$grid .= isset($viewData['columns_medium']) ? ' uk-grid-width-medium-1-'.$viewData['columns_medium'] : '';
$grid .= isset($viewData['columns_large']) 	? ' uk-grid-width-large-1-'.$viewData['columns_large'] : '';
$grid .= isset($viewData['columns_xlarge']) ? ' uk-grid-width-xlarge-1-'.$viewData['columns_xlarge'] : '';
$grid .= isset($viewData['class']) 			? $viewData['class'] : '';

$ajaxUpdate = '';
if(VmConfig::get ('ajax_category', false)){
	$ajaxUpdate = 'data-dynamic-update="1"';
}
?>

<?php if ($categories) 
{ ?>
    <div class="<?php echo $grid; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin>
        <?php foreach ( $categories as $category ) 
        {
            // Category Link
            $caturl = JRoute::_ ( 'index.php?option=com_virtuemart&view=category&virtuemart_category_id=' . $category->virtuemart_category_id , FALSE);
            ?>
            <div>
                <div class="uk-panel vm-panel-list vm-category">
                    <?php if (!empty($category->images[0])) 
                    {
                        $image = $category->images[0]->displayMediaThumb ('class="uk-responsive-height browseCategoryImage"', FALSE);
                        ?>
                        <div class="uk-panel-teaser">
                            <div class="uk-thumbnail uk-thumbnail-expand vm-thumbnail-list uk-text-center">
								<?php echo JHTML::_ ('link', $caturl, $image, array('title' => vmText::_($category->category_name), 'class' => 'uk-width-1-1 uk-height-1-1 uk-display-block uk-vertical-align')); ?>
                            </div>
                        </div>
                    <?php
                    } ?>
                    
                    <h3 class="uk-h4 uk-margin-remove vm-title-teaser"><?php echo JHTML::_ ('link', $caturl, vmText::_($category->category_name), array('title' => vmText::_($category->category_name))); ?></h3>

                </div>
            </div>
        <?php
        } ?>
    </div>
<?php
} ?>
