<?php

/**

* sublayout products

*

* @package	VirtueMart

* @author Max Milbers

* @link http://www.virtuemart.net

* @copyright Copyright (c) 2014 VirtueMart Team. All rights reserved.

* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL2, see LICENSE.php

* @version $Id: cart.php 7682 2014-02-26 17:07:20Z Milbo $

*/



defined('_JEXEC') or die('Restricted access');



$product 		= $viewData['product'];

$position 		= isset($viewData['position']) 		? $viewData['position'] : '';

$customTitle 	= isset($viewData['customTitle']) 	? $viewData['customTitle'] : false;

$class 			= isset($viewData['class']) 		? $viewData['class'].' product-fields' : 'product-fields';

$inline			= isset($viewData['inline']) 		? 'uk-display-inline-block' : '';

$field_class	= isset($viewData['field_class']) 	? $viewData['field_class'] : 'uk-margin-small';

?>



<?php if (!empty($product->customfieldsSorted[$position])) 

{ ?>

	<div class="uk-margin <?php echo $class?>">

		<?php if($customTitle and isset($product->customfieldsSorted[$position][0]))

		{

			$field = $product->customfieldsSorted[$position][0];

			?>

			<div class="<?php echo $field_class;?> product-field product-field-type-<?php echo $field->field_type ?>">

                <div class="product-fields-title-wrapper <?php echo $inline;?>">

                    <span class="product-fields-title uk-text-bold"><?php echo vmText::_ ($field->custom_title) ?>: </span>

                    <?php if ($field->custom_tip) 

                    { ?>

                        <i class="uk-icon-info" title="<?php echo vmText::_($field->custom_tip); ?>" data-uk-tooltip=""></i>

                    <?php

                    } ?>

                </div>

            </div>

		<?php

        } ?>

		

        <?php $custom_title = null;

        $tm_customfieldsSorted = array();
               
		foreach ($product->customfieldsSorted[$position] as $field) 
		{
			$key = (string) $field->virtuemart_custom_id.$field->field_type;

			if( !isset($tm_customfieldsSorted[$key]))
			{
				$tm_customfieldsSorted[$key] = $field;
				$tm_customfieldsSorted[$key]->tmdisplay = array();
			}

			$tm_customfieldsSorted[$key]->tmdisplay[] = $field->display;
		}
				                
		foreach ($tm_customfieldsSorted as $field) 

		{

			if ( $field->is_hidden || empty($field->display) ) continue;

			?>

            
            <div class="<?php echo $field_class;?> product-field product-field-type-<?php echo $field->field_type ?>">

				<?php if (!$customTitle and $field->custom_title != $custom_title and $field->show_title) 

				{ ?>

					<div class="product-fields-title-wrapper <?php echo $inline;?>">

                    	<span class="product-fields-title uk-text-bold"><?php echo vmText::_($field->custom_title) ?>: </span>

						<?php if ($field->custom_tip) 

						{ ?>

                        	<i class="uk-icon-info" title="<?php echo vmText::_($field->custom_tip); ?>" data-uk-tooltip=""></i>

						<?php

                        } ?>

                	</div>

				<?php

                } ?>

                <?php if (!empty($field->tmdisplay))
				{ ?>
				
					<?php if($field->field_type == 'S')
					{ ?>
                		<div class="product-field-display <?php echo $inline;?>"><?php echo implode(", ", $field->tmdisplay); ?></div>
                	<?php
                	} else
                	{?>
                		<div class="product-field-display <?php echo $inline;?>"><?php echo implode("\n", $field->tmdisplay); ?></div>
                	<?php
                	} ?>
				
				<?php
                } ?>

                <?php if (!empty($field->custom_desc))

				{ ?>

                	<div class="product-field-desc"><?php echo vmText::_($field->custom_desc) ?></div>

                <?php

                } ?>

			</div>

            

			<?php $custom_title = $field->custom_title;

		} ?>

    	<div class="uk-clearfix"></div>

	</div>

<?php

} ?>