<?php
/**
 *
 * Show the product prices
 *
 * @package    VirtueMart
 * @subpackage
 * @author Max Milbers, Valerie Isaksen
 * @link http://www.virtuemart.net
 * @copyright Copyright (c) 2004 - 2014 VirtueMart Team. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 * VirtueMart is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * @version $Id: default_showprices.php 8024 2014-06-12 15:08:59Z Milbo $
 */
// Check to ensure this file is included in Joomla!
defined ('_JEXEC') or die('Restricted access');

// helper: createPriceDiv($name, $description, $product_price, $priceOnly=false, $switchSequel=false, $quantity = 1.0, $forceNoLabel = false)

$product 	= $viewData['product'];
$currency 	= $viewData['currency'];
$show_offer = isset($viewData['show_offer']) ? $viewData['show_offer'] : false;
//print_r($product->prices);
?>

<div class="product-price" id="productPrice<?php echo $product->virtuemart_product_id ?>">
	    	
	<?php if (!empty($product->prices['salesPrice'])) 
	{ ?>
		<?php //echo '<div class="vm-cart-price">' . vmText::_ ('COM_VIRTUEMART_CART_PRICE') . '</div>'; ?>
	<?php
    } ?>

	<?php if ($product->prices['salesPrice'] <= 0 and VmConfig::get ('askprice', 1) and isset($product->images[0]) and !$product->images[0]->file_is_downloadable) 
	{
		$askquestion_url = JRoute::_('index.php?option=com_virtuemart&view=productdetails&task=askquestion&virtuemart_product_id=' . $product->virtuemart_product_id . '&virtuemart_category_id=' . $product->virtuemart_category_id . '&tmpl=component', FALSE);
		?>
		<a class="uk-button" data-uk-lightbox data-lightbox-type="iframe" href="<?php echo $askquestion_url ?>"><?php echo vmText::_ ('COM_VIRTUEMART_PRODUCT_ASKPRICE') ?></a>
	<?php
	} else 
	{ ?>
    
    	<?php if ($product->prices['override'] == 1 && ($product->prices['product_price_publish_down'] > 0) && $show_offer)
		{
			$warp['asset']->addFile('js', 'js:countdown/jquery.countdown.js');
			?>
        	<div>
                                
                <div class="uk-grid uk-grid-match uk-grid-small uk-grid-width-small-1-3" data-uk-grid-margin>
                    <?php 
                    if (round($product->prices['salesPriceTemp'], $currency->_priceConfig['salesPrice'][1]) != round($product->prices['salesPrice'], $currency->_priceConfig['salesPrice'][1]))
                    { ?>
                        <div>
                            <div class="uk-panel uk-panel-box price-old uk-text-center">
                                <span class="text uk-text-small"><?php echo JText::_('TPL_WARP_VM_OLD_PRICE'); ?>:</span>
                                <del class="text-price uk-text-muted uk-text-bold uk-text-large"><?php echo $currency->createPriceDiv('salesPriceTemp', '', $product->prices);?></del>
                            </div>
                        </div>
                    <?php 
                    } ?>
                    
                    <div>
                        <div class="uk-panel uk-panel-box price-sale uk-text-center">
                            <span class="text uk-text-small"><?php echo JText::_('TPL_WARP_VM_SPECIAL_DEAL_PRICE'); ?>:</span>
                            <span class="text-price uk-text-primary uk-text-bold uk-text-large"><?php echo $currency->createPriceDiv('salesPrice', '', $product->prices);?></span>
                        </div>
                    </div>
                    
                    <?php // Cantidad de descuento
            		if($product->prices['discountAmount'])
            		{ ?>
                        <div>      
                            <div class="uk-panel uk-panel-box price_save uk-text-center">
                                <span class="text uk-text-small"><?php echo JText::_('TPL_WARP_VM_YOU_ARE_SAVING'); ?>:</span>
                                <span class="text-price uk-text-bold uk-text-large"><?php echo $currency->createPriceDiv('discountAmount', '', $product->prices); ?></span>
                            </div>
                        </div>
                    <?php 
                    } ?>
                </div>
                
                <div class="uk-panel uk-margin">
                    <h3><?php echo JText::_('TPL_WARP_VM_THIS_LIMITED_OFFER_ENDS_IN')?></h3>
                    
                    <div data-countdown="<?php echo $product->prices['product_price_publish_down'];?>" class="uk-panel vm-countdown">
                    	<script type="text/javascript">
							jQuery(function ($) 
							{														
								$('[data-countdown]').each(function() 
								{
									var $this = $(this), finalDate = $(this).data('countdown');
									$this.countdown(finalDate).on('update.countdown', function(event)
									{
										var h = '<span class="countdown-section"><span class="countdown-number">%H</span><span class="countdown-text"><?php echo JText::_('TPL_WARP_HOURS');?></span></span>';
										var m = '<span class="countdown-section"><span class="countdown-number">%M</span><span class="countdown-text"><?php echo JText::_('TPL_WARP_MINUTES');?></span></span>';
										var s = '<span class="countdown-section"><span class="countdown-number">%S</span><span class="countdown-text"><?php echo JText::_('TPL_WARP_SECONDS');?></span></span>';
										var d = '<span class="countdown-section"><span class="countdown-number">%-d</span><span class="countdown-text"><?php echo JText::_('TPL_WARP_DAYS');?>%!d</span></span>';
										var w = '<span class="countdown-section"><span class="countdown-number">%-w</span><span class="countdown-text"><?php echo JText::_('TPL_WARP_WEEKS');?>%!w</span></span>';
										
										var format = h+m+s;
										
										if(event.offset.days > 0) {
											format = d + format;
										}
										if(event.offset.weeks > 0) {
											format = w + format;
										}
										
										$(this).html(event.strftime(format));
									}).on('finish.countdown', function(event) 
									{
										$(this).html('<?php echo JText::_('TPL_WARP_THIS_OFFER_HAS_EXPIRED');?>').parent().addClass('disabled');
									});
								});
							});
						</script>
                    </div>
				
                </div>

            </div>
        <?php 
		}else
		{ ?>
		
			<?php // Precio base
            if($product->prices['basePrice'])
            { ?>
                <?php //echo $currency->createPriceDiv ('basePrice', 'COM_VIRTUEMART_PRODUCT_BASEPRICE', $product->prices); ?>
            <?php
            }?>
            
            <?php // Precio base para variación
            if($product->prices['basePriceVariant'])
            { ?>
                <?php //echo $currency->createPriceDiv ('basePriceVariant', 'COM_VIRTUEMART_PRODUCT_BASEPRICE_VARIANT', $product->prices); ?>
            <?php
            }?>
            
            <?php if($product->prices['variantModification'])
            { ?>
                <?php //echo $currency->createPriceDiv ('variantModification', 'COM_VIRTUEMART_PRODUCT_VARIANT_MOD', $product->prices); ?>
            <?php
            }?>
                            
            <?php // Precio de venta con descuento
			if (round($product->prices['salesPriceWithDiscount'], $currency->_priceConfig['salesPrice'][1]) != round($product->prices['salesPrice'], $currency->_priceConfig['salesPrice'][1]))
            { ?>
                <?php //echo $currency->createPriceDiv ('salesPriceWithDiscount', 'COM_VIRTUEMART_PRODUCT_SALESPRICE_WITH_DISCOUNT', $product->prices); ?>
            <?php
            }?>
                            
            <?php // Precio de venta sin impuestos
            if ($product->prices['discountedPriceWithoutTax'] != $product->prices['priceWithoutTax'])
            { ?>
                <?php //echo $currency->createPriceDiv ('discountedPriceWithoutTax', 'COM_VIRTUEMART_PRODUCT_SALESPRICE_WITHOUT_TAX', $product->prices); ?>
                <?php //echo $currency->createPriceDiv ('discountedPriceWithoutTaxTt', 'COM_VIRTUEMART_PRODUCT_SALESPRICE_WITHOUT_TAX_TT', $product->prices); ?>
            <?php
            } else 
            {?>
                <?php //echo $currency->createPriceDiv ('priceWithoutTax', 'COM_VIRTUEMART_PRODUCT_SALESPRICE_WITHOUT_TAX', $product->prices); ?>
                <?php //echo $currency->createPriceDiv ('priceWithoutTaxTt', 'COM_VIRTUEMART_PRODUCT_SALESPRICE_WITHOUT_TAX_TT', $product->prices); ?>
            <?php
            } ?>
            
            <?php // Cantidad de descuento
            if($product->prices['discountAmount'])
            { ?>
                <?php //echo $currency->createPriceDiv ('discountAmount', 'COM_VIRTUEMART_PRODUCT_DISCOUNT_AMOUNT', $product->prices); ?>
            <?php
            }?>

            <?php //echo $currency->createPriceDiv ('discountAmountTt', 'COM_VIRTUEMART_PRODUCT_DISCOUNT_AMOUNT_TT', $product->prices); ?>
            
            <?php // Cantidad de impuestos
            if($product->prices['taxAmount'])
            { ?>
                <?php //echo $currency->createPriceDiv ('taxAmount', 'COM_VIRTUEMART_PRODUCT_TAX_AMOUNT', $product->prices); ?>
            <?php
            }?>
                      
            <?php 
            //if (round($product->prices['salesPriceTemp'], $currency->_priceConfig['salesPrice'][1]) != round($product->prices['salesPrice'], $currency->_priceConfig['salesPrice'][1]))
            if (round($product->prices['basePriceWithTax'], $currency->_priceConfig['salesPrice'][1]) != round($product->prices['salesPrice'], $currency->_priceConfig['salesPrice'][1]))
            { ?>
                <del class="uk-text-muted">
                    <?php echo $currency->createPriceDiv ('basePriceWithTax', 'COM_VIRTUEMART_PRODUCT_BASEPRICE_WITHTAX', $product->prices, false, false, 1.0, true); ?>
                </del>
            <?php
            } ?>
            
            <div class="uk-text-large uk-text-primary"><?php echo $currency->createPriceDiv ('salesPrice', 'COM_VIRTUEMART_PRODUCT_SALESPRICE', $product->prices, false, false, 1.0, true); ?></div>

            <?php // Cantidad de descuento
            if($product->prices['discountAmount'])
            {
                $porcentaje = number_format((($product->prices['salesPriceTemp'] - $product->prices['salesPrice']) / $product->prices['salesPriceTemp']) * 100, 0, ',', '.');
                /* (<?php echo $currency->createPriceDiv ('discountAmount', 'COM_VIRTUEMART_PRODUCT_DISCOUNT_AMOUNT', $product->prices); ?>) */
                ?>
                <div class="vm-price-product-porcentaje">
                    <span><?php echo JText::sprintf('COM_VIRTUEMART_PRODUCT_PORCENTAJE', $porcentaje.'%');?></span>
                </div>
                
            <?php
            }?>

            <?php //echo $currency->createPriceDiv ('salesPriceTt', 'COM_VIRTUEMART_PRODUCT_SALESPRICE_TT', $product->prices); ?>
            <?php //echo $currency->createPriceDiv ('salesPrice', 'COM_VIRTUEMART_PRODUCT_SALESPRICE', $product->prices); ?>
            <?php //echo $currency->createPriceDiv ('salesPriceQu', 'COM_VIRTUEMART_PRODUCT_SALESPRICE', $product->prices); ?>

            <?php //echo $currency->createPriceDiv ('taxAmountTt', 'COM_VIRTUEMART_PRODUCT_TAX_AMOUNT_TT', $product->prices); ?>
            
            <?php if($product->prices['unitPrice'])
            {
                $unitPriceDescription = vmText::sprintf ('COM_VIRTUEMART_PRODUCT_UNITPRICE', vmText::_('COM_VIRTUEMART_UNIT_SYMBOL_'.$product->product_unit));
                ?>
                <?php echo $currency->createPriceDiv ('unitPrice', $unitPriceDescription, $product->prices); ?>
            <?php
            }?>
    
    	<?php
		}?>
	<?php
    } ?>
</div>
