<?php

/**

 * sublayout products

 *

 * @package	VirtueMart

 * @author Max Milbers

 * @link http://www.virtuemart.net

 * @copyright Copyright (c) 2014 VirtueMart Team. All rights reserved.

 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL2, see LICENSE.php

 * @version $Id: cart.php 7682 2014-02-26 17:07:20Z Milbo $

 */



defined('_JEXEC') or die('Restricted access');



$currency 				= $viewData['currency'] ? $viewData['currency'] : CurrencyDisplay::getInstance();

$products 				= $viewData['products'];

$show_rating 			= isset($viewData['show_rating']) 				? $viewData['show_rating'] 				: false;

$show_stock 			= isset($viewData['show_stock']) 				? $viewData['show_stock'] 				: false;

$show_short_description	= isset($viewData['show_short_description']) 	? $viewData['show_short_description'] 	: false;

$show_sku				= isset($viewData['show_sku']) 					? $viewData['show_sku'] 				: false;

$show_prices 			= isset($viewData['show_prices']) 				? $viewData['show_prices'] 				: false;

$show_offer 			= isset($viewData['show_offer']) 				? $viewData['show_offer'] 				: false;

$show_addtocart 		= isset($viewData['show_addtocart']) 			? $viewData['show_addtocart'] 			: false;

$show_addtofavorite		= isset($viewData['show_addtofavorite'])		? $viewData['show_addtofavorite']		: false;

$show_readmore 			= isset($viewData['show_readmore']) 			? $viewData['show_readmore'] 			: false;

$show_badge_sold 		= isset($viewData['show_badge_sold']) 			? $viewData['show_badge_sold'] 			: false;

$show_badge_new 		= isset($viewData['show_badge_new']) 			? $viewData['show_badge_new'] 			: false;

$show_badge_promo 		= isset($viewData['show_badge_promo']) 			? $viewData['show_badge_promo'] 		: false;

$show_badge_sale 		= isset($viewData['show_badge_sale']) 			? $viewData['show_badge_sale'] 			: false;

$show_slider            = isset($viewData['show_slider'])               ? $viewData['show_slider']              : true;

$viewData['columns'] 	= isset($viewData['columns']) 					? $viewData['columns'] : VmConfig::get ( 'products_per_row', 3 );



// Grid

$grid = 'uk-grid';

$grid .= isset($viewData['gutter']) ? ' uk-grid-'.$viewData['gutter'] : '' ;

$grid .= ' uk-grid-width-1-'.$viewData['columns'];

$grid .= isset($viewData['columns_small']) && $viewData['columns_small'] ? ' uk-grid-width-small-1-'.$viewData['columns_small'] : '';

$grid .= isset($viewData['columns_medium']) && $viewData['columns_medium']	? ' uk-grid-width-medium-1-'.$viewData['columns_medium'] : '';

$grid .= isset($viewData['columns_large']) && $viewData['columns_large'] 	? ' uk-grid-width-large-1-'.$viewData['columns_large'] : '';

$grid .= isset($viewData['columns_xlarge']) && $viewData['columns_xlarge']	? ' uk-grid-width-xlarge-1-'.$viewData['columns_xlarge'] : '';

$grid .= isset($viewData['class']) && $viewData['class'] 			? $viewData['class'] : ' vm-product-list';



$ItemidStr = '';

$Itemid = shopFunctionsF::getLastVisitedItemId();

if(!empty($Itemid)){

	$ItemidStr = '&Itemid='.$Itemid;

}



$product_model = VmModel::getModel('product');

$i = 0;



$dynamic = false;



if (vRequest::getInt('dynamic',false) and vRequest::getInt('virtuemart_product_id',false)) {

	$dynamic = true;

}

?>



<?php if(count($products) > 0)

{ ?>

    <?php foreach ( $products as $type => $products ) 

    {

        // only products

        if( in_array($type, array('featured','discontinued', 'latest', 'topten', 'recent')) ) continue;

        ?>

        <div class="<?php echo $grid; ?>" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin>

            <?php foreach ( $products as $product ) 

            {

                $url = $product->link.$ItemidStr;

                ?>

                <div>

                    <div class="uk-panel vm-panel-list vm-product">



                    	<?php echo shopFunctionsF::renderVmSubLayout('badges', array('product' => $product, 'show_badge_sold' => $show_badge_sold, 'show_badge_new' => $show_badge_new, 'show_badge_promo' => $show_badge_promo, 'show_badge_sale' => $show_badge_sale)); ?>

                                            					

    					<?php if (!empty($product->images) ) 

                        {

                            $product_model->addImages($product);

                            ?>

                            <div class="uk-panel-teaser">

                            	                                                    

                            	<?php if(count($product->images) > 1 && $show_slider)

    							{?>

                                    <div class="uk-slidenav-position" data-uk-slideshow="{autoplay:false, animation: 'scroll'}">

                                        <ul class="uk-slideshow vm-slideshow">

                                            <?php foreach($product->images as $key => $image)

                                            {?>

                                                <li>

                                                    <div class="uk-thumbnail-expand vm-thumbnail-list uk-text-center">

                                                        <?php echo JHTML::_ ('link', $url, $image->displayMediaThumb ('class="uk-responsive-height"', FALSE), array('title' => $product->product_name, 'class' => 'uk-width-1-1 uk-height-1-1 uk-display-block uk-vertical-align')); ?>

                                                    </div>

                                                </li>

                                            <?php

                                            }?>

                                        </ul>



                                        <a href="#" class="uk-slidenav uk-slidenav-previous" data-uk-slideshow-item="previous"></a>

                                        <a href="#" class="uk-slidenav uk-slidenav-next" data-uk-slideshow-item="next"></a>



                                        <div class="uk-margin-bottom">

                                            <ul class="uk-dotnav uk-dotnav-contrast uk-flex-center">

                                                <?php foreach($product->images as $image)

                                                { ?>

                                                    <li data-uk-slideshow-item="<?php echo $i++; ?>"><a href=""></a></li>

                                                <?php

                                                } $i = 0;?>

                                            </ul>

                                        </div>

                                        

                                    </div>

                                <?php

    							}else

    							{?>

                                	<div class="uk-thumbnail uk-thumbnail-expand vm-thumbnail-list uk-text-center">

                                		<?php echo JHTML::_ ('link', $url, $product->images[0]->displayMediaThumb ('class="uk-responsive-height"', FALSE), array('title' => $product->product_name, 'class' => 'uk-width-1-1 uk-height-1-1 uk-display-block uk-vertical-align')); ?>

                            		</div>

                                <?php

    							}?>

                            

                            </div>

                        <?php

                        } ?>

                                                                                                    

                        <h2 class="uk-h4 uk-margin-remove vm-title-teaser"><?php echo JHTML::_ ('link', $url, $product->product_name, array('title' => $product->product_name)); ?></h2>

                        

                        <?php if (!empty($product->product_sku) && $show_sku) 

                        { ?>

                            <p class="uk-margin-remove vm-product-sku"><?php echo $product->product_sku ?></p>

                        <?php 

                        } ?>

                        

                        <?php if ($show_rating || $show_stock)

                        { ?>

                            <div class="uk-margin">

                                <?php echo shopFunctionsF::renderVmSubLayout('rating', array('show_rating' => $show_rating, 'product' => $product)); ?>

                                <?php echo shopFunctionsF::renderVmSubLayout('stock', array('show_stock' => $show_stock, 'product' => $product)); ?>

                                <?php echo shopFunctionsF::renderVmSubLayout('stockhandle', array('product' => $product)); ?>

                            </div>

                        <?php

                        }?>

                

                        <?php if (!empty($product->product_s_desc) && $show_short_description) 

                        { ?>

                            <p class="vm-description-short"><?php echo shopFunctionsF::limitStringByWord ($product->product_s_desc, 60, ' ...') ?></p>

                            <hr />

                        <?php 

                        } ?>

                

                        <?php if ($show_prices && isset($product->prices))

                        { ?>

                            <div class="uk-margin vm-product-prices"><?php echo shopFunctionsF::renderVmSubLayout('prices', array('product' => $product, 'currency' => $currency, 'show_offer' => $show_offer)); ?></div>

                        <?php

                        }?>

                        

                        <?php if ($show_addtocart)

                        { ?>

                            <div class="uk-margin vm-product-addtocart"><?php echo shopFunctionsF::renderVmSubLayout('addtocart', array('product' => $product, 'position' => array('addtocart'))); ?></div>

                        <?php

                        }?>

                        

                        <?php if ($show_addtofavorite)

                        { ?>

                        	<div class="uk-margin vm-product-addtocart"><?php require( $warp['path']->path('layouts:com_wishlist/addtofavorites.php') ); ?></div>

                        <?php

                        }?>

                        

                        <?php if ($show_readmore)

                        { ?>

                            <div class="uk-margin vm-readmore">

                                <?php echo JHtml::link((empty($product->link) ? $product->canonical.$ItemidStr : $product->link.$ItemidStr), vmText::_ ( 'COM_VIRTUEMART_PRODUCT_DETAILS' ), array ('title' => $product->product_name, 'class' => 'vm-button-readmore' ) ); ?>

                            </div>

                        <?php

                        }?>



                        <?php if($dynamic)

                        {

			                echo vmJsApi::writeJS();

		                } ?>

                        

                    </div>

                </div>

            <?php

            }?>

        </div>

    <?php

    }?>

<?php

} ?>

