<?php defined('_JEXEC') or die('Restricted access');

$product 		= $viewData['product'];
$width 			= isset($viewData['width']) 		? $viewData['width'] 		: 'uk-width-2-5';
$show_rating 	= isset($viewData['show_rating']) 	? $viewData['show_rating'] 	: false;
?>

<?php if ($show_rating) 
{
	$ratingModel = VmModel::getModel('ratings');
	$product_model = VmModel::getModel('product');

	$rating_reviews = array();

	if (!isset($product->rating))
	{
		$product_model->withRating = $showRating = $ratingModel->showRating($product->virtuemart_product_id);
		$product = $product_model->getProduct($product->virtuemart_product_id, TRUE, TRUE, TRUE);
	}

	$allowReview 	= $ratingModel->allowReview($product->virtuemart_product_id);
	$showReview 	= $ratingModel->showReview($product->virtuemart_product_id);
	$allowRating 	= $ratingModel->allowRating($product->virtuemart_product_id);

	if ($showReview)
	{		
		$review = $ratingModel->getProductReviewForUser($product->virtuemart_product_id);
		$rating_reviews = $ratingModel->getReviews($product->virtuemart_product_id, 0, VmConfig::get( 'vm_num_ratings_show', 3 ));

		$rating_reviews = array_filter($rating_reviews, function($review){
			return $review->published;
		});
	}

	if ($showRating)
	{
		$vote = $ratingModel->getVoteByProduct($product->virtuemart_product_id);
	}

	$max_rating = VmConfig::get('vm_maximum_rating_scale', 5);
	?>

    <?php if (empty($product->rating)) 
	{ ?>
        <!--<div><?php echo vmText::_("COM_VIRTUEMART_UNRATED"); ?></div>-->
	<?php
    } else 
	{
		$rating_width = ($product->rating * 100) / $max_rating;
		$rating_text = round($product->rating) . '/' . $max_rating;
		//star-half-o | star-o | star
		?>
        <div class="uk-text-left vm-rating vm-rating-category">
            <span class="uk-position-relative uk-display-inline-block">
            	<span class="uk-text-muted"><?php for($i = 0; $i < $max_rating; $i++) { ?><i class="uk-icon-star-o"></i><?php } ?></span>
            	<span style="width: <?php echo $rating_width;?>%; overflow:hidden;" class="uk-text-nowrap uk-position-absolute uk-position-top-left uk-text-warning"><?php for($i = 0; $i < $max_rating; $i++) { ?><i class="uk-icon-star"></i><?php } ?></span>
            </span>
            <?php if($showReview)
            { ?>
	            <span class="uk-text-primary vm-review-comments uk-margin-small-left">
	            	<?php echo count($rating_reviews);?> <i class="uk-icon-comments"></i>
	            </span>
            <?php
            } ?>
        </div>

        <div class="uk-hidden uk-progress uk-progress-warning <?php echo $width;?>" title="<?php echo (vmText::_("COM_VIRTUEMART_RATING_TITLE") . $rating_text) ?>" data-uk-tooltip>
    		<div class="uk-progress-bar" style="width: <?php echo $rating_width;?>%;"><span class="uk-hidden"><?php echo vmText::_("COM_VIRTUEMART_RATING_TITLE");?></span><?php echo $rating_text;?></div>
		</div>
	<?php
	} ?>
<?php
} ?>