<?php

$product = $viewData['product'];

// Availability
$stockhandle 			= VmConfig::get('stockhandle_products', false) && $product->product_stockhandle ? $product->product_stockhandle : VmConfig::get('stockhandle','none'); // none - disableit - disableit_children - checked - risetime
$product_available_date = substr($product->product_available_date, 0, 10);
$current_date 			= date("Y-m-d");
?>

<?php if (($product->product_in_stock - $product->product_ordered) < 1) 
{?>

	<?php if ($product_available_date != '0000-00-00' and $current_date < $product_available_date)
	{ ?>
    	
		<div class="uk-margin-small availability">
            <div class="product-fields-title-wrapper uk-display-inline-block">
                <span class="product-fields-title uk-text-bold"><?php echo vmText::_('COM_VIRTUEMART_PRODUCT_AVAILABLE_DATE') ?>: </span>
            </div>
            <div class="product-field-display uk-display-inline-block"><?php echo JHtml::_('date', $product->product_available_date, vmText::_('DATE_FORMAT_LC4')); ?></div>
		</div>

	<?php
	} else if ($stockhandle == 'risetime' && VmConfig::get('rised_availability') && empty($product->product_availability))
	{
		$availability_path = VmConfig::get('assets_general_path') . 'images/availability/';
		?>
    	<div class="availability">
			<?php if(file_exists(JPATH_BASE . DS . $availability_path . VmConfig::get('rised_availability')))
			{ ?>
				<?php echo JHtml::image(JURI::root() . $availability_path . VmConfig::get('rised_availability', '7d.gif'), VmConfig::get('rised_availability', '7d.gif'), array('class' => 'availability')); ?>
			<?php 
			}else
			{ ?>
				<?php echo vmText::_(VmConfig::get('rised_availability')); ?>
			<?php
            }?>
		</div>
	<?php
	}else if(!empty($product->product_availability))
	{
		$availability_path = VmConfig::get('assets_general_path') . 'images/availability/';
		?>
		<div class="availability">
			<?php if(file_exists(JPATH_BASE . DS . $availability_path . $product->product_availability))
			{ ?>
				<?php echo JHtml::image(JURI::root() . $availability_path . $product->product_availability, $product->product_availability, array('class' => 'availability')); ?>
			<?php
            }else
			{ ?>
				<?php echo vmText::_($product->product_availability); ?>
            <?php
            }?>
		</div>
    <?php
	}?>

<?php
} ?>