<?php
/**
 *
 * Modify user form view, User info
 *
 * @package	VirtueMart
 * @subpackage User
 * @author Oscar van Eijk
 * @link http://www.virtuemart.net
 * @copyright Copyright (c) 2004 - 2010 VirtueMart Team. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 * VirtueMart is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * @version $Id: edit_vmshopper.php 8951 2015-08-19 09:41:44Z Milbo $
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');

?>

<fieldset>
	<legend class="userfields_info"><?php echo vmText::_('COM_VIRTUEMART_SHOPPER_FORM_LBL') ?></legend>
</fieldset>

<div class="adminForm user-details uk-form-row">
	<?php if(Vmconfig::get('multix','none')!=='none')
    { ?>
        <div class="uk-form-row">
            <label class="uk-form-label" for="virtuemart_vendor_id"><?php echo vmText::_('COM_VIRTUEMART_PRODUCT_FORM_VENDOR') ?>:</label>
            <div class="uk-form-controls"><?php echo $this->lists['vendors']; ?></div>
        </div>
    <?php
    } ?>
    
    <div class="uk-form-row">
        <label class="uk-form-label" for="customer_number"><?php echo vmText::_('COM_VIRTUEMART_USER_FORM_CUSTOMER_NUMBER') ?>:</label>
        <div class="uk-form-controls">
			<?php if(vmAccess::manager('user.edit'))
			{ ?>
				<input type="text" class="inputbox" name="customer_number" id="customer_number" size="40" value="<?php echo  $this->lists['custnumber'];?>" />
			<?php
            }
			else
			{ ?>
				<?php echo $this->lists['custnumber']; ?>
			<?php
            } ?>
        </div>
    </div>
    
    <?php if($this->lists['shoppergroups'])
     { ?>
        <div class="uk-form-row">
            <label class="uk-form-label" for="virtuemart_shoppergroup_id"><?php echo vmText::_('COM_VIRTUEMART_SHOPPER_FORM_GROUP') ?>:</label>
            <div class="uk-form-controls"><?php echo $this->lists['shoppergroups']; ?></div>
        </div>
    <?php
    } ?>
	
</div>