<?php
/**
*
* Layout for the login
*
* @package	VirtueMart
* @subpackage User
* @author Max Milbers, George Kostopoulos
*
* @link http://www.virtuemart.net
* @copyright Copyright (c) 2004 - 2010 VirtueMart Team. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
* VirtueMart is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* @version $Id: cart.php 4431 2011-10-17 grtrustme $
*/

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');

//set variables, usually set by shopfunctionsf::getLoginForm in case this layout is differently used
if (!isset( $this->show )) $this->show = TRUE;
if (!isset( $this->from_cart )) $this->from_cart = FALSE;
if (!isset( $this->order )) $this->order = FALSE ;


if (empty($this->url)){
	$url = vmURI::getCleanUrl();
} else{
	$url = $this->url;
}

$user = JFactory::getUser();
?>

<?php if ($this->show and $user->id == 0  ) 
{
	JHtml::_('behavior.formvalidation');

	//Extra login stuff, systems like openId and plugins HERE
	if (JPluginHelper::isEnabled('authentication', 'openid')) 
	{
		$lang = JFactory::getLanguage();
		$lang->load('plg_authentication_openid', JPATH_ADMINISTRATOR);
		$langScript = '
			//<![CDATA[
				'.'var JLanguage = {};' .
				' JLanguage.WHAT_IS_OPENID = \'' . vmText::_('WHAT_IS_OPENID') . '\';' .
				' JLanguage.LOGIN_WITH_OPENID = \'' . vmText::_('LOGIN_WITH_OPENID') . '\';' .
				' JLanguage.NORMAL_LOGIN = \'' . vmText::_('NORMAL_LOGIN') . '\';' .
				' var comlogin = 1;
			//]]>
		';
		vmJsApi::addJScript('login_openid',$langScript);
		JHtml::_('script', 'openid.js');
	}
	
	$html = '';
	JPluginHelper::importPlugin('vmpayment');
	$dispatcher = JDispatcher::getInstance();
	$returnValues = $dispatcher->trigger('plgVmDisplayLogin', array($this, &$html, $this->from_cart));
	
	if (is_array($html)) 
	{
		foreach ($html as $login) 
		{
			echo $login.'<br />';
		}
	}
	else 
	{
		echo $html;
	}
	
	//end plugins section
	
	//anonymous order section
	if ($this->order  ) 
	{ ?>
		<div class="order-view">
	
			<div class="uk-panel">
                <h3 class="uk-panel-title"><span><?php echo vmText::_('COM_VIRTUEMART_ORDER_ANONYMOUS') ?></span></h3>
        
                <form class="uk-form" action="<?php echo JRoute::_( 'index.php', 1, $this->useSSL); ?>" method="post" name="com-login" >
        
                    <div class="uk-form-row" id="com-form-order-number">
                        <label class="uk-form-label" for="order_number"><?php echo vmText::_('COM_VIRTUEMART_ORDER_NUMBER') ?></label>
                        <div class="uk-form-controls">
                            <div class="uk-form-icon uk-width-small-1-4">
                                <i class="uk-icon-clipboard "></i>
                                <input type="text" id="order_number" name="order_number" class="inputbox uk-width-1-1" size="18" />
                            </div>
                        </div>
                    </div>
                    
                    <div class="uk-form-row" id="com-form-order-pass">
                        <label class="uk-form-label" for="order_pass"><?php echo vmText::_('COM_VIRTUEMART_ORDER_PASS') ?></label>
                        <div class="uk-form-controls">
                            <div class="uk-form-icon uk-width-small-1-4">
                                <i class="uk-icon-clipboard "></i>
                                <input type="text" id="order_pass" name="order_pass" class="inputbox uk-width-1-1" size="18" value="p_"/>
                            </div>
                        </div>
                    </div>
                    
                    <div class="uk-form-row" id="com-form-order-submit">
                        <button type="submit" name="Submitbuton" class="uk-button uk-button-primary" title="<?php echo vmText::_('COM_VIRTUEMART_ORDER_BUTTON_VIEW') ?>" ><?php echo vmText::_('COM_VIRTUEMART_ORDER_BUTTON_VIEW') ?></button>
                    </div>
                    
                    <input type="hidden" name="option" value="com_virtuemart" />
                    <input type="hidden" name="view" value="orders" />
                    <input type="hidden" name="layout" value="details" />
                    <input type="hidden" name="return" value="" />
        
                </form>
            </div>
	
		</div>
	
	<?php
	} ?>
	
	
	<?php // XXX style CSS id com-form-login ?>
	<hr />
    <div>
        <div class="uk-panel">
			<?php if (!$this->from_cart ) 
        	{ ?>
        		<h3 class="uk-panel-title"><span><?php echo vmText::_('COM_VIRTUEMART_ORDER_CONNECT_FORM'); ?></span></h3>
            <?php 
            } else 
            { ?>
            	<h3 class="uk-panel-title"><span><?php echo vmText::_('COM_VIRTUEMART_ORDER_CONNECT_FORM'); ?></span></h3>
            <?php
            }?>
            
            <form id="com-form-login" class="uk-form" action="<?php echo $url; ?>" method="post" name="com-login" >
                
                <div class="uk-form-row">
                    <div class="uk-form-controls">
                        <div class="uk-form-icon uk-width-small-1-4">
                            <i class="uk-icon-user "></i>
                            <input type="text" name="username" class="inputbox uk-width-1-1" size="18" alt="<?php echo vmText::_('COM_VIRTUEMART_USERNAME'); ?>" placeholder="<?php echo vmText::_('COM_VIRTUEMART_USERNAME'); ?>" />
                        </div>
                        <div><a href="<?php echo JRoute::_('index.php?option=com_users&view=remind'); ?>" rel="nofollow"><?php echo vmText::_('COM_VIRTUEMART_ORDER_FORGOT_YOUR_USERNAME'); ?></a></div>
                    </div>
                </div>
                
                <div class="uk-form-row">
                    <div class="uk-form-controls">
                        <div class="uk-form-icon uk-width-small-1-4">
                            <i class="uk-icon-lock "></i>
                            <input id="modlgn-passwd" type="password" name="password" class="inputbox uk-width-1-1" size="18" alt="<?php echo vmText::_('COM_VIRTUEMART_PASSWORD'); ?>" placeholder="<?php echo vmText::_('COM_VIRTUEMART_PASSWORD'); ?>"  />
                        </div>
                        <div><a href="<?php echo JRoute::_('index.php?option=com_users&view=reset'); ?>" rel="nofollow"><?php echo vmText::_('COM_VIRTUEMART_ORDER_FORGOT_YOUR_PASSWORD'); ?></a></div>
                    </div>
                </div>
                
				<?php if (JPluginHelper::isEnabled('system', 'remember')) : ?>
                <div class="uk-form-row" id="com-form-login-remember">
                    <div class="uk-form-controls">
                    	<label for="remember"><?php echo $remember_me = vmText::_('JGLOBAL_REMEMBER_ME') ?></label>
                    	<input type="checkbox" id="remember" name="remember" class="inputbox" value="yes" alt="Remember Me" />
                    </div>
                </div>
                <?php endif; ?>

                <div class="uk-form-row">
                    <button type="submit" name="Submit" class="uk-button uk-button-primary" ><?php echo vmText::_('COM_VIRTUEMART_LOGIN') ?></button>
                </div>
                                  
                <input type="hidden" name="task" value="user.login" />
                <input type="hidden" name="option" value="com_users" />
                <input type="hidden" name="return" value="<?php echo base64_encode($url) ?>" />
                <?php echo JHtml::_('form.token'); ?>
            </form>
        </div>
    </div>

<?php 
} else if ( $user->id ) 
{ ?>
	<hr />
	<div>
        <form action="<?php echo JRoute::_('index.php'); ?>" method="post" name="login" id="form-login">
            <?php echo vmText::sprintf( 'COM_VIRTUEMART_HINAME', $user->name ); ?>
            <button type="submit" name="Submit" class="uk-button uk-button-primary" ><?php echo vmText::_( 'COM_VIRTUEMART_BUTTON_LOGOUT'); ?></button>
            <input type="hidden" name="option" value="com_users" />
            <input type="hidden" name="task" value="user.logout" />
            <?php echo JHtml::_('form.token'); ?>
            <input type="hidden" name="return" value="<?php echo base64_encode($url) ?>" />
        </form>
    </div>

<?php 
} ?>

