<?php
/**
*
* Description
*
* @package	VirtueMart
* @subpackage
* @author
* @link http://www.virtuemart.net
* @copyright Copyright (c) 2004 - 2010 VirtueMart Team. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
* VirtueMart is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* @version $Id: default.php 8507 2014-10-22 16:09:24Z Milbo $
*/

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');

vmJsApi::removeJScript('jquery-ui.min');
vmJsApi::removeJScript('jquery.ui.autocomplete.html');
vmJsApi::removeJScript('jquery.noconflict');
vmJsApi::removeJScript('fancybox/jquery.fancybox-1.3.4.pack');
?>
<div class="vendor-store-view">

	<?php echo $this->add_product_link; ?>

	<?php # Vendor Store Description
    if (!empty($this->vendor->vendor_store_desc) and VmConfig::get('show_store_desc', 1)) 
    { ?>
        <div><?php echo $this->vendor->vendor_store_desc; ?></div>
    <?php 
    } ?>
    
    <?php
    # load categories from front_categories if exist
    if ($this->categories and VmConfig::get('show_categories', 1))
    {
		$params_categories = array();
        $params_categories['categories'] 		= $this->categories;
		$params_categories['columns'] 			= 1;
		$params_categories['columns_small'] 	= 0;
		$params_categories['columns_medium'] 	= VmConfig::get ( 'categories_per_row', 3 );
		$params_categories['columns_large'] 	= 0;
		$params_categories['columns_xlarge'] 	= 0;
		?>
        <div class="uk-grid uk-grid-width-1-1">
        	<div>
                <div class="uk-panel">
                    <?php echo $this->renderVmSubLayout('categories', $params_categories); ?>
                </div>
            </div>
        </div>
    <?php
    }?>
    
    <?php
    # Show template for : topten, Featured, Latest Products if selected in config BE
    if (!empty($this->products) ) 
    {
		$params_products = array();
		$params_products['currency'] 				= $this->currency;
		$params_products['columns'] 				= 1;
		$params_products['columns_small'] 			= 0;
		$params_products['columns_medium'] 			= VmConfig::get ( 'homepage_products_per_row', 3 );
		$params_products['columns_large'] 			= 0;
		$params_products['columns_xlarge'] 			= 0;
		$params_products['show_rating'] 			= false; //$this->showRating;
		$params_products['show_stock'] 				= true;
		$params_products['show_short_description']	= true;
		$params_products['show_sku']				= true;
		$params_products['show_prices'] 			= true;
		$params_products['show_offer'] 				= false;
		$params_products['show_addtocart'] 			= true;
		$params_products['show_readmore'] 			= false;
		$params_products['show_badge_sold'] 		= true;
		$params_products['show_badge_new'] 			= true;
		$params_products['show_badge_promo'] 		= true;
		$params_products['show_badge_sale'] 		= true;
        ?>
        <div class="uk-grid uk-grid-width-1-1" data-uk-grid-margin>
			<?php foreach ($this->products as $type => $products ) 
            {?>
                <?php if(!empty($type) and count($products) > 0)
                {
                    $productTitle = vmText::_('COM_VIRTUEMART_'.strtoupper($type).'_PRODUCT');
                    $params_products['products'] = $products;
                    ?>
                    <div>
                        <div class="uk-panel uk-panel-header <?php echo $type ?>-view uk-margin">
                        
                            <h3 class="uk-panel-title"><span><?php echo $productTitle ?></span></h3>
                            
                            <?php echo shopFunctionsF::renderVmSubLayout($this->productsLayout, $params_products); ?>
                        </div>
                    </div>
                <?php
                }?>
            <?php
            }?>
        </div>
    <?php
	}?>

</div>

