<?php 
/**
 * Favorites Template Page for Favorites Component
 * 
 * @package    Favorites & Wishlist
 * @subpackage com_wishlist
 * @license  GNU/GPL v2
 * @copyright Copyright (C) 2013 2KWeb Solutions. All rights reserved.
 * This program is distributed under the terms of the GNU General Public License
 *
 */
 
//Load the com_favorite language file
$language = JFactory::getLanguage();
$language_tag = $language->getTag();
JFactory::getLanguage()->load('com_wishlist', JPATH_SITE, $language_tag, true);

//Loading Template Options
$fav_params 			= JComponentHelper::getParams( 'com_wishlist' );
$tmpl_favlist_style 	= $fav_params->get('tmpl_favlist_style');
$tmpl_favbtn_image 		= $fav_params->get('tmpl_favbtn_image');
$notorderable_enabled 	= $fav_params->get('tmpl_notorderable_enabled');
$qty_enabled 			= $fav_params->get('tmpl_qty_enabled');
$guest_enabled			= $fav_params->get('tmpl_guest_enabled');
$likestats_enabled 		= $fav_params->get('tmpl_favstat_enabled');
$favorites_maxnum 		= $fav_params->get('tmpl_favorites_maxnum');

/* FAVORITES & WISHLIST ENTRY */
if(!isset($_COOKIE['virtuemart_wish_session']))
{
	$session = JFactory::getSession();
	setcookie('virtuemart_wish_session', $session->getId(), 2592000 + time(), '/');
}

$db 		= JFactory::getDBO();
$view 		= JRequest::getString('view',  "");
$itemid 	= JRequest::getInt('Itemid',  1);
$user 		= JFactory::getUser();
$user_id 	= $user->guest ? $_COOKIE['virtuemart_wish_session'] : $user->id;

if ($view == "productdetails")
{
	$product = $this->product;
}

$product_id 		= $product->virtuemart_product_id;
$category_id 		= $product->virtuemart_category_id;
$product_orderable 	= $product->orderable;

if($product_orderable || $notorderable_enabled) 
{
	$favorite_id 	= JRequest::getInt('favorite_id',  1);
	$quantity 		= JRequest::getInt('quantity',  1);
	$mode 			= JRequest::getString('mode',  "null");
	$q 				= "SELECT COUNT(*) FROM #__virtuemart_favorites WHERE product_id=".$product_id;
	
	$db->setQuery($q);
	$total_fav = $db->loadResult();
	$q = "SELECT COUNT(*) FROM #__virtuemart_favorites WHERE user_id ='".$user_id."' AND product_id=".$product_id;
	$db->setQuery($q);
	$result = $db->loadResult();
	
	//$query_string 	= http_build_query(JRequest::get( 'get' ));
	$query_string 	= JURI::getInstance()->toString(); //echo 'index.php?'.JURI::getInstance()->buildQuery(JSite::getRouter()->parse(JURI::getInstance()));
	$url_fav 		= JRoute::_( str_replace('&tmpl=component', '', $query_string) );
	$url_favlist 	= JRoute::_("index.php?option=com_wishlist&view=favoriteslist&Itemid=".$itemid);
	
	if($view == 'favoriteslist') $url_fav = $url_favlist;
	
	$addtofavorites = '';
	$max_fav = null;

	//generate button to remove from favorites list
	$form_deletefavorite_array = array();
	$form_deletefavorite_array[] = '<form class="uk-form" action="'.$url_fav.'" method="POST" name="deletefavo" id="'. uniqid('deletefavo_') .'">';
		$form_deletefavorite_array[] = '<button class="uk-button uk-button-danger" title="'.JText::_('VM_REMOVE_FAVORITE').'" >';
			$form_deletefavorite_array[] = '<i class="uk-icon-trash"></i>';
			$form_deletefavorite_array[] = JText::_('VM_REMOVE_FAVORITE');
		$form_deletefavorite_array[] = '</button>';
		
		if($view == 'favoriteslist'){
			$form_deletefavorite_array[] = '<input type="hidden" name="mode" value="delete" />';
		}else{
			$form_deletefavorite_array[] = '<input type="hidden" name="mode" value="fav_del" />';
		}
		
		$form_deletefavorite_array[] = '<input type="hidden" name="favorite_id" value="'. $product_id .'" />';
		$form_deletefavorite_array[] = '<input type="hidden" name="fav_id" value="'.$product_id.'" />';
		$form_deletefavorite_array[] = '<input type="hidden" name="prod_name" value="'.$product->product_name.'" />';
	$form_deletefavorite_array[] = '</form>'; 
	
	$form_deletefavorite = implode("\n", $form_deletefavorite_array);
		
	if ($result > 0 )
	{
		$total_fav --;
		if ($product_id == $favorite_id && $mode == "fav_del")
		{
			$Sql = "DELETE FROM #__virtuemart_favorites ";
			$Sql.= "WHERE product_id='$product_id' AND user_id='$user_id'";
			$db->setQuery($Sql);
			$db->query();
			$result = 0;
			JError::raiseNotice( 100, JText::_('VM_FAVORITE_REMOVED'));
		}
		else
		{
			if ($tmpl_favlist_style == "button"){
				$addtofavorites .= $form_deletefavorite;
			}
		}
	}
	
	if ($result == 0)
	{
		if($product_id == $favorite_id && $mode == "fav_add") 
		{
			if ($favorites_maxnum != '')
			{
				$Sql = "SELECT COUNT(*) FROM #__virtuemart_favorites where user_id='$user_id'";
				$db->setQuery($Sql);
				$max_fav = $db->loadResult();
			}
			
			if ($max_fav != null && $max_fav >= $favorites_maxnum) 
			{
				JError::raiseNotice( 100, JText::_('VM_FAVORITE_MAXNUM'));
				//$addtofavorites .= '<a href="'.$url_favlist.'">'.JText::_('VM_MANAGE_FAVORITE_PRODUCTS').'</a>';
			}
			else
			{
				$Sql = "INSERT INTO #__virtuemart_favorites ";
				$Sql.= "SET product_id='$product_id', product_qty='$quantity', user_id='$user_id', fav_date=NOW(), isGuest=".$user->guest;
				$db->setQuery($Sql);
				$db->query();
				JFactory::getApplication()->enqueueMessage(JText::_('VM_FAVORITE_ADDED'));
				
				if ($tmpl_favlist_style == "button"){
					$addtofavorites .= $form_deletefavorite;
				}
				
			}
		} 
		else 
		{
			if ($guest_enabled || !$user->guest)
			{
				$addtofavorites .= '<form class="uk-form" method="post" action="'.$url_fav.'" name="addtofavorites" id="addtofavorites_'.$product_id.'">';
				
					if ($qty_enabled){
						$addtofavorites .= '<input type="hidden" id="quantity_'.$product_id.'" class="quantity-input" value="1" name="quantity">';
					}
					
					$addtofavorites .= '<button class=';
						
						if ($tmpl_favlist_style == "button"){
							$addtofavorites .= '"uk-button uk-button-success addtofavorites-button"';
						}
												
						$addtofavorites .= 'name="addtofavorites" title="'.JText::_('VM_ADD_TO_FAVORITES').'" >';
					
						if ($tmpl_favlist_style == "button") 
						{
							$addtofavorites .= '<i class="uk-icon-star"></i> ';
							$addtofavorites .= JText::_('VM_ADD_TO_FAVORITES');
						}
						
					$addtofavorites .= '</button>';
					$addtofavorites .= '<input type="hidden" name="favorite_id" value="'.$product_id.'" />';
					$addtofavorites .= '<input type="hidden" name="mode" value="fav_add" />';
					
				$addtofavorites .= '</form>'; 
			}
		}
	}
	
	if ($total_fav > 0 && $likestats_enabled){
		$addtofavorites .= '<div class="uk-clearfix vm-fav-total-likes">'.JText::_('VM_FAV_TOTAL_LIKES').'<b>'.$total_fav.'</b>'.JText::_('VM_FAV_MORE_PEOPLE').'</div>';
	}
	
	echo $addtofavorites;
}
?>