<?php
/**
* @package   yoo_master2
* @author    YOOtheme http://www.yootheme.com
* @copyright Copyright (C) YOOtheme GmbH
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

$my_page 	= JFactory::getDocument();
$conf 		= JFactory::getConfig();
$user 		= JFactory::getUser();

$my_page->setTitle(JText::_( 'VM_FAVORITE_LIST' ));

$itemid 	= JRequest::getInt('Itemid',  1);
$prod_name 	= JRequest::getString('prod_name',  "");
$mode 		= JRequest::getString('mode',  "");

vmJsApi::jQuery();
vmJsApi::jPrice();
vmJsApi::cssSite();

?>
<div class="fav">
    <h1 class="uk-article-title"><span><?php echo JText::_( 'VM_FAVORITE_LIST' ); ?></span></h1>
    
    <?php if ($prod_name != "" && $mode == "delete") 
    {
        JError::raiseNotice( 100, JText::_('VM_DELETED_TITLE').'<strong> '.$prod_name.' </strong>'.JText::_('VM_DELETED_TITLE2'));
    } ?>
    
    <?php if (empty( $this->data ))
    { ?>
    	<div class="uk-alert uk-alert-danger">
		    <p class="fav_header"><?php echo JText::_('VM_FAVORITE_EMPTY') ?></p>
		</div>
    <?php
    }else
    {
        //Loading Global Options
        $params = JComponentHelper::getParams('com_wishlist');
        $tmpl_favbtn_image 		= $params->get('tmpl_favbtn_image');
        $tmpl_favdate_enabled 	= $params->get('tmpl_favdate_enabled');
        $tmpl_afaq_enabled 		= $params->get('tmpl_afaq_enabled', 0);
        $tmpl_favimage_width 	= $params->get('tmpl_favimage_width');
        
        //Initialize the Virtuemart Product Model Class
        $productModel = new VirtueMartModelProduct();
		
		$afaq_message 			= JText::_('VM_AFAQ_MESSAGE');
		$tmpl_favdate_enabled 	= false;
		$url_favlist 			= JRoute::_("index.php?option=com_wishlist&view=favoriteslist&Itemid={$itemid}");
		$infinite_pagination 	= 'data-uk-infinite-pagination="{lblLoading:\'cargando\', lblLoad:\'cargar más\', finishedMsg: \'No hay más páginas para cargar\', enabledScroll: true}" data-uk-observe=""';
		$products 				= array();
		
		foreach ($this->data as $dataItem) 
        {
			$product = $productModel->getProduct($dataItem->product_id);
			$productModel->addImages($product);
			
			$products[] = $product; // add product to list
			
			// for ask faq mail
			$product_qty = $dataItem->product_qty;
			$product_ord = $product_qty > 0 ? $product_qty : 1;
			$afaq_message .= $product_ord.'x <b>'.$product->product_name.'</b>, <br />';
			
		}
		
		$params_products = array();
		$params_products['currency'] 				= CurrencyDisplay::getInstance( );
		$params_products['products'] 				= $products;
		$params_products['columns'] 				= 0;
		$params_products['columns_small'] 			= 2;
		$params_products['columns_medium'] 			= 3;
		$params_products['columns_large'] 			= VmConfig::get ( 'products_per_row', 3 );
		$params_products['columns_xlarge'] 			= 0;
		$params_products['show_rating'] 			= false; //$this->showRating;
		$params_products['show_stock'] 				= false;
		$params_products['show_short_description']	= true;
		$params_products['show_sku']				= false;
		$params_products['show_prices'] 			= true;
		$params_products['show_offer'] 				= false;
		$params_products['show_addtocart'] 			= false;
		$params_products['show_readmore'] 			= false;
		$params_products['show_badge_sold'] 		= false;
		$params_products['show_badge_new'] 			= false;
		$params_products['show_badge_promo'] 		= false;
		$params_products['show_badge_sale'] 		= false;
		$params_products['show_addtofavorite'] 		= false;
		?>
																				
		<?php if($this->pagination->get('pages.total') > 1)
		{ ?>
			<div class="vm-pagination vm-pagination-top uk-margin uk-hidden">
				<?php echo $this->pagination->getPagesLinks(); ?>
			</div>
		<?php
		}?>
		
		<div class="uk-margin">
			<div class="vm-content-list" <?php echo $infinite_pagination;?>>
				<div class="uk-panel uk-panel-box">
					<!--<h3 class="uk-panel-title">Productos</h3>-->
					<?php echo shopFunctionsF::renderVmSubLayout('products', $params_products); ?>
				</div>
			</div>
		</div>
		
		
		<?php if($this->pagination->get('pages.total') > 1)
		{ ?>
			<div class="vm-pagination vm-pagination-bottom uk-margin uk-hidden">
				<?php echo $this->pagination->getPagesLinks(); ?>
			</div>
		<?php
		}?>
                
		<?php
        //Ask for a Quote Form
        if (!$user->guest && $tmpl_afaq_enabled)
        { ?>
        	<hr />
	       	<div class="afaq">
                <form action="<?php echo $url_favlist;?>" method="POST" name="sendmail" id="sendmail">
                    <input type="hidden" name="mode" value="sendmail" />
                    <input type="hidden" id="email_to" name="email_to" value="<?php echo $conf->get('mailfrom');?>" />
                    <input type="hidden" id="email_subj" name="email_subj" value="<?php echo JText::_('VM_AFAQ_SUBJECT');?>" />
                    <input type="hidden" id="email_body" name="email_body" value="<?php echo $afaq_message;?>" />
                    <input type="submit" class="uk-button uk-button-primary modns button art-button art-button" value="<?php echo JText::_('VM_AFAQ_BUTTON');?>" title="<?php echo JText::_('VM_AFAQ_BUTTON');?>" />
                </form>
      		</div>
        <?php
        }?>
    <?php
    } ?>
</div>
