<?php
/**
* @package   yoo_master2
* @author    YOOtheme http://www.yootheme.com
* @copyright Copyright (C) YOOtheme GmbH
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

defined('_JEXEC') or die('Restricted access');

$my_page 	= JFactory::getDocument();
$conf 		= JFactory::getConfig();
$option 	= JRequest::getString('option',  "");
$view 		= JRequest::getString('view',  "");
$user_id 	= JRequest::getInt('user_id');
$itemid 	= JRequest::getInt('Itemid', 1);

vmJsApi::jQuery();
vmJsApi::jPrice();
vmJsApi::cssSite();
?>

<?php if (empty( $this->data ))
{ ?>
	<div class="uk-alert uk-alert-danger">
        <h2 class="fav_title"><?php echo JText::_( 'VM_SHARELIST_ERROR' ); ?></h2>
        <p class="fav_header"><?php echo JText::_('VM_SHARELIST_DENY') ?></p>
    </div>
<?php
}else
{ 
	//Loading Global Options
	$params 				= JComponentHelper::getParams( 'com_wishlist' );
	$tmpl_favdate_enabled 	= $params->get( 'tmpl_favdate_enabled' );
	$tmpl_favimage_width 	= $params->get( 'tmpl_favimage_width' );
	$hdr_data 				= $this->data[0];
	$share_pass 			= JRequest::getString('share_pass',  "");
	$form_link 				= JRoute::_('index.php?option='.$option.'&view='.$view.'&user_id='.$user_id.'&Itemid='.$itemid);
	$form_share_link 		= JRoute::_('index.php?option='.$option.'&view='.$view.'&user_id='.$user_id.'&Itemid='.$itemid, true, -1);
	$social = false;
	?>
	
	<?php if ($hdr_data->share_pass == "" || $hdr_data->share_pass == md5($share_pass))
	{
		$uname 		= $hdr_data->name;
		$uid 		= $hdr_data->user_id;
		$shdate 	= $hdr_data->share_date;
		$shtitle 	= $hdr_data->share_title;
		$shdesc 	= $hdr_data->share_desc;
		$iswishlist = $hdr_data->isWishList;
		$uemail 	= JFactory::getUser($uid)->email;
		?>
        
        <h1 class="uk-article-title">
			<?php if (!$iswishlist) 
            {
				$my_page->setTitle(JText::sprintf('VM_FAVORITES', $uname).' | ' .$shtitle); 
				?>
                <span><?php echo JText::sprintf('VM_FAVORITES', $uname); ?></span>
            <?php
            }else 
            {
				$my_page->setTitle(JText::sprintf('VM_WISHLIST', $uname).' | ' .$shtitle);
				?>
                <span><?php echo JText::sprintf('VM_WISHLIST', $uname); ?></span>
            <?php
            }?>
		</h1>
        
        <h3 class="fav_header"><?php echo $shtitle;  ?></h3>
        
        <?php if($shdesc)
		{ ?>
	        <p><?php echo $shdesc;  ?></p>
        <?php
		}?>
        
        <hr />
        
		<?php 
        $productModel 			= new VirtueMartModelProduct();
		$tmpl_favdate_enabled 	= false;
		$url_favlist 			= JRoute::_("index.php?option=com_wishlist&view=favoriteslist&Itemid={$itemid}");
		$infinite_pagination 	= 'data-uk-infinite-pagination="{lblLoading:\'cargando\', lblLoad:\'cargar más\', finishedMsg: \'No hay más páginas para cargar\', enabledScroll: true}" data-uk-observe=""';
		$products 				= array();
		
		foreach ($this->data as $dataItem) 
        {
			$product = $productModel->getProduct($dataItem->product_id);
			$productModel->addImages($product);
			
			$products[] = $product; // add product to list
			
			$product_qty = $dataItem->product_qty;
			$product_ord = $product_qty > 0 ? $product_qty : 1;
			$addtocart_html = array();	
			$product_qty = 0;					
			
			
			if ($iswishlist && $product_qty == 0)
			{
				$addtocart_html[] = '<div class="uk-alert uk-alert-danger">'.JText::_('VM_WISHLIST_UNAVAILABLE').'</div>';
			}else if ($iswishlist && $product_qty > -1)
			{
				$addtocart_html[] = '<div class="uk-alert uk-hidden"><p><strong>'.JText::_('VM_WISHLIST_AVAILABLE').': </strong>'.sprintf($product_qty).'</p></div>';
				if ($iswishlist && $product_qty <> 0)
				{
					$addtocart_html[] = '<button type="submit" name="addtocart" class="addtocart-button uk-button uk-button-primary" title="'.vmText::_( 'VM_WISHLIST_GIFTIT' ).'">'.vmText::_( 'VM_WISHLIST_GIFTIT' ).'</button>';
				}
			}else if ($iswishlist && $product_qty <= -1)
			{
				$addtocart_html[] = '<div class="uk-alert uk-hidden"><p><strong>'.JText::_('VM_WISHLIST_AVAILABLE').': </strong>'.JText::_('VM_WISHLIST_UNLIMITED').'</p></div>';
				if ($iswishlist && $product_qty <> 0)
				{
					$addtocart_html[] = '<button type="submit" name="addtocart" class="addtocart-button uk-button uk-button-primary" title="'.vmText::_( 'VM_WISHLIST_GIFTIT' ).'">'.vmText::_( 'VM_WISHLIST_GIFTIT' ).'</button>';
				}
			}else
			{
				$addtocart_html[] = '<button type="submit" name="addtocart" class="addtocart-button uk-button uk-button-primary" title="'.vmText::_( 'VM_WISHLIST_GIFTIT' ).'">'.vmText::_( 'VM_WISHLIST_GIFTIT' ).'</button>';
			}
			
			
			
			
			/* Remove
			if ($tmpl_favdate_enabled)
			{
				$addtocart_html[] = '<p class="vm-product-date">'.JHtml::date($dataItem->fav_date, JText::_('DATE_FORMAT_LC4')).'</p>';
            }
			*/
			
			$product->addToCartButton = $addtocart_html = implode("\n", $addtocart_html);
			
		}
		
		$params_products = array();
		$params_products['currency'] 				= CurrencyDisplay::getInstance( );
		$params_products['products'] 				= $products;
		$params_products['columns'] 				= 0;
		$params_products['columns_small'] 			= 2;
		$params_products['columns_medium'] 			= 3;
		$params_products['columns_large'] 			= VmConfig::get ( 'products_per_row', 3 );
		$params_products['columns_xlarge'] 			= 0;
		$params_products['show_rating'] 			= false; //$this->showRating;
		$params_products['show_stock'] 				= false;
		$params_products['show_short_description']	= true;
		$params_products['show_sku']				= true;
		$params_products['show_prices'] 			= true;
		$params_products['show_offer'] 				= false;
		$params_products['show_addtocart'] 			= true;
		$params_products['show_readmore'] 			= false;
		$params_products['show_badge_sold'] 		= true;
		$params_products['show_badge_new'] 			= true;
		$params_products['show_badge_promo'] 		= true;
		$params_products['show_badge_sale'] 		= true;
		?>
        
        <?php if($this->pagination->get('pages.total') > 1)
		{ ?>
			<div class="vm-pagination vm-pagination-top uk-margin uk-hidden">
				<?php echo $this->pagination->getPagesLinks(); ?>
			</div>
		<?php
		}?>
		
		<div class="uk-margin">
			<div class="vm-content-list" <?php echo $infinite_pagination;?>>
				<div class="uk-panel uk-panel-header">
					<!--<h3 class="uk-panel-title"><span>Productos</span></h3>-->
					<?php echo shopFunctionsF::renderVmSubLayout('products', $params_products); ?>
				</div>
			</div>
		</div>
		
		
		<?php if($this->pagination->get('pages.total') > 1)
		{ ?>
			<div class="vm-pagination vm-pagination-bottom uk-margin uk-hidden">
				<?php echo $this->pagination->getPagesLinks(); ?>
			</div>
		<?php
		}?>
        
        <?php 
		/*
		<?php if ($iswishlist && $product_qty == 0)
		{ ?>
			<div class="uk-alert uk-alert-danger">
				<?php echo JText::_('VM_WISHLIST_UNAVAILABLE'); ?>
			</div>
		<?php
		}else if ($iswishlist && $product_qty > -1)
		{?>
			<div class="uk-alert uk-hidden">
				<p><strong><?php echo JText::_('VM_WISHLIST_AVAILABLE').": ";?></strong><?php echo sprintf($product_qty);?></p>
			</div>
			<?php if ($iswishlist && $product_qty <> 0)
			{ ?>
				<?php include( $warp['path']->path('layouts:com_virtuemart/addtocart.php') ); ?>
			<?php
			} ?>
		<?php
		}else if ($iswishlist && $product_qty <= -1)
		{ ?>
			<div class="uk-alert uk-hidden">
				<p><strong><?php echo JText::_('VM_WISHLIST_AVAILABLE').": ";?></strong><?php echo JText::_('VM_WISHLIST_UNLIMITED');?></p>
			</div>
			<?php if ($iswishlist && $product_qty <> 0)
			{ ?>
				<?php include( $warp['path']->path('layouts:com_virtuemart/addtocart.php') ); ?>
			<?php
			} ?>
		<?php
		}else
		{ ?>
			<?php include( $warp['path']->path('layouts:com_virtuemart/addtocart.php') ); ?>
		<?php
		} ?>
		*/ 
		?>
        
	<?php
	}else
	{ ?>
        <div class="uk-alert uk-alert-danger">
            <p class="fav_title"><?php echo JText::_( 'VM_PASSWORD_ACCESS' ); ?></p>
        </div>
		
		<form class="uk-form" action="<?php echo $form_link;?>" method="POST" name="share" id="share">
			<div class="uk-form-row">
    	        <label class="uk-form-label" for="share_pass"><?php echo JText::_('VM_PASSWORD_PROMPT') ?></label>
		        <div class="uk-form-controls"><input id="share_pass" type="password" class="inputbox uk-width-small-1-4" size="35" maxlength="32" name="share_pass" /></div>
                <?php if ($share_pass != "" && $hdr_data->share_pass != md5($share_pass))
				{ ?>
                	<div class="uk-text-danger"><?php echo JText::_( 'VM_PASSWORD_WRONG' );?></div>
                <?php
				} ?>
            </div>
            
            <div class="uk-form-row">
				<input type="hidden" name="option" value="<?php echo $option;?>" />
				<input type="hidden" name="user_id" value="<?php echo $user_id;?>" />
				<input type="hidden" name="view" value="<?php echo $view;?>" />
				<input type="hidden" name="Itemid" value="<?php echo $itemid;?>" />
                
                <button type="button" class="uk-button modns button art-button art-button addtocart_button" title="<?php echo JText::_( 'VM_SHARELIST_BACK' );?>" onclick="javascript:history.back()" >
                	<?php echo JText::_( 'VM_SHARELIST_BACK' );?>
                </button>
				<button type="submit" class="uk-button uk-button-primary modns button art-button art-button" title="<?php echo JText::_('VM_SHARE_BUTTON');?>">
                	<?php echo JText::_('VM_ACCESS_BUTTON');?>
                </button>
        	</div>
		</form>
		
	<?php
	} ?>
<?php
}?>


