<?php
/**
 * @package     Joomla.Site
 * @subpackage  mod_articles_category
 *
 * @copyright   Copyright (C) 2005 - 2014 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

jimport('siniestro.image_lib.image');
$width_class = array();
$width_class[] = 'uk-width-1-'.$params->get('num_cols', 1);
$show_thumb = $params->get('show_thumb', false);
?>
<div class="articles-category-module">
	<div class="scrollbar">
        <div class="uk-grid uk-grid-preserve" data-uk-grid-margin="">
            <?php foreach ($list as $item) 
            {
                $images = json_decode($item->images);
				
				$url = $warp['siniestro']->articleLink($item);
				$item->link = $url['link'];
				$item->url_attribs = $url['url_attribs'];
				
                $attribs = new JRegistry;
                $attribs->loadString($item->attribs);
                
                $panel_class = array('uk-panel tm-panel-articles-category');
                if($attribs->get('feature_article', 0)) $panel_class[] = 'tm-panel-articles-category-active';
                                
                ?>
                <div class="<?php echo implode(" ", $width_class);?>">
                    <div class="<?php echo implode(" ", $panel_class);?>">
                        <?php if (isset($images->image_intro) and !empty($images->image_intro) && $show_thumb )
                        {
                            $srcImg =  SiniestroImage::createThumb( $images->image_intro ,'cache/images', 640, 480, 'crop-m');      	
                            $imgfloat = (empty($images->float_intro)) ? $params->get('float_intro', 'left') : $images->float_intro;
                            $imgAlt = ($images->image_intro_alt) ? htmlspecialchars($images->image_intro_alt) : '';
                            $imgAttribs['title'] = ($images->image_intro_caption) ? htmlspecialchars($images->image_intro_caption) : '';
                            $imgAttribs['class'] = 'uk-responsive-height';
                            $image = JHTML::_ ('image', htmlspecialchars($srcImg), $imgAlt, $imgAttribs, false, false);
                            ?>
                            <div class="uk-thumbnail uk-thumbnail-expand uk-text-center">
                                <a href="<?php echo $item->link; ?>" <?php echo $item->url_attribs; ?> title="<?php echo $item->title; ?>" class="uk-width-1-1 uk-height-1-1 uk-display-block uk-vertical-align">
                                    <?php echo $image; ?>
                                </a>
                            </div>
                        <?php
                        } ?>
                        
                        <div class="tm-article-wrapper">
                        
                            <?php if ($item->displayDate ) 
                            {?>
                                <div class="tm-article-date">
                                    <span class="tm-article-date-day"><?php echo JHtml::_('date', $item->created, JText::_('d'));?></span>
                                    <span class="tm-article-date-month"><?php echo JHtml::_('date', $item->created, JText::_('M'));?></span>
                                </div>
                            <?php 
                            } ?>
                            
                            <?php if($attribs->get('feature_article', 0))
                            { ?>
                                <div data-uk-tooltip title="Actividad Cooperación Sur Sur" class="tm-article-active-icon"></div>
                            <?php
                            }?>
                        
                            <h4 class="tm-title-teaser uk-margin-remove">
                                <?php if ($params->get('link_titles') == 1) 
                                {
                                    $displayHits = $item->displayHits ? '<span class="mod-articles-category-hits">('.$item->displayHits.')</span>' : '';
                                    ?>
                                    <a href="<?php echo $item->link; ?>" <?php echo $item->url_attribs; ?> title="<?php echo $item->title; ?>" class="mod-articles-category-title <?php echo $item->active;?>">
                                        <?php echo $item->title.$displayHits; ?>
                                    </a>
                                <?php 
                                } else 
                                {?>
                                    <?php echo $item->title.$displayHits; ?>
                                <?php 
                                } ?>
                            </h4>
                            
                            <?php if ( ($params->get('show_author') || $item->displayCategoryTitle) || $params->get('show_introtext') || $params->get('show_readmore') ) 
                            { ?>
                            <div class="tm-article-content uk-clearfix uk-margin">
                                                                                        
                                <?php if ($params->get('show_author') || $item->displayCategoryTitle ) 
                                {?>
                                    <p class="uk-article-meta">
                                        <?php if ($params->get('show_author'))
                                        {?>
                                            <span class="mod-articles-category-writtenby"><?php echo $item->displayAuthorName; ?></span>
                                        <?php 
                                        } ?>
                                        
                                        <?php if ($item->displayCategoryTitle)
                                        {?>
                                            <span class="mod-articles-category-category">(<?php echo $item->displayCategoryTitle; ?>)</span>
                                        <?php 
                                        } ?>
                                    </p>
                                <?php 
                                } ?>
                                
                                <?php if ($params->get('show_introtext'))
                                {?>
                                    <p class="mod-articles-category-introtext"><?php echo $item->displayIntrotext; ?></p>
                                <?php 
                                } ?>
                                
                                <?php if ($params->get('show_readmore')) 
                                {
                                    if ($item->params->get('access-view')== FALSE) 
                                    {
                                        $readmore_text = JText::_('MOD_ARTICLES_CATEGORY_REGISTER_TO_READ_MORE');
                                    }
                                    elseif ($readmore = $item->alternative_readmore) 
                                    {
                                        $readmore_text = $readmore . JHtml::_('string.truncate', $item->title, $params->get('readmore_limit'));
                                    }
                                    elseif ($params->get('show_readmore_title', 0) == 0) 
                                    {
                                        $readmore_text = JText::sprintf('MOD_ARTICLES_CATEGORY_READ_MORE_TITLE');
                                    }
                                    else
                                    {
                                        $readmore_text = JText::_('MOD_ARTICLES_CATEGORY_READ_MORE') . JHtml::_('string.truncate', $item->title, $params->get('readmore_limit'));
                                    } ?>
                                    
                                    <p class="tm-read-more">
                                        <a href="<?php echo $item->link; ?>" <?php echo $item->url_attribs; ?> title="<?php echo $item->title; ?>" >
                                            <?php echo $readmore_text;?>
                                        </a>
                                    </p>
                                <?php 
                                } ?>
                                
                            </div>
                            <?php
                            }?>
                        
                        </div>
                        
                    </div>
                    <hr class="uk-margin" />
                </div>
            <?php
            }?>
        </div>
    </div>
</div>