<?php
/**
 * @package		Joomla.Site
 * @subpackage	mod_articles_category
 * @copyright	Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

// no direct access
defined('_JEXEC') or die;

jimport('siniestro.image_lib.image');

$settings = array("animation" => "scroll", "duration" => 500, "height" => "315", "start" => 0, "autoplay" => true, "autoplayInterval" => 7000, "videoautoplay" => true, "videomute" => true, "slices" => 15);
$show_slidenav 	= $params->get('show_slidenav', false);
$show_dotnav 	= $params->get('show_dotnav', true);
$show_caption 	= $params->get('show_caption', true);
$show_thumb 	= $params->get('show_thumb', true);
$thumb_width 	= $params->get('thumb_width', 640);
$thumb_height 	= $params->get('thumb_height', 360);
$thumb_crop 	= $params->get('thumb_crop', 'crop-m');
?>

<div class="uk-slidenav-position" data-uk-slideshow='<?php echo json_encode($settings);?>'>
	
    <ul class="uk-slideshow">
		<?php foreach ($list as $item) 
        {
            $images = json_decode($item->images);
            $url = $warp['siniestro']->articleLink($item);
			$item->link = $url['link'];
			$item->url_attribs = $url['url_attribs'];
            ?>
			<li>
                <?php if (isset($images->image_intro) and !empty($images->image_intro) && $show_thumb )
				{
					$srcImg 				=  SiniestroImage::createThumb( $images->image_intro, 'cache/images', $thumb_width, $thumb_height, $thumb_crop);      	
					$imgfloat 				= (empty($images->float_intro)) ? $params->get('float_intro', 'left') : $images->float_intro;
					$imgAlt 				= ($images->image_intro_alt) ? htmlspecialchars($images->image_intro_alt) : '';
					$imgAttribs['title'] 	= ($images->image_intro_caption) ? htmlspecialchars($images->image_intro_caption) : '';
					$imgAttribs['class'] 	= '';
					$image 					= JHTML::_ ('image', htmlspecialchars($srcImg), $imgAlt, $imgAttribs, false, false);
					?>
					<?php echo $image; ?>
				<?php
				} ?>
                
                <a href="<?php echo $item->link; ?>" <?php echo $item->url_attribs; ?> title="<?php echo $item->title; ?>" class="uk-position-cover <?php echo $item->active;?>"></a>
				
                <?php if($show_caption)
				{ ?>
                    <div class="uk-overlay-panel uk-overlay-background uk-overlay-bottom uk-overlay-fade">
                        <h4 class="tm-title-teaser">
                            <?php if ($params->get('link_titles') == 1) 
                            {
                                $displayHits = $item->displayHits ? '<span class="mod-articles-category-hits">('.$item->displayHits.')</span>' : '';
                                ?>
                                <a href="<?php echo $item->link; ?>" <?php echo $item->url_attribs; ?> title="<?php echo $item->title; ?>" class="<?php echo $item->active;?>">
                                    <?php echo $item->title.$displayHits; ?>
                                </a>
                            <?php 
                            } else 
                            {?>
                                <?php echo $item->title.$displayHits; ?>
                            <?php 
                            } ?>
                        </h4>
                        
                        <?php if ( ($params->get('show_author') || $item->displayCategoryTitle || $item->displayDate) || $params->get('show_introtext') || $params->get('show_readmore') ) 
						{ ?>
                            <div class="tm-article-content uk-clearfix uk-margin">
                                
                                <?php if ($params->get('show_author') || $item->displayCategoryTitle || $item->displayDate ) 
                                {?>
                                    <p class="uk-article-meta">
                                        <?php if ($params->get('show_author'))
                                        {?>
                                            <span class="mod-articles-category-writtenby"><?php echo $item->displayAuthorName; ?></span>
                                        <?php 
                                        } ?>
                                        
                                        <?php if ($item->displayCategoryTitle)
                                        {?>
                                            <span class="mod-articles-category-category">(<?php echo $item->displayCategoryTitle; ?>)</span>
                                        <?php 
                                        } ?>
                                        
                                        <?php if ($item->displayDate) 
                                        {?>
                                            <span class="mod-articles-category-date"><?php echo $item->displayDate; ?></span>
                                        <?php 
                                        } ?>
                                    </p>
                                <?php 
                                } ?>
                                
                                <?php if ($params->get('show_introtext'))
                                {?>
                                    <p class="mod-articles-category-introtext"><?php echo $item->displayIntrotext; ?></p>
                                <?php 
                                } ?>
                                
                                <?php if ($params->get('show_readmore')) 
                                {
                                    if ($item->params->get('access-view')== FALSE) 
                                    {
                                        $readmore_text = JText::_('MOD_ARTICLES_CATEGORY_REGISTER_TO_READ_MORE');
                                    }
                                    elseif ($readmore = $item->alternative_readmore) 
                                    {
                                        $readmore_text = $readmore . JHtml::_('string.truncate', $item->title, $params->get('readmore_limit'));
                                    }
                                    elseif ($params->get('show_readmore_title', 0) == 0) 
                                    {
                                        $readmore_text = JText::sprintf('MOD_ARTICLES_CATEGORY_READ_MORE_TITLE');
                                    }
                                    else
                                    {
                                        $readmore_text = JText::_('MOD_ARTICLES_CATEGORY_READ_MORE') . JHtml::_('string.truncate', $item->title, $params->get('readmore_limit'));
                                    } ?>
                                    
                                    <div class="tm-read-more">
                                        <a href="<?php echo $item->link; ?>" <?php echo $item->url_attribs; ?> title="<?php echo $item->title; ?>" >
                                            <?php echo $readmore_text;?>
                                        </a>
                                    </div>
                                <?php 
                                } ?>
                                
                            </div>
                    	<?php
						}?>
                    </div>
                <?php
				}?>
			</li>
            
        <?php
        }?>
	</ul>

	<?php if($show_slidenav)
  	{ ?>
		<a href="#" class="uk-slidenav uk-slidenav-contrast uk-slidenav-previous" data-uk-slideshow-item="previous"></a>
		<a href="#" class="uk-slidenav uk-slidenav-contrast uk-slidenav-next" data-uk-slideshow-item="next"></a>
    <?php 
	}?>
  	
    <?php if($show_dotnav)
  	{ ?>
        <ul class="uk-dotnav uk-dotnav-contrast uk-position-bottom uk-flex-center">
          <?php foreach ($list as $key => $item) 
          { ?>
              <li data-uk-slideshow-item="<?php echo $key;?>"><a href="#"><span></span></a></li>
          <?php
          }?>
        </ul>
    <?php
	}?>

</div>
