<?php

/**

 * @package     Joomla.Site

 * @subpackage  mod_related_items

 *

 * @copyright   Copyright (C) 2005 - 2015 Open Source Matters, Inc. All rights reserved.

 * @license     GNU General Public License version 2 or later; see LICENSE.txt

 */



defined('_JEXEC') or die;



$com_path = JPATH_SITE . '/components/com_content/';

require_once $com_path . 'helpers/route.php';



JModelLegacy::addIncludePath($com_path . '/models', 'ContentModel');



jimport('siniestro.image_lib.image');



$show_thumb = $params->get('show_thumb', true);



$item_ids = array();

foreach ($list as $item) 

{

	$item_ids[] = $item->id;

}



$articles = JModelLegacy::getInstance('Articles', 'ContentModel', array('ignore_request' => true));

$articles->setState('filter.article_id', $item_ids);

$articles->setState('filter.article_id.include', true);

$articles->setState('params', JFactory::getApplication()->getParams());

$items = $articles->getItems();



?>

<div class="uk-grid tm-items-article tm-items-3-columns" data-uk-grid-match="{target:'> div > .uk-panel'}" data-uk-grid-margin>

	<?php foreach ($items as $item) 

    {

		$item_params = $item->params;

		$images  	= json_decode($item->images);

		$urls 		= json_decode($item->urls);

		$canEdit 	= $item->params->get('access-edit');

		JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');

		

		// template args

		$args = array(

			'permalink' => JRoute::_(ContentHelperRoute::getArticleRoute($item->alias, $item->catid), true, -1),

			'image' => isset($images->image_intro) ? htmlspecialchars($images->image_intro) : '',

			'image_alignment' => !isset($images->float_intro) || empty($images->float_intro) ? htmlspecialchars($item_params->get('float_intro')) : htmlspecialchars($images->float_intro),

			'image_alt' => isset($images->image_intro_alt) ? htmlspecialchars($images->image_intro_alt) : '',

			'image_caption' => isset($images->image_intro_caption) ? htmlspecialchars($images->image_intro_caption) : '',

			'title' => $item_params->get('show_title') ? $item->title : '',

			'title_link' => $item_params->get('link_titles'),

			'author' => '',

			'author_url' => !empty($item->contactid) && $item_params->get('link_author') == true ? JRoute::_('index.php?option=com_contact&view=contact&id='.$item->contactid) : '',

			'date' => $item_params->get('show_publish_date') ? $item->publish_up : '',

			'datetime' => substr($item->publish_up, 0, 10),

			'category' => $item_params->get('show_category') ? $this->escape($item->category_title) : '',

			'category_url' => $item_params->get('link_category') ? JRoute::_(ContentHelperRoute::getCategoryRoute($item->catid)) : '',

			'category_parent' => $item_params->get('show_parent_category') ? $this->escape($item->parent_title) : '',

			'category_parent_url' => $item_params->get('link_parent_category') && $item->parent_slug ? JRoute::_(ContentHelperRoute::getCategoryRoute($item->parent_slug)) : '',

			'hook_aftertitle' => !$item_params->get('show_intro') ? '' : '',

			'hook_beforearticle' => '',

			'hook_afterarticle' => '',

			'article' => $item_params->get('show_intro') ? $item->introtext : '',

			'tags' => '',

			'edit' => '',

			'url' => '',

			'url_attribs' => '',

			'more' => '',

			'previous' => '',

			'next' => ''

		);

		

		// set author

		$author = $item->created_by_alias ?: $item->author;

		$args['author'] = $item_params->get('show_author') && !empty($author) ? $author : '';

		

		// set edit

		$args['edit']  = $canEdit ? JHtml::_('icon.edit', $item, $item_params) : '';

		//$args['edit'] .= $item_params->get('show_print_icon') ? JHtml::_('icon.print_popup', $item, $item_params) : '';

		//$args['edit'] .= $item_params->get('show_email_icon') ? JHtml::_('icon.email', $item, $item_params) : '';

		

		// set url

		$item->slug = $item->id.':'.$item->alias;

		

		if ($item_params->get('access-view')) {

			$link = JRoute::_(ContentHelperRoute::getArticleRoute($item->slug, $item->catid));

		} else {

			$menu = JFactory::getApplication()->getMenu();

			$active = $menu->getActive();

			$itemId = $active->id;

			$link1 = JRoute::_('index.php?option=com_users&view=login&Itemid=' . $itemId);

			$returnURL = JRoute::_(ContentHelperRoute::getArticleRoute($item->slug, $item->catid));

			$link = new JURI($link1);

			$link->setVar('return', base64_encode($returnURL));

		}

		$args['url'] = $link;

		

		// set more

		if ($item_params->get('show_readmore') ) {

			if (!$item_params->get('access-view')) {

				$args['more'] = JText::_('COM_CONTENT_REGISTER_TO_READ_MORE');

			} elseif ($readmore = $item->alternative_readmore) {

				$args['more'] = $readmore;

			} else {

				$args['more'] = JText::_('TPL_WARP_CONTINUE_READING');

			}

		}

		

		/* Add URL A */

		$item->link = $args['url'];

		$url = $warp['siniestro']->articleLink($item);

		$args['url'] = $url['link'];

		$args['url_attribs'] = $url['url_attribs'];

        ?>

        

        <div class="uk-width-small-1-2 uk-width-large-1-3">

        	<div class="uk-panel uk-panel-teaser">

				<?php echo $warp['template']->render('article.teaser', $args); ?>

            </div>

        </div>

        

    <?php 

    } ?>

</div>



