<?php
/**
* @package   Warp Theme Framework
* @author    YOOtheme http://www.yootheme.com
* @copyright Copyright (C) YOOtheme GmbH
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Warp\Siniestro\Helper;

use Warp\Warp;
use Warp\Helper\AbstractHelper;

/**
 * Event helper class to manage events.
 */
class EventHelper extends AbstractHelper
{
    /**
     * @var array
     */
    protected $events = array();

    /**
     * Bind a function to an event.
     * 
     * @param  string $event   
     * @param  mixed $callback
     */
    public function bind($event, $callback)
    {
        if (!isset($this->events[$event])) {
            $this->events[$event] = array();
        }

        $this->events[$event][] = $callback;
    }

    /**
     * Trigger Event
     * 
     * @param  string $event 
     * @param  array  $args  
     */
    public function trigger($event, $args = array())
    {
        if (isset($this->events[$event])) {
            foreach ($this->events[$event] as $callback) {
                $this->_call($callback, $args);
            }
        }
    }
	
	/* add phavlo
		Function: _call
			Execute function call

		Returns:
			Mixed
	*/	
	protected function _call($function, $args = array()) {

		if (is_array($function)) {

			list($object, $method) = $function;

			if (is_object($object)) {
				switch (count($args)) { 
					case 0 :
						return $object->$method();
						break;
					case 1 : 
						return $object->$method($args[0]); 
						break; 
					case 2: 
						return $object->$method($args[0], $args[1]); 
						break; 
					case 3: 
						return $object->$method($args[0], $args[1], $args[2]); 
						break; 
					case 4: 
						return $object->$method($args[0], $args[1], $args[2], $args[3]); 
						break; 
				} 
			}

		}

		return call_user_func_array($function, $args);                               
	}
}
