<?php
/**
* @package   Warp Theme Framework
* @author    YOOtheme http://www.yootheme.com
* @copyright Copyright (C) YOOtheme GmbH
* @license   http://www.gnu.org/licenses/gpl.html GNU/GPL
*/

namespace Warp\Siniestro\Helper;

use Warp\Warp;
use Warp\Helper\AbstractHelper;

/**
 * Joomla! system helper class, provides Joomla! CMS integration (http://www.joomla.org).
 */
class SiniestroHelper extends AbstractHelper
{
    /**
     * System application.
     *
     * @var object
     */
    public $application;

    /**
     * System document.
     *
     * @var object
     */
    public $document;

    /**
     * Constructor.
     *
     * @param Warp $warp
     */
    public function __construct(Warp $warp)
    {
        parent::__construct($warp);

        // init vars
        $this->application = \JFactory::getApplication();
        $this->document    = \JFactory::getDocument();
        
    }

    /**
     * Initialize get link article.
     */
    public function articleLink($item)
    {
        // get application
        $app = $this->application;
		
		$urls = json_decode($item->urls);
		
		$url = array('link' => $item->link, 'url_attribs' => '');
			
		/* Add url */
		if ($item->params->get('link_titles') && $item->params->get('access-view') && ($urls && ($urls->urla)) )
		{
			$url['link'] = htmlspecialchars($urls->urla);
			
			//$urls->urla, $urls->urlatext, $urls->targeta
			$item->url_attribs = '';
			switch ($urls->targeta)
			{
				case 1:
					// open in a new window
					$url['url_attribs'] = 'target="_blank"  rel="nofollow"';
					break;
			
				case 2:
					// open in a popup window
					$attribs = 'toolbar=no,location=no,status=no,menubar=no,scrollbars=yes,resizable=yes,width=600,height=600';
					$url['url_attribs'] = "onclick=\"window.open(this.href, 'targetWindow', '".$attribs."'); return false;\"";
					break;
				case 3:
					// open in a modal window
					$url['url_attribs'] = 'data-lightbox="type:iframe;width:600;height:600;"';
					break;
			
				default:
					// open in parent window
					$url['url_attribs'] = 'rel="nofollow"';
					break;
			}
		}
		
		return $url;
		
    }

    /**
	 * Retrieve the active module count at a position
	 *
	 * @param  string $position
	 * @return integer
	 */
	public function countWidgets($condition)
	{		
		$operators = '(\+|\-|\*|\/|==|\!=|\<\>|\<|\>|\<=|\>=|and|or|xor)';
		$words = preg_split('# ' . $operators . ' #', $condition, null, PREG_SPLIT_DELIM_CAPTURE);

		if (count($words) === 1)
		{
			$name = strtolower($words[0]);
			
			//$result = ((isset(parent::$_buffer['modules'][$name])) && (parent::$_buffer['modules'][$name] === false)) ? 0 : count(JModuleHelper::getModules($name));
			$modules = \JModuleHelper::getModules($name);

			foreach ($modules as $key => $module) 
			{
				if($module->module == 'mod_cf_filtering' && $this->application->input->get('view', '') == 'productdetails'){
					unset($modules[$key]);
				}
			}
						
			$result = count($modules);

			return $result;
		}

		for ($i = 0, $n = count($words); $i < $n; $i += 2)
		{
			// Odd parts (modules)
			$name = strtolower($words[$i]);
			
			//$words[$i] = ((isset(parent::$_buffer['modules'][$name])) && (parent::$_buffer['modules'][$name] === false)) ? 0: count(\JModuleHelper::getModules($name));
			
			$modules = \JModuleHelper::getModules($name);
			$words[$i] = count($modules);
		}

		$str = 'return ' . implode(' ', $words) . ';';

		return eval($str);

	}
	
	/**
     * Initialize get link article.
     */
	public function addOGTags($og_tags = array())
	{
		$document = $this->document;
		$app = $this->application;
		$uri = \JURI::getInstance();

		
		$default_og_tags = array(
			'title' => $document->getTitle(),
			'site_name' => $app->getCfg('sitename'),
			'url' => $uri->toString(),
			'description' => $document->getDescription()
		);
		
		if( \JFile::exists(JPATH_ROOT . '/images/fb_default.jpg') ){
			$default_og_tags['image'] = \JURI::root() . 'images/fb_default.jpg'; // 600x315 - 1200x630
		}
		
		$og_tags = array_merge($default_og_tags, $og_tags);
		$og_tags = array_filter($og_tags);
		
		foreach($og_tags as $property => $content){
			$document->addCustomTag('<meta property="og:'.$property.'" content="'.$content.'"/>');
			//$document->setMetaData('og:'.$property, $content);
		}
		
		//$document->addCustomTag('<meta property="fb:app_id" content=""/>');
		
		return;
	}

}


