<?php

return array(

    'name' => 'content/facebook',

    'main' => 'YOOtheme\\Widgetkit\\Content\\Facebook\\FacebookType',

    'autoload' => array(
        'YOOtheme\\Widgetkit\\Content\\Facebook\\' => 'src'
    ),

    'config' => array(

        'name' => 'facebook',
        'label' => 'Facebook',
        'icon' => 'plugins/content/facebook/content.svg',
        'item' => array('title', 'content', 'media', 'link'),
        'data' => array(
            'source' => 'feed',
            'limit' => 5,
			'media' => 'normal',
			'limit_content' => 140,
			'app_id' => '',
			'app_secret' => ''
        )

    ),

    'items' => function ($items, $content, $app) {
		
		if (!isset($content['app_id']) || !$content['app_id'] || !isset($content['app_secret']) || !$content['app_secret']) {
            $items->add(array('title' => 'Fecebook Error | App id or App secret', 'content' => 'Please check your Facebook Settings.'));
        }
		
		// determine api method and parameters
        $params = array('limit' => (int) $content['limit']);
        $method = $content['source'];
		$params['search'] = $content['search'];

        // fetch photos
        try {
						
			$fb_items = $app['facebook']->fetch($method, array('app_id' => $content['app_id'], 'app_secret' => $content['app_secret']), $params, $content);
			
            foreach ($fb_items as $fb_item) {
                $items->add($fb_item);
            }

        } catch (\Exception $e) {

            $items->add(array('title' => 'Fecebook Error', 'content' => 'Fetching facebook items failed with message: ' . $e->getMessage()));
        }
    },

    'events' => array(

        'init.admin' => function ($event, $app) {
            $app['scripts']->add('widgetkit-facebook-controller', 'plugins/content/facebook/assets/controller.js');
			$app['angular']->addTemplate('facebook.edit', 'plugins/content/facebook/views/edit.php');
			
			$app->extend('translator', function ($translator, $app) {
    	        return $translator->addResource('plugins/content/facebook/languages/'.$app['locale'].'.json');
	        });
        }

    )

);
