<?php

return array(

    'name' => 'content/youtube',

    'main' => 'YOOtheme\\Widgetkit\\Content\\Youtube\\YoutubeType',

    'autoload' => array(
        'YOOtheme\\Widgetkit\\Content\\Youtube\\' => 'src'
    ),

    'config' => array(

        'name' => 'youtube',
        'label' => 'Youtube',
        'icon' => 'plugins/content/youtube/content.svg',
        'item' => array('title', 'content', 'media', 'link'),
        'data' => array(
            'source' => 'playlist_id',
            'limit' => 5,
            'title' => 'title',
			'media' => 'high',
			'key' => ''
        )

    ),

    'items' => function ($items, $content, $app) {
		
		// determine api method and parameters
        $params = array('limit' => (int) $content['limit']);

        if ($content['source'] == 'playlist_id') {
            $method = 'playlist_id';
        } else {
            $method = 'search_videos';
        }
		
		$params['search'] = $content['search'];

        // fetch videos
        try {

			$videos = $app['youtube']->fetch($method, $content['key'], $params, $content);
			
            foreach ($videos as $video) {
                $items->add($video);
            }

        } catch (\Exception $e) {

            $items->add(array('title' => 'Youtube Error', 'content' => 'Fetching youtube videos failed with message: ' . $e->getMessage()));
        }
    },

    'events' => array(

        'init.admin' => function ($event, $app) {
            $app['scripts']->add('widgetkit-youtube-controller', 'plugins/content/youtube/assets/controller.js');
			$app['angular']->addTemplate('youtube.edit', 'plugins/content/youtube/views/edit.php');
			
			$app->extend('translator', function ($translator, $app) {
    	        return $translator->addResource('plugins/content/youtube/languages/'.$app['locale'].'.json');
	        });
        }

    )

);
