<?php

return array(

    'name' => 'widget/grid-accordion',

    'main' => 'YOOtheme\\Widgetkit\\Widget\\Widget',

    'config' => array(

        'name'  => 'grid-accordion',
        'label' => 'Grid Accordion',
        'core'  => true,
        'icon'  => 'plugins/widgets/grid-accordion/widget.svg',
        'view'  => 'plugins/widgets/grid-accordion/views/widget.php',
        'item'  => array('title', 'content', 'media'),
        'settings' => array(
            'grid'                => 'default',
            'gutter'              => 'default',
            'columns'             => '5',
            'columns_active'       => 2,
            'panel'               => 'blank',
            'panel_link'          => false,
            
            'media'               => true,
            'image_width'         => 'auto',
            'image_height'        => 'auto',
            'media_align'         => 'teaser',
            
            'title'               => true,
            'content'             => true,
            'social_buttons'      => true,
            'title_size'          => 'panel',
            'text_align'          => 'left',
            'link'                => true,
            'link_style'          => 'button',
            'link_text'           => 'Read more',
            'badge'               => true,
            'badge_style'         => 'badge',
            'badge_position'      => 'panel',
            
            'link_target'         => false,
            'class'               => ''
        )

    ),

    'events' => array(

        'init.site' => function($event, $app) {
            //$app['scripts']->add('uikit-grid-accordion', 'vendor/assets/uikit/js/components/grid.min.js', array('uikit'));
        },

        'init.admin' => function($event, $app) {
            $app['angular']->addTemplate('grid-accordion.edit', 'plugins/widgets/grid-accordion/views/edit.php', true);
        }

    )

);
