<?php

// Id
$settings['id'] = substr(uniqid(), -3);

// Grid
$grid  = 'uk-grid-width-medium-1-'.$settings['columns'];

$gridw = 'uk-width-medium-'.$settings['columns_active'].'-'.$settings['columns'];

$grid .= ' uk-grid uk-grid-match';
$grid .= ($settings['gutter'] == 'collapse') ? ' uk-grid-collapse' : '' ;
$grid .= ($settings['gutter'] == 'small') ? ' uk-grid-small' : '' ;
$grid .= ($settings['gutter'] == 'medium') ? ' uk-grid-medium' : '' ;
$grid_js = 'data-uk-grid-match="{target:\'> div > .uk-panel\', row:true}" data-uk-grid-margin';

// Panel
$panel     = 'uk-panel';
$panel_alt = '';
switch ($settings['panel']) {
    case 'box' :
        $panel .= ' uk-panel-box';
        break;
    case 'primary' :
        $panel .= ' uk-panel-box uk-panel-box-primary';
        break;
    case 'secondary' :
        $panel .= ' uk-panel-box uk-panel-box-secondary';
        break;
    case 'hover' :
        $panel .= ' uk-panel-hover';
        break;
    case 'header' :
        $panel .= ' uk-panel-header';
        break;
    case 'space' :
        $panel .= ' uk-panel-space';
        break;
    case 'sequence1' :
        $panel .= ' uk-panel-box';
        $panel_alt = 'uk-panel uk-panel-box uk-panel-box-primary';
        break;
    case 'sequence2' :
        $panel .= ' uk-panel-box';
        $panel_alt = 'uk-panel uk-panel-box uk-panel-box-secondary';
        break;
    case 'sequence3' :
        $panel .= ' uk-panel-box uk-panel-box-primary';
        $panel_alt = 'uk-panel uk-panel-box uk-panel-box-secondary';
        break;
}

// Panel Sequence
$panel = array(
    $panel,
    $panel_alt ? $panel_alt : $panel
);

// Title Size
switch ($settings['title_size']) {
    case 'panel':
        $title_size = 'uk-panel-title';
        break;
    case 'large':
        $title_size = 'uk-heading-large uk-margin-top-remove';
        break;
    default:
        $title_size = 'uk-' . $settings['title_size'] . ' uk-margin-top-remove';
}

// Link Style
switch ($settings['link_style']) {
    case 'button':
        $link_style = 'uk-button';
        break;
    case 'primary':
        $link_style = 'uk-button uk-button-primary';
        break;
    case 'button-large':
        $link_style = 'uk-button uk-button-large';
        break;
    case 'primary-large':
        $link_style = 'uk-button uk-button-large uk-button-primary';
        break;
    case 'button-link':
        $link_style = 'uk-button uk-button-link';
        break;
    default:
        $link_style = '';
}

// Badge Style
switch ($settings['badge_style']) {
    case 'badge':
        $badge_style = 'uk-badge';
        break;
    case 'success':
        $badge_style = 'uk-badge uk-badge-success';
        break;
    case 'warning':
        $badge_style = 'uk-badge uk-badge-warning';
        break;
    case 'danger':
        $badge_style = 'uk-badge uk-badge-danger';
        break;
    case 'text-muted':
        $badge_style  = 'uk-text-muted';
        $badge_style .= ($settings['badge_position'] == 'panel') ? ' uk-panel-badge' : '';
        break;
    case 'text-primary':
        $badge_style  = 'uk-text-primary';
        $badge_style .= ($settings['badge_position'] == 'panel') ? ' uk-panel-badge' : '';
        break;
}

// Link Target
$link_target = ($settings['link_target']) ? ' target="_blank"' : '';

?>

<div id="wk-grid<?php echo $settings['id']; ?>" class="<?php echo $grid; ?> uk-text-<?php echo $settings['text_align']; ?> <?php echo $settings['class']; ?>" <?php echo $grid_js ?>>

<?php foreach ($items as $i => $item) :

        // Social Buttons
        $socials = '';
        if ($settings['social_buttons']) {
            $socials .= $item['twitter'] ? '<div><a class="uk-icon-button uk-icon-twitter" href="'. $item->escape('twitter') .'"></a></div>': '';
            $socials .= $item['facebook'] ? '<div><a class="uk-icon-button uk-icon-facebook" href="'. $item->escape('facebook') .'"></a></div>': '';
            $socials .= $item['google-plus'] ? '<div><a class="uk-icon-button uk-icon-google-plus" href="'. $item->escape('google-plus') .'"></a></div>': '';
            $socials .= $item['email'] ? '<div><a class="uk-icon-button uk-icon-envelope-o" href="mailto:'. $item->escape('email') .'"></a></div>': '';
        }
        
        // Media Type
        $attrs  = array('class' => '');
        $width  = $item['media.width'];
        $height = $item['media.height'];

        if ($item->type('media') == 'image') {
            $attrs['alt'] = strip_tags($item['title']);
            
            $width  = ($settings['image_width'] != 'auto') ? $settings['image_width'] : '';
            $height = ($settings['image_height'] != 'auto') ? $settings['image_height'] : '';
        }

        if ($item->type('media') == 'video') {
            $attrs['class'] = 'uk-responsive-width';
            $attrs['controls'] = true;
        }

        if ($item->type('media') == 'iframe') {
            $attrs['class'] = 'uk-responsive-width';
        }

        $attrs['width']  = ($width) ? $width : '';
        $attrs['height'] = ($height) ? $height : '';

        if (($item->type('media') == 'image') && ($settings['image_width'] != 'auto' || $settings['image_height'] != 'auto')) {
            $media = $item->thumbnail('media', $width, $height, $attrs);
        } else {
            if(($item->type('media') == 'image') && $settings['gutter_dynamic']){

                // adding the size of the original image to the attributes, so that on load the canvas can be created ( see script at the end of the file ).
                if ($img  = $app['image']->create($item->get('media'))) {
                    $size = getimagesize($img->getPathName());
                    $width  = $size[0];
                    $height = $size[1];
                    $attrs['width'] = $width;
                    $attrs['height'] = $height;
                }
            }
            $media = $item->media('media', $attrs);
        }
        
        // Link and Overlay
        $panel_hover   = '';

        if ($item['link']) {

            if ($settings['panel_link']) {

                $panel_hover .= ($settings['panel'] == 'box') ? ' uk-panel-box-hover' : '';
                $panel_hover .= ($settings['panel'] == 'primary') ? ' uk-panel-box-primary-hover' : '';
                $panel_hover .= ($settings['panel'] == 'secondary') ? ' uk-panel-box-secondary-hover' : '';

                if ($settings['panel'] == 'sequence1') {
                    $panel_hover .= !($i % 2)  ? ' uk-panel-box-hover' : ' uk-panel-box-primary-hover';
                }
                if ($settings['panel'] == 'sequence2') {
                    $panel_hover .= !($i % 2)  ? ' uk-panel-box-hover' : ' uk-panel-box-secondary-hover';
                }
                if ($settings['panel'] == 'sequence3') {
                    $panel_hover .= !($i % 2)  ? ' uk-panel-box-primary-hover' : ' uk-panel-box-secondary-hover';
                }

            }

        }
        
        // Meta
        $meta = '';
        if ($item['date']) {
            $date = '<time datetime="'.$item['date'].'">'.$app['date']->format($item['date']).'</time>';
            if ($item['author']) {
                $meta = $app['translator']->trans('Written by %author% on %date%',  array('%author%' => $item['author'], '%date%' => $date));
            } else {
                $meta = $app['translator']->trans('Written on %date%',  array('%date%' => $date));
            }
        } elseif ($item['author']) {
            $meta = $app['translator']->trans('Written by %author%',  array('%author%' => $item['author']));
        }

        // Panel Title last
        if ($settings['title_size'] == 'panel' &&
            !($meta) &&
            !($item['media'] && $settings['media'] && $settings['media_align'] == 'bottom') &&
            !($item['content'] && $settings['content']) &&
            !($item['link'] && $settings['link'])) {
                $title_size .= ' uk-margin-bottom-remove';
        }

    ?>

    <div>
        <div class="<?php echo $panel[$i % 2]; ?><?php echo $panel_hover; ?>">

            <?php if ($item['link'] && $settings['panel_link']) : ?>
            <a class="uk-position-cover uk-position-z-index" href="<?php echo $item->escape('link'); ?>"<?php echo $link_target; ?>></a>
            <?php endif; ?>

            <?php if ($item['badge'] && $settings['badge'] && $settings['badge_position'] == 'panel') : ?>
            <div class="uk-panel-badge <?php echo $badge_style; ?>"><?php echo $item['badge']; ?></div>
            <?php endif; ?>

            <?php if ($item['media'] && $settings['media'] && in_array($settings['media_align'], array('teaser', 'top'))) : ?>
            <div class="uk-text-center <?php echo (($settings['media_align'] == 'teaser') ? 'uk-panel-teaser' : 'uk-margin uk-margin-top-remove'); ?>"><?php echo $media; ?></div>
            <?php endif; ?>
            
            <?php if ($item['title'] && $settings['title']) : ?>
            <h3 class="<?php echo $title_size; ?>">

                <?php if ($item['link']) : ?>
                    <a class="uk-link-reset" href="<?php echo $item->escape('link'); ?>"<?php echo $link_target; ?>><?php echo $item['title']; ?></a>
                <?php else : ?>
                    <?php echo $item['title']; ?>
                <?php endif; ?>

                <?php if ($item['badge'] && $settings['badge'] && $settings['badge_position'] == 'title') : ?>
                <span class="uk-margin-small-left <?php echo $badge_style; ?>"><?php echo $item['badge']; ?></span>
                <?php endif; ?>

            </h3>
            <?php endif; ?>

            <?php if ($meta) : ?>
            <p class="uk-article-meta"><?php echo $meta; ?></p>
            <?php endif; ?>

            <?php if ($item['media'] && $settings['media'] && $settings['media_align'] == 'bottom') : ?>
            <div class="uk-margin uk-text-center"><?php echo $media; ?></div>
            <?php endif; ?>

            <?php if ($item['content'] && $settings['content']) : ?>
            <div class="uk-margin"><?php echo $item['content']; ?></div>
            <?php endif; ?>

            <?php if ($socials && ($settings['media_overlay'] != 'social-buttons')) : ?>
            <div class="uk-grid uk-grid-small uk-flex-<?php echo $settings['text_align']; ?>" data-uk-grid-margin><?php echo $socials; ?></div>
            <?php endif; ?>

            <?php if ($item['link'] && $settings['link']) : ?>
            <p><a<?php if($link_style) echo ' class="' . $link_style . '"'; ?> href="<?php echo $item->escape('link'); ?>"<?php echo $link_target; ?>><?php echo $app['translator']->trans($settings['link_text']); ?></a></p>
            <?php endif; ?>

        </div>
    </div>

<?php endforeach; ?>

</div>

<script>
    (function($){
        // get the images of the grid and replace it by a canvas of the same size to fix the problem with overlapping images on load.
        $('img', $('#wk-grid<?php echo $settings['id']; ?>')).each(function()
        {
            var $img = $(this),
                $canvas = $('<div></div>'),
                img = new Image;

            $img.addClass('uk-hidden');
            $img.after($canvas);
            
            $canvas.css({
            	background: 'url('+this.src+')',
            	'background-repeat': 'no-repeat',
            	//'background-size': 'cover',
            	height: $img.attr('height')
            });

        });

        $('#wk-grid<?php echo $settings['id']; ?>').children().eq(0).addClass('<?php echo $gridw; ?>');

        $('> div > div', $('#wk-grid<?php echo $settings['id']; ?>')).each(function()
        {
        	var $panel = $(this);

        	$panel.css({
        		overflow: 'hidden'
        	});

        	$(this).parent().css({
        		transition: 'all 0.5s ease 0s'
        	})

        	$panel.on('mouseenter', function(event)
        	{
        		$(this).parent().parent().children().each(function(){
        			$(this).removeClass('<?php echo $gridw; ?>');	
        		});

        		$(this).parent().addClass('<?php echo $gridw; ?>');
        	});

        });

    })(jQuery);
</script>
