(function(addon) {

    var component;

    if (window.UIkit) {
        component = addon(UIkit);
    }

    if (typeof define == "function" && define.amd) {
        define("uikit-youtube", ["uikit"], function() {
            return component || addon(UIkit);
        });
    }

})(function(UI) {

    "use strict";

    var playerId = 0;

    UI.component('youtube', {

        defaults: {
            height 			: "auto",
            start 			: 0,
            listautoplay	: true,
            videomute 		: false,
			playerVars 		: {
				autohide		: 1,
				autoplay		: 0,
				color			: 'red', // red, white
				controls		: 2, // 0, 1 o 2
				fs				: 1,
				iv_load_policy	: 3, // 1, 3
				modestbranding	: 1,
				rel				: 0,
				showinfo		: 0,
				theme			: 'dark' // dark, light
			}
        },

        current: false,

        boot: function() {

            // init code
            UI.ready(function(context) {

                UI.$('[data-uk-youtube]', context).each(function() {

                    var youtube = UI.$(this);

                    if (!youtube.data("youtube")) {
                        var obj = UI.youtube(youtube, UI.Utils.options(youtube.attr("data-uk-youtube")));
                    }
                });
            });
        },

        init: function() {
								
			var $this = this;
			
			this.container 	= this.element;
			this.iframe 	= UI.$(this.find('#yt-video-player'));
			this.list 		= UI.$(this.find('.uk-youtube-list')).children();
			this.listCount 	= this.list.length;
			this.current 	= this.options.start;
			this.triggers 	= this.find('[data-uk-youtube-item]');
			this.video_player = null;
			
			var tag = document.createElement('script');
		    tag.src = "https://www.youtube.com/iframe_api";
		    var firstScriptTag = document.getElementsByTagName('script')[0];
		    firstScriptTag.parentNode.insertBefore(tag, firstScriptTag);
			
			window.onYouTubeIframeAPIReady = function() {
				$this.video_player = new YT.Player($this.iframe.get(0), {
					width: '560',
					height: '315',
					videoId: $this.iframe.attr('data-uk-youtube-id'),
					playerVars: $this.options.playerVars,
					events: {
						'onReady': $this.onPlayerReady,
						'onStateChange': function(event){
							$this.onPlayerStateChange(event);
						}
					}
				});
			}
															
            this.on("click.uikit.youtube", '[data-uk-youtube-item]', function(e) {

                e.preventDefault();
				
				var video = UI.$(this).attr('data-uk-youtube-item'); // UI.$(this).index();
                				
                if ($this.current == video) return;

                switch(video) {
                    case 'next':
                    case 'previous':
                        $this[video=='next' ? 'next':'previous']();
                        break;
                    default:
                        $this.show(parseInt(video, 10));
                }

                $this.stop();
            });
			
            // Set start video
            this.list.eq(this.current).addClass('uk-active');
            this.triggers.filter('[data-uk-youtube-item="'+this.current+'"]').addClass('uk-active');
			
            UI.$win.on("resize load", UI.Utils.debounce(function() {
                $this.resize();
            }, 100));

            // chrome image load fix
            setTimeout(function(){
                $this.resize();
            }, 80);
			            
            this.on('display.uk.check', function(){
                if ($this.element.is(":visible")) {
                    $this.resize();
                }
            });
        },
		
		onPlayerReady: function(event) {
			var $this = this;
			//event.target.playVideo();
		},
		
		onPlayerStateChange: function(event) {
			
			var $this = this;
			
			switch(event.data) {
				case YT.PlayerState.ENDED:
					//console.log('Video has ended.');
					if($this.options.listautoplay) $this.next();
					break;
				case YT.PlayerState.PLAYING:
					//console.log('Video is playing.');
					break;
				case YT.PlayerState.PAUSED:
					//console.log('Video is paused.');
					break;
				case YT.PlayerState.BUFFERING:
					//console.log('Video is buffering.');
					break;
				case YT.PlayerState.CUED:
					//console.log('Video is cued.');
					break;
				default:
					//console.log('Unrecognized state.');
					break;
			}
		},
		
		show: function(index, direction) {
			
            if (this.current == index) return;
			
            var $this        = this,
                current      = this.list.eq(this.current),
                next         = this.list.eq(index),
                dir          = direction ? direction : this.current < index ? -1 : 1,
                finalize     = function() {
					
                    next.addClass("uk-active");
                    current.removeClass("uk-active");
										
                    $this.current   = index;

                    $this.trigger('show.uk.youtube', [next]);
					
					$this.video_player.loadVideoById(next.attr('data-uk-youtube-id')).playVideo();
                };

            current = UI.$(current);
            next    = UI.$(next);
			
			finalize();

            $this.triggers.removeClass('uk-active');
            $this.triggers.filter('[data-uk-youtube-item="'+index+'"]').addClass('uk-active');
        },

        next: function() {
			var $this = this;
			
			UI.$(this.find('.yt-panel-list')).animate({
				scrollTop: $this.list.eq(this.list[this.current + 1] ? (this.current + 1) : 0).offset().top - UI.$(this.find('.yt-panel-list')).offset().top + UI.$(this.find('.yt-panel-list')).scrollTop()
			}, 1000);
			
            this.show(this.list[this.current + 1] ? (this.current + 1) : 0);
        },

        previous: function() {
            var $this = this;
			
			UI.$(this.find('.yt-panel-list')).animate({
				scrollTop: $this.list.eq(this.list[this.current - 1] ? (this.current - 1) : (this.list.length - 1)).offset().top - UI.$(this.find('.yt-panel-list')).offset().top + UI.$(this.find('.yt-panel-list')).scrollTop()
			}, 1000);
						
			this.show(this.list[this.current - 1] ? (this.current - 1) : (this.list.length - 1));
        },

        resize: function() {

            var $this = this, height = this.options.height;

            if (this.options.height === 'auto') {

                height = 0;
				height = UI.$(this.find('.yt-panel-iframe')).height();

            }
			
			UI.$(this.find('.yt-panel-list')).css('height', height);
			UI.$(this.find('.yt-panel-list')).css('overflow', 'auto');
        },

        start: function() {

            this.stop();

            var $this = this;

        },

        stop: function() {
        }
    });

});
